#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 2.0.6
id: pandoc-2.0.6-E3cz6M2Jc0PHCCwuCZd6uH
key: pandoc-2.0.6-E3cz6M2Jc0PHCCwuCZd6uH
license: GPL
copyright: (c) 2006-2017 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: http://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook, JATS,
    MediaWiki markup, TWiki markup, TikiWiki markup, Creole 1.0,
    Haddock markup, OPML, Emacs Org-Mode, Emacs Muse, txt2tags,
    Vimwiki, Word Docx, ODT, and Textile, and it can write
    Markdown, reStructuredText, XHTML, HTML 5, LaTeX, ConTeXt,
    DocBook, JATS, OPML, TEI, OpenDocument, ODT, Word docx,
    RTF, MediaWiki, DokuWiki, ZimWiki, Textile, groff man,
    groff ms, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign
    ICML, Muse, LaTeX beamer slides, PowerPoint, and several
    kinds of HTML/JavaScript slide shows (S5, Slidy, Slideous,
    DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
author: John MacFarlane <jgm@berkeley.edu>
exposed: True
indefinite: False
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.BCP47
    Text.Pandoc.Class Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Highlighting
    Text.Pandoc.ImageSize Text.Pandoc.Logging Text.Pandoc.Lua
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Pretty
    Text.Pandoc.Process Text.Pandoc.Readers
    Text.Pandoc.Readers.CommonMark Text.Pandoc.Readers.Creole
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.JATS
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.LaTeX.Types
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.Odt
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RST
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Vimwiki Text.Pandoc.SelfContained
    Text.Pandoc.Shared Text.Pandoc.Templates Text.Pandoc.UTF8
    Text.Pandoc.Writers Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.XML
hidden-modules: Text.Pandoc.Readers.Docx.Lists
                Text.Pandoc.Readers.Docx.Combine Text.Pandoc.Readers.Docx.Parse
                Text.Pandoc.Readers.Docx.Util Text.Pandoc.Readers.Docx.StyleMap
                Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.DocumentTree
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared Text.Pandoc.Lua.Filter
                Text.Pandoc.Lua.Init Text.Pandoc.Lua.Module.MediaBag
                Text.Pandoc.Lua.Module.Pandoc Text.Pandoc.Lua.Module.Utils
                Text.Pandoc.Lua.Packages Text.Pandoc.Lua.StackInstances
                Text.Pandoc.Lua.Util Text.Pandoc.CSS Text.Pandoc.CSV
                Text.Pandoc.UUID Text.Pandoc.Translations Text.Pandoc.Slides
                Text.Pandoc.Compat.Time Paths_pandoc
abi: 23fccf2f7f734da6aba9d4d4c4ff1c98
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/pandoc-2.0.6
library-dirs: /usr/lib/ghc-8.2.2/site-local/pandoc-2.0.6
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-2.0.6-E3cz6M2Jc0PHCCwuCZd6uH
depends:
    base-4.10.1.0 syb-0.7-3Lq8MQxmYP07qktjI1jxu0 containers-0.5.10.2
    unordered-containers-0.2.8.0-YOGDwOwys3HjU5i3g27KB
    parsec-3.1.11-1k1VJixRpBgKJgdIEz2OP7
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH filepath-1.4.1.2 process-1.6.1.0
    directory-1.3.0.2 bytestring-0.10.8.2
    text-1.2.3.0-6107d52Rn3mLJ1xgqHMkbj
    safe-0.3.15-EroU33EYnr02fGSZYGiX97
    zip-archive-0.3.2-FTIhzhP4GUy7li6SfqzQVs
    HTTP-4000.3.9-ApWtQyZuwl7B1of0Mr8gyM
    texmath-0.10.1-4UQmhceZDt91PdvZ9MKvVH
    xml-1.3.14-gmCpsUXEJ0Cd36ZPTskAU
    split-0.2.3.2-7cayvoeRj5XIrIBUB58mMy
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We
    pandoc-types-1.17.3-ES7pVjlaTSNIjka4FTuhZg
    aeson-1.2.3.0-FJ4ZIZuhkRcGxmRcOR28sg
    aeson-pretty-0.8.5-Hnqnb7gDvwKHnue1Umkfoa
    tagsoup-0.14.2-8vCyBcq5nO575IiMwnkeoi
    base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be
    zlib-0.6.1.2-3jYpKaDVsj2d994OadtMM
    skylighting-0.5.0.1-FbEL79NFfKzLKOHGXkKyQq
    data-default-0.7.1.1-FICujruwzSN8grhdf3Hr65
    temporary-1.2.1.1-7a1ypWDsHB4EWhBxWwtUro
    blaze-html-0.9.0.1-2Wxj0X1c4OOA0Fs6NGHGGN
    blaze-markup-0.8.2.0-JO1Oy9jYgbGFSxqAItqjWc
    yaml-0.8.28-KV5WyvHNO1oKdhGEixIgZX
    scientific-0.3.5.2-912lci9Mxyc8ladEwh7DIT
    vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4
    hslua-0.9.5-5wQoQFSbtdgKzugHejL4aP
    hslua-module-text-0.1.2.1-KVz9tEeNoT8HF4sZGmWsPR binary-0.8.5.1
    SHA-1.6.4.2-1gNz0XEXVc9D2LWQ8o29zI
    haddock-library-1.4.5-uQdrVGi1uKLD22IlKGc6n deepseq-1.4.3.0
    JuicyPixels-3.2.9.3-Bd3b7s6HYPVHgIWX3VKQkR
    Glob-0.9.1-FVwXGSnrAB8BlHn7BV1jg
    cmark-gfm-0.1.3-D4NajCuHPT6J2ZXIfca2cg
    doctemplates-0.2.1-6vOrgUYlZzc4MMq48S36pN
    http-client-0.5.8-ESOuZ6kjKPLHIM2bOriI30
    http-client-tls-0.3.5.1-9gAyYyJoygo6acoiZZ5azv
    http-types-0.9.1-4ZIPDJugy3GJAtyWZ0RpKv
    case-insensitive-1.2.0.10-AWseT79MXu13ZYpcQBCANd unix-2.7.2.2
    time-1.8.0.2 network-uri-2.6.1.0-BbYfQUrqmQG8TYLVq3Shq8
    network-2.6.3.3-BsPhUcUvmHlbFKWY24Oor
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             syb-0.7-3Lq8MQxmYP07qktjI1jxu0=f985ea42a9fa578e0f67572a93e19b5d
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             unordered-containers-0.2.8.0-YOGDwOwys3HjU5i3g27KB=1ae4406c8abf6f6a305796d42b6e1b7b
             parsec-3.1.11-1k1VJixRpBgKJgdIEz2OP7=5b8a6db8c81629fde3a12212030372e3
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             text-1.2.3.0-6107d52Rn3mLJ1xgqHMkbj=b7726d921cac66adc5c8f9f66f5b25f0
             safe-0.3.15-EroU33EYnr02fGSZYGiX97=604c7b7c109a34b58d71795df287548a
             zip-archive-0.3.2-FTIhzhP4GUy7li6SfqzQVs=8cb4b3fe4fc0ceec9a93e2f215deeac7
             HTTP-4000.3.9-ApWtQyZuwl7B1of0Mr8gyM=df9e6f99b8db89faa4d67de7ed0e9024
             texmath-0.10.1-4UQmhceZDt91PdvZ9MKvVH=62fe6dc57e6d1156a839dc30ea83d4b8
             xml-1.3.14-gmCpsUXEJ0Cd36ZPTskAU=d10a974e22e128d84bfcf55c875efa2c
             split-0.2.3.2-7cayvoeRj5XIrIBUB58mMy=797cd4cd973bcc2d6f301fd097dd3406
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=368a9f817c8c1b290191231dd0d81d85
             pandoc-types-1.17.3-ES7pVjlaTSNIjka4FTuhZg=cdda73a097819a046f9269d6f24033a7
             aeson-1.2.3.0-FJ4ZIZuhkRcGxmRcOR28sg=46fcdc3878bffec4becb1a9d32726698
             aeson-pretty-0.8.5-Hnqnb7gDvwKHnue1Umkfoa=210aec2ff6f4e2a44a8dd4b58be20ea4
             tagsoup-0.14.2-8vCyBcq5nO575IiMwnkeoi=24733e98e2a1e5488eafaab34583adab
             base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be=fd5db0dc9688093c1ac2c3223371478e
             zlib-0.6.1.2-3jYpKaDVsj2d994OadtMM=fc994ec0331fc01f98e1d968398a1aa2
             skylighting-0.5.0.1-FbEL79NFfKzLKOHGXkKyQq=3164eccd64cec1446b9163d7023ada08
             data-default-0.7.1.1-FICujruwzSN8grhdf3Hr65=f057e993f72fa1f980dd728ed8010ca1
             temporary-1.2.1.1-7a1ypWDsHB4EWhBxWwtUro=b8bff4b84b25638f1f5ef8924bbd6e32
             blaze-html-0.9.0.1-2Wxj0X1c4OOA0Fs6NGHGGN=d4749ddd32d1bff43101b58ffdfa6b64
             blaze-markup-0.8.2.0-JO1Oy9jYgbGFSxqAItqjWc=8e9b9ff2cdf9e89a23593b7f85e59200
             yaml-0.8.28-KV5WyvHNO1oKdhGEixIgZX=a7631eaf1dbe442d42b7121b8d0f4a01
             scientific-0.3.5.2-912lci9Mxyc8ladEwh7DIT=404255989f714abfb5b09cf0823e534e
             vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=d8375a46a4155c3f449ce3d319b3dbaa
             hslua-0.9.5-5wQoQFSbtdgKzugHejL4aP=f20344758ef99675163ddeff2087ef3c
             hslua-module-text-0.1.2.1-KVz9tEeNoT8HF4sZGmWsPR=1475a15ea429fd73bf5a5c7c1811e010
             binary-0.8.5.1=33c677d3ced9a5afbc7b354509494653
             SHA-1.6.4.2-1gNz0XEXVc9D2LWQ8o29zI=a1e214e4043a6e8594f125021a39000f
             haddock-library-1.4.5-uQdrVGi1uKLD22IlKGc6n=6190889e581e299524df9ddefc6f117b
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             JuicyPixels-3.2.9.3-Bd3b7s6HYPVHgIWX3VKQkR=a42e99ed3d3e7505583d5c2b992afd98
             Glob-0.9.1-FVwXGSnrAB8BlHn7BV1jg=75bdd85404256395d97c618fa68ae936
             cmark-gfm-0.1.3-D4NajCuHPT6J2ZXIfca2cg=b35e0b5136d6bc980ac8f1f62d09bf59
             doctemplates-0.2.1-6vOrgUYlZzc4MMq48S36pN=9e82cb5dd3b0d40e83e34cfca429fb1c
             http-client-0.5.8-ESOuZ6kjKPLHIM2bOriI30=a6ec97cc8553b880957c496811066ccb
             http-client-tls-0.3.5.1-9gAyYyJoygo6acoiZZ5azv=7b5c7dda4f61d6309517ed75bb879e16
             http-types-0.9.1-4ZIPDJugy3GJAtyWZ0RpKv=b80836ab18bdd54a07dfb2450d10ef5b
             case-insensitive-1.2.0.10-AWseT79MXu13ZYpcQBCANd=d2a631059bf8ed4631eaacfed742cab7
             unix-2.7.2.2=3df01ca0d7640dab598065ff1b1cffeb
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             network-uri-2.6.1.0-BbYfQUrqmQG8TYLVq3Shq8=ab32d4d3146164271ec97b5409cdba0c
             network-2.6.3.3-BsPhUcUvmHlbFKWY24Oor=f013b5448241bfbc78fb9f4b90b2582b
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

