#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tasty-rerun
version: 1.1.9
id: tasty-rerun-1.1.9-D6v4YNA9PkU8dOzdtaX86x
key: tasty-rerun-1.1.9-D6v4YNA9PkU8dOzdtaX86x
license: BSD3
copyright: Oliver Charles (c) 2014
maintainer: ollie@ocharles.org.uk
homepage: http://github.com/ocharles/tasty-rerun
synopsis: Run tests by filtering the test tree depending on the result of previous test
          runs
description:
    This ingredient adds the ability to run tests by first filtering the test tree
    based on the result of a previous test run. For example, you can use this to
    run only those tests that failed in the last run, or to run only tests that
    have been added since tests were last ran.
    .
    This ingredient is specifically an ingredient *transformer* - given a list of
    '\''Tasty.Ingredient'\''s, '\''rerunningTests'\'' adds the ability for all of these
    ingredients to run against a filtered test tree. This transformer can be
    applied as follows:
    .
    > import Test.Tasty
    > import Test.Tasty.Runners
    >
    > main :: IO ()
    > main =
    >   defaultMainWithIngredients
    >     [ rerunningTests [ listingTests, consoleTestReporter ] ]
    >     tests
    >
    > tests :: TestTree
    > tests = undefined
    .
    This ingredient adds three command line parameters:
    .
    [@--rerun-update@] If specified the results of this test run will be saved to
    the log file at @--rerun-log-file@. If the ingredient does not execute tests
    (for example, @--list-tests@ is used) then the log file will not be
    updated. This option is not enabled by default.  This option does not require
    a value.
    .
    [@--rerun-log-file@] The path to the log file to read previous test
    information from, and where to write new information to (if @--rerun-update@
    is specified). This option defaults to @.tasty-rerun-log@.
    .
    [@--rerun-filter@] Which filters to apply to the '\''Tasty.TestTree'\'' based on
    previous test runs. The value of this option is a comma separated list of the
    following options:
    .
    * @failures@: Only run tests that failed on the previous run.
    .
    * @exceptions@: Only run tests that threw an exception on the previous run.
    .
    * @new@: Only run tests that are new since the previous test run.
    .
    * @successful@: Only run tests that were successful in the previous run.
    .
    Multiple options can be combined and will be taken under disjunction - so
    @--rerun-filter=failures,exceptions@ will run only tests that failed *or*
    threw an exception on the last run.
    .
    Defaults to all filters, which means all tests will be ran.
category: Testing
author: Oliver Charles
exposed: True
indefinite: False
exposed-modules:
    Test.Tasty.Ingredients.Rerun
abi: 129594e35e447ef7580bcaea5b52840b
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/tasty-rerun-1.1.9
library-dirs: /usr/lib/ghc-8.2.2/site-local/tasty-rerun-1.1.9
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/tasty-rerun-1.1.9
hs-libraries: HStasty-rerun-1.1.9-D6v4YNA9PkU8dOzdtaX86x
depends:
    base-4.10.1.0 containers-0.5.10.2 mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    optparse-applicative-0.14.0.0-2ZfllZxq2ruLdMUolNlkAF
    reducers-3.12.2-4d0kZwlmWNqCOBDDe6KkGY
    split-0.2.3.2-7cayvoeRj5XIrIBUB58mMy
    stm-2.4.4.1-E6EjE1bszQZJ9orPdUNxjw
    tagged-0.8.5-BP06XmR1GLaIsvsOKwGst2
    tasty-0.12.0.1-I4w9I0dCLxy478DTOJf4WP transformers-0.5.2.0
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             optparse-applicative-0.14.0.0-2ZfllZxq2ruLdMUolNlkAF=2737f341ca406f3c57e161b5a93d63ac
             reducers-3.12.2-4d0kZwlmWNqCOBDDe6KkGY=8e06fb7e74b14aea359b3d3e57f296e0
             split-0.2.3.2-7cayvoeRj5XIrIBUB58mMy=797cd4cd973bcc2d6f301fd097dd3406
             stm-2.4.4.1-E6EjE1bszQZJ9orPdUNxjw=63c518eabfb1b430d925fb35cc544a7c
             tagged-0.8.5-BP06XmR1GLaIsvsOKwGst2=b5d07becd47ba21e20b584b61ad0f06d
             tasty-0.12.0.1-I4w9I0dCLxy478DTOJf4WP=92b071cb0ccddb6d6e12b252f2cb3004
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
haddock-interfaces: /usr/share/doc/haskell-tasty-rerun/html/tasty-rerun.haddock
haddock-html: /usr/share/doc/haskell-tasty-rerun/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

