/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.Instant;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.util.GitDateParser;
import org.eclipse.jgit.util.SystemReader;

class GcLog {
    private final FileRepository repo;
    private final File logFile;
    private final LockFile lock;
    private Instant gcLogExpire;
    private static final String LOG_EXPIRY_DEFAULT = "1.day.ago";
    private boolean nonEmpty = false;

    GcLog(FileRepository repo) {
        this.repo = repo;
        this.logFile = new File(repo.getDirectory(), "gc.log");
        this.lock = new LockFile(this.logFile);
    }

    private Instant getLogExpiry() throws ParseException {
        if (this.gcLogExpire == null) {
            String logExpiryStr = this.repo.getConfig().getString("gc", null, "logExpiry");
            if (logExpiryStr == null) {
                logExpiryStr = LOG_EXPIRY_DEFAULT;
            }
            this.gcLogExpire = GitDateParser.parse(logExpiryStr, null, SystemReader.getInstance().getLocale()).toInstant();
        }
        return this.gcLogExpire;
    }

    private boolean autoGcBlockedByOldLockFile(boolean background) {
        try {
            FileTime lastModified = Files.getLastModifiedTime(this.logFile.toPath(), new LinkOption[0]);
            if (lastModified.toInstant().compareTo(this.getLogExpiry()) > 0) {
                if (!background) {
                    BufferedReader reader2 = Files.newBufferedReader(this.logFile.toPath());
                    Throwable throwable = null;
                    try {
                        try {
                            char[] buf = new char[1000];
                            int len = reader2.read(buf, 0, 1000);
                            String oldError = new String(buf, 0, len);
                            throw new JGitInternalException(MessageFormat.format(JGitText.get().gcLogExists, oldError, this.logFile));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (reader2 != null) {
                            if (throwable != null) {
                                try {
                                    reader2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                reader2.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                return true;
            }
        }
        catch (NoSuchFileException lastModified) {
        }
        catch (IOException | ParseException e2) {
            throw new JGitInternalException(e2.getMessage(), e2);
        }
        return false;
    }

    boolean lock(boolean background) {
        try {
            if (!this.lock.lock()) {
                return false;
            }
        }
        catch (IOException e2) {
            throw new JGitInternalException(e2.getMessage(), e2);
        }
        if (this.autoGcBlockedByOldLockFile(background)) {
            this.lock.unlock();
            return false;
        }
        return true;
    }

    void unlock() {
        this.lock.unlock();
    }

    boolean commit() {
        if (this.nonEmpty) {
            return this.lock.commit();
        }
        this.logFile.delete();
        this.lock.unlock();
        return true;
    }

    void write(String content) throws IOException {
        if (content.length() > 0) {
            this.nonEmpty = true;
        }
        this.lock.write(content.getBytes(StandardCharsets.UTF_8));
    }
}

