/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonProcessors {
    private static final Processor FALSE = new Processor<Object>(){

        @Override
        public boolean process(Object t) {
            return false;
        }
    };
    private static final Processor TRUE = new Processor<Object>(){

        @Override
        public boolean process(Object t) {
            return true;
        }
    };

    public static class FindFirstProcessor<T>
    extends FindProcessor<T> {
        @Override
        protected boolean accept(T t) {
            return true;
        }
    }

    public static abstract class FindProcessor<T>
    implements Processor<T> {
        private T myValue;

        public boolean isFound() {
            return this.myValue != null;
        }

        @Nullable
        public T getFoundValue() {
            return this.myValue;
        }

        @Nullable
        public T reset() {
            T prev = this.myValue;
            this.myValue = null;
            return prev;
        }

        @Override
        public boolean process(T t) {
            if (this.accept(t)) {
                this.myValue = t;
                return false;
            }
            return true;
        }

        protected abstract boolean accept(T var1);
    }

    public static class CollectProcessor<T>
    implements Processor<T> {
        private final Collection<T> myCollection;

        public CollectProcessor(@NotNull Collection<T> collection) {
            if (collection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/CommonProcessors$CollectProcessor", "<init>"));
            }
            this.myCollection = collection;
        }

        public CollectProcessor() {
            this.myCollection = new ArrayList<T>();
        }

        @Override
        public boolean process(T t) {
            if (this.accept(t)) {
                this.myCollection.add(t);
            }
            return true;
        }

        protected boolean accept(T t) {
            return true;
        }
    }
}

