/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.tree.IElementType;
import java.lang.constant.Constable;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.And;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallReceiver;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CoercionValue;
import org.jetbrains.kotlin.codegen.DefaultCallArgs;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCallStackValue;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OperationStackValue;
import org.jetbrains.kotlin.codegen.Or;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public abstract class StackValue {
    public static final Local LOCAL_0 = StackValue.local(0, AsmTypes.OBJECT_TYPE);
    private static final StackValue UNIT = StackValue.operation(AsmTypes.UNIT_TYPE, v -> {
        v.visitFieldInsn(178, AsmTypes.UNIT_TYPE.getInternalName(), "INSTANCE", AsmTypes.UNIT_TYPE.getDescriptor());
        return null;
    });
    @NotNull
    public final Type type;
    private final boolean canHaveSideEffects;

    protected StackValue(@NotNull Type type2) {
        this(type2, true);
    }

    protected StackValue(@NotNull Type type2, boolean canHaveSideEffects) {
        this.type = type2;
        this.canHaveSideEffects = canHaveSideEffects;
    }

    public void moveToTopOfStack(@NotNull Type type2, @NotNull InstructionAdapter v, int depth) {
        this.put(type2, v);
    }

    public void put(@NotNull Type type2, @NotNull InstructionAdapter v) {
        this.put(type2, v, false);
    }

    public void put(@NotNull Type type2, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (!skipReceiver) {
            this.putReceiver(v, true);
        }
        this.putSelector(type2, v);
    }

    public abstract void putSelector(@NotNull Type var1, @NotNull InstructionAdapter var2);

    public boolean isNonStaticAccess(boolean isRead) {
        return false;
    }

    public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
    }

    public void dup(@NotNull InstructionAdapter v, boolean withReceiver) {
        if (!Type.VOID_TYPE.equals(this.type)) {
            AsmUtil.dup(v, this.type);
        }
    }

    public void store(@NotNull StackValue value, @NotNull InstructionAdapter v) {
        this.store(value, v, false);
    }

    public boolean canHaveSideEffects() {
        return this.canHaveSideEffects;
    }

    public void store(@NotNull StackValue value, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (!skipReceiver) {
            this.putReceiver(v, false);
        }
        value.put(value.type, v);
        this.storeSelector(value.type, v);
    }

    protected void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
        throw new UnsupportedOperationException("Cannot store to value " + this);
    }

    @NotNull
    public static Local local(int index2, @NotNull Type type2) {
        return new Local(index2, type2);
    }

    @NotNull
    public static Local local(int index2, @NotNull Type type2, @NotNull VariableDescriptor descriptor2) {
        return new Local(index2, type2, descriptor2.isLateInit(), descriptor2.getName());
    }

    @NotNull
    public static Delegate delegate(@NotNull Type type2, @NotNull StackValue delegateValue, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull ExpressionCodegen codegen) {
        return new Delegate(type2, delegateValue, metadataValue, variableDescriptor, codegen);
    }

    @NotNull
    public static StackValue shared(int index2, @NotNull Type type2) {
        return new Shared(index2, type2);
    }

    @NotNull
    public static StackValue shared(int index2, @NotNull Type type2, @NotNull VariableDescriptor descriptor2) {
        return new Shared(index2, type2, descriptor2.isLateInit(), descriptor2.getName());
    }

    @NotNull
    public static StackValue onStack(@NotNull Type type2) {
        return type2 == Type.VOID_TYPE ? StackValue.none() : new OnStack(type2);
    }

    @NotNull
    public static StackValue integerConstant(int value, @NotNull Type type2) {
        if (type2 == Type.LONG_TYPE) {
            return StackValue.constant(value, type2);
        }
        if (type2 == Type.BYTE_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.INT_TYPE) {
            return StackValue.constant(value, type2);
        }
        throw new AssertionError((Object)("Unexpected integer type: " + type2));
    }

    @NotNull
    public static StackValue constant(@Nullable Object value, @NotNull Type type2) {
        if (type2 == Type.BOOLEAN_TYPE) {
            assert (value instanceof Boolean) : "Value for boolean constant should have boolean type: " + value;
            return BranchedValue.Companion.booleanConstant((Boolean)value);
        }
        return new Constant(value, type2);
    }

    public static StackValue createDefaultValue(@NotNull Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return StackValue.constant(null, type2);
        }
        return StackValue.createDefaultPrimitiveValue(type2);
    }

    private static StackValue createDefaultPrimitiveValue(@NotNull Type type2) {
        assert (1 <= type2.getSort() && type2.getSort() <= 8) : "'createDefaultPrimitiveValue' method should be called only for primitive types, but " + type2;
        Constable value = 0;
        if (type2.getSort() == 1) {
            value = Boolean.FALSE;
        } else if (type2.getSort() == 6) {
            value = new Float(0.0);
        } else if (type2.getSort() == 8) {
            value = new Double(0.0);
        } else if (type2.getSort() == 7) {
            value = new Long(0L);
        }
        return StackValue.constant(value, type2);
    }

    @NotNull
    public static StackValue cmp(@NotNull IElementType opToken, @NotNull Type type2, StackValue left, StackValue right) {
        return BranchedValue.Companion.cmp(opToken, type2, left, right);
    }

    @NotNull
    public static StackValue not(@NotNull StackValue stackValue) {
        return BranchedValue.Companion.createInvertValue(stackValue);
    }

    public static StackValue or(@NotNull StackValue left, @NotNull StackValue right) {
        return new Or(left, right);
    }

    public static StackValue and(@NotNull StackValue left, @NotNull StackValue right) {
        return new And(left, right);
    }

    public static StackValue compareIntWithZero(@NotNull StackValue argument, int operation) {
        return new BranchedValue(argument, null, Type.INT_TYPE, operation);
    }

    public static StackValue compareWithNull(@NotNull StackValue argument, int operation) {
        return new BranchedValue(argument, null, AsmTypes.OBJECT_TYPE, operation);
    }

    @NotNull
    public static StackValue arrayElement(@NotNull Type type2, StackValue array, StackValue index2) {
        return new ArrayElement(type2, array, index2);
    }

    @NotNull
    public static StackValue collectionElement(CollectionElementReceiver collectionElementReceiver, Type type2, ResolvedCall<FunctionDescriptor> getter2, ResolvedCall<FunctionDescriptor> setter2, ExpressionCodegen codegen) {
        return new CollectionElement(collectionElementReceiver, type2, getter2, setter2, codegen);
    }

    @NotNull
    public static Field field(@NotNull Type type2, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver) {
        return StackValue.field(type2, owner, name, isStatic, receiver, null);
    }

    @NotNull
    public static Field field(@NotNull Type type2, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
        return new Field(type2, owner, name, isStatic, receiver, descriptor2);
    }

    @NotNull
    public static Field field(@NotNull Field field, @NotNull StackValue newReceiver) {
        return StackValue.field(field.type, field.owner, field.name, field.isStaticPut, newReceiver, field.descriptor);
    }

    @NotNull
    public static Field field(@NotNull FieldInfo info, @NotNull StackValue receiver) {
        return StackValue.field(info.getFieldType(), Type.getObjectType(info.getOwnerInternalName()), info.getFieldName(), info.isStatic(), receiver);
    }

    @NotNull
    public static StackValue changeReceiverForFieldAndSharedVar(@NotNull StackValueWithSimpleReceiver stackValue, @Nullable StackValue newReceiver) {
        if (newReceiver == null || stackValue.isStaticPut) {
            return stackValue;
        }
        return stackValue.changeReceiver(newReceiver);
    }

    @NotNull
    public static Property property(@NotNull PropertyDescriptor descriptor2, @Nullable Type backingFieldOwner, @NotNull Type type2, boolean isStaticBackingField, @Nullable String fieldName, @Nullable CallableMethod getter2, @Nullable CallableMethod setter2, @NotNull StackValue receiver, @NotNull ExpressionCodegen codegen, @Nullable ResolvedCall resolvedCall2, boolean skipLateinitAssertion) {
        return new Property(descriptor2, backingFieldOwner, getter2, setter2, isStaticBackingField, fieldName, type2, receiver, codegen, resolvedCall2, skipLateinitAssertion);
    }

    @NotNull
    public static StackValue expression(Type type2, KtExpression expression2, ExpressionCodegen generator) {
        return new Expression(type2, expression2, generator);
    }

    private static void box(Type type2, Type toType, InstructionAdapter v) {
        Type boxedType;
        if (type2 == Type.INT_TYPE) {
            if (toType.getInternalName().equals("java/lang/Byte")) {
                type2 = Type.BYTE_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Short")) {
                type2 = Type.SHORT_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Long")) {
                type2 = Type.LONG_TYPE;
            }
            v.cast(Type.INT_TYPE, type2);
        }
        if ((boxedType = AsmUtil.boxType(type2)) == type2) {
            return;
        }
        v.invokestatic(boxedType.getInternalName(), "valueOf", Type.getMethodDescriptor(boxedType, type2), false);
        StackValue.coerce(boxedType, toType, v);
    }

    private static void unbox(Type methodOwner, Type type2, InstructionAdapter v) {
        assert (AsmUtil.isPrimitive(type2)) : "Unboxing should be performed to primitive type, but " + type2.getClassName();
        v.invokevirtual(methodOwner.getInternalName(), type2.getClassName() + "Value", "()" + type2.getDescriptor(), false);
    }

    protected void coerceTo(@NotNull Type toType, @NotNull InstructionAdapter v) {
        StackValue.coerce(this.type, toType, v);
    }

    protected void coerceFrom(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
        StackValue.coerce(topOfStackType, this.type, v);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v) {
        if (toType.equals(fromType)) {
            return;
        }
        if (toType.getSort() == 0) {
            AsmUtil.pop(v, fromType);
        } else if (fromType.getSort() == 0) {
            if (toType.equals(AsmTypes.UNIT_TYPE) || toType.equals(AsmTypes.OBJECT_TYPE)) {
                StackValue.putUnitInstance(v);
            } else if (toType.getSort() == 10 || toType.getSort() == 9) {
                v.aconst(null);
            } else {
                AsmUtil.pushDefaultPrimitiveValueOnStack(toType, v);
            }
        } else if (toType.equals(AsmTypes.UNIT_TYPE)) {
            if (fromType.equals(AsmTypes.getType(Object.class))) {
                v.checkcast(AsmTypes.UNIT_TYPE);
            } else if (!fromType.equals(AsmTypes.getType(Void.class))) {
                AsmUtil.pop(v, fromType);
                StackValue.putUnitInstance(v);
            }
        } else if (toType.getSort() == 9) {
            v.checkcast(toType);
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 || fromType.getSort() == 9) {
                if (!toType.equals(AsmTypes.OBJECT_TYPE)) {
                    v.checkcast(toType);
                }
            } else {
                StackValue.box(fromType, toType, v);
            }
        } else if (fromType.getSort() == 10) {
            Type unboxedType = AsmUtil.unboxPrimitiveTypeOrNull(fromType);
            if (unboxedType != null) {
                StackValue.unbox(fromType, unboxedType, v);
                StackValue.coerce(unboxedType, toType, v);
            } else if (toType.getSort() == 1) {
                StackValue.coerce(fromType, AsmTypes.BOOLEAN_WRAPPER_TYPE, v);
                StackValue.unbox(AsmTypes.BOOLEAN_WRAPPER_TYPE, Type.BOOLEAN_TYPE, v);
            } else if (toType.getSort() == 2) {
                if (fromType.equals(AsmTypes.NUMBER_TYPE)) {
                    StackValue.unbox(AsmTypes.NUMBER_TYPE, Type.INT_TYPE, v);
                    v.visitInsn(146);
                } else {
                    StackValue.coerce(fromType, AsmTypes.CHARACTER_WRAPPER_TYPE, v);
                    StackValue.unbox(AsmTypes.CHARACTER_WRAPPER_TYPE, Type.CHAR_TYPE, v);
                }
            } else {
                StackValue.coerce(fromType, AsmTypes.NUMBER_TYPE, v);
                StackValue.unbox(AsmTypes.NUMBER_TYPE, toType, v);
            }
        } else {
            v.cast(fromType, toType);
        }
    }

    public static void putUnitInstance(@NotNull InstructionAdapter v) {
        StackValue.unit().put(AsmTypes.UNIT_TYPE, v);
    }

    public static StackValue unit() {
        return UNIT;
    }

    public static StackValue none() {
        return None.INSTANCE;
    }

    public static Field receiverWithRefWrapper(@NotNull Type localType, @NotNull Type classType, @NotNull String fieldName, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
        return StackValue.field(StackValue.sharedTypeForType(localType), classType, fieldName, false, receiver, descriptor2);
    }

    public static FieldForSharedVar fieldForSharedVar(@NotNull Type localType, @NotNull Type classType, @NotNull String fieldName, @NotNull Field refWrapper, @NotNull VariableDescriptor variableDescriptor) {
        return new FieldForSharedVar(localType, classType, fieldName, refWrapper, variableDescriptor.isLateInit(), variableDescriptor.getName());
    }

    @NotNull
    public static FieldForSharedVar fieldForSharedVar(@NotNull FieldForSharedVar field, @NotNull StackValue newReceiver) {
        Field oldReceiver = (Field)field.receiver;
        Field newSharedVarReceiver = StackValue.field(oldReceiver, newReceiver);
        return new FieldForSharedVar(field.type, field.owner, field.name, newSharedVarReceiver, field.isLateinit, field.variableName);
    }

    public static StackValue coercion(@NotNull StackValue value, @NotNull Type castType) {
        if (value.type.equals(castType)) {
            return value;
        }
        return new CoercionValue(value, castType);
    }

    @NotNull
    public static StackValue thisOrOuter(@NotNull ExpressionCodegen codegen, @NotNull ClassDescriptor descriptor2, boolean isSuper, boolean castReceiver) {
        boolean coerceType = descriptor2.getKind() == ClassKind.INTERFACE || castReceiver && !isSuper;
        return new ThisOuter(codegen, descriptor2, isSuper, coerceType);
    }

    public static StackValue postIncrement(int index2, int increment) {
        return new PostIncrement(index2, increment);
    }

    public static StackValue preIncrementForLocalVar(int index2, int increment) {
        return new PreIncrementForLocalVar(index2, increment);
    }

    public static StackValue preIncrement(@NotNull Type type2, @NotNull StackValue stackValue, int delta, ResolvedCall resolvedCall2, @NotNull ExpressionCodegen codegen) {
        if (stackValue instanceof Local && Type.INT_TYPE == stackValue.type) {
            return StackValue.preIncrementForLocalVar(((Local)stackValue).index, delta);
        }
        return new PrefixIncrement(type2, stackValue, resolvedCall2, codegen);
    }

    public static StackValue receiver(ResolvedCall<?> resolvedCall2, StackValue receiver, ExpressionCodegen codegen, @Nullable Callable callableMethod) {
        ReceiverValue callDispatchReceiver = resolvedCall2.getDispatchReceiver();
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof SyntheticFieldDescriptor) {
            callDispatchReceiver = ((SyntheticFieldDescriptor)descriptor2).getDispatchReceiverForBackend();
        }
        ReceiverValue callExtensionReceiver = resolvedCall2.getExtensionReceiver();
        if (callDispatchReceiver != null || callExtensionReceiver != null || StackValue.isLocalFunCall(callableMethod) || StackValue.isCallToMemberObjectImportedByName(resolvedCall2)) {
            ReceiverParameterDescriptor dispatchReceiverParameter = descriptor2.getDispatchReceiverParameter();
            ReceiverParameterDescriptor extensionReceiverParameter = descriptor2.getExtensionReceiverParameter();
            if (descriptor2 instanceof SyntheticFieldDescriptor) {
                dispatchReceiverParameter = ((SyntheticFieldDescriptor)descriptor2).getDispatchReceiverParameterForBackend();
            }
            boolean hasExtensionReceiver = callExtensionReceiver != null;
            StackValue dispatchReceiver = StackValue.platformStaticCallIfPresent(StackValue.genReceiver(hasExtensionReceiver ? StackValue.none() : receiver, codegen, resolvedCall2, callableMethod, callDispatchReceiver, false), descriptor2);
            StackValue extensionReceiver = StackValue.genReceiver(receiver, codegen, resolvedCall2, callableMethod, callExtensionReceiver, true);
            return CallReceiver.generateCallReceiver(resolvedCall2, codegen, callableMethod, dispatchReceiverParameter, dispatchReceiver, extensionReceiverParameter, extensionReceiver);
        }
        return receiver;
    }

    private static StackValue genReceiver(@NotNull StackValue receiver, @NotNull ExpressionCodegen codegen, @NotNull ResolvedCall resolvedCall2, @Nullable Callable callableMethod, @Nullable ReceiverValue receiverValue, boolean isExtension) {
        if (receiver == StackValue.none()) {
            if (receiverValue != null) {
                return codegen.generateReceiverValue(receiverValue, false);
            }
            if (StackValue.isLocalFunCall(callableMethod) && !isExtension) {
                StackValue value = codegen.findLocalOrCapturedValue(resolvedCall2.getResultingDescriptor().getOriginal());
                assert (value != null) : "Local fun should be found in locals or in captured params: " + resolvedCall2;
                return value;
            }
            if (StackValue.isCallToMemberObjectImportedByName(resolvedCall2)) {
                return StackValue.singleton(((ImportedFromObjectCallableDescriptor)resolvedCall2.getResultingDescriptor()).getContainingObject(), codegen.typeMapper);
            }
        } else if (receiverValue != null) {
            return receiver;
        }
        return StackValue.none();
    }

    private static boolean isCallToMemberObjectImportedByName(@NotNull ResolvedCall resolvedCall2) {
        return resolvedCall2.getResultingDescriptor() instanceof ImportedFromObjectCallableDescriptor;
    }

    private static StackValue platformStaticCallIfPresent(@NotNull StackValue resultReceiver, @NotNull CallableDescriptor descriptor2) {
        if (CodegenUtilKt.isJvmStaticInObjectOrClass(descriptor2)) {
            if (resultReceiver.canHaveSideEffects()) {
                return StackValue.coercion(resultReceiver, Type.VOID_TYPE);
            }
            return StackValue.none();
        }
        return resultReceiver;
    }

    @Contract(value="null -> false")
    static boolean isLocalFunCall(@Nullable Callable callableMethod) {
        return callableMethod != null && callableMethod.getGenerateCalleeType() != null;
    }

    public static StackValue receiverWithoutReceiverArgument(StackValue receiverWithParameter) {
        if (receiverWithParameter instanceof CallReceiver) {
            return ((CallReceiver)receiverWithParameter).withoutReceiverArgument();
        }
        return receiverWithParameter;
    }

    @NotNull
    public static Field enumEntry(@NotNull ClassDescriptor descriptor2, @NotNull KotlinTypeMapper typeMapper) {
        DeclarationDescriptor enumClass = descriptor2.getContainingDeclaration();
        assert (DescriptorUtils.isEnumClass(enumClass)) : "Enum entry should be declared in enum class: " + descriptor2;
        Type type2 = typeMapper.mapType((ClassDescriptor)enumClass);
        return StackValue.field(type2, type2, descriptor2.getName().asString(), true, StackValue.none(), descriptor2);
    }

    @NotNull
    public static Field singleton(@NotNull ClassDescriptor classDescriptor, @NotNull KotlinTypeMapper typeMapper) {
        return StackValue.field(FieldInfo.createForSingleton(classDescriptor, typeMapper), StackValue.none());
    }

    public static Field createSingletonViaInstance(@NotNull ClassDescriptor classDescriptor, @NotNull KotlinTypeMapper typeMapper, @NotNull String name) {
        return StackValue.field(FieldInfo.createSingletonViaInstance(classDescriptor, typeMapper, name), StackValue.none());
    }

    public static StackValue operation(Type type2, Function1<InstructionAdapter, Unit> lambda2) {
        return new OperationStackValue(type2, lambda2);
    }

    public static StackValue functionCall(Type type2, Function1<InstructionAdapter, Unit> lambda2) {
        return new FunctionCallStackValue(type2, lambda2);
    }

    public static boolean couldSkipReceiverOnStaticCall(StackValue value) {
        return value instanceof Local || value instanceof Constant;
    }

    private static void genNonNullAssertForLateinit(@NotNull InstructionAdapter v, @NotNull String name) {
        v.dup();
        Label ok = new Label();
        v.ifnonnull(ok);
        v.visitLdcInsn(name);
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwUninitializedPropertyAccessException", "(Ljava/lang/String;)V", false);
        v.mark(ok);
    }

    @NotNull
    public static Type sharedTypeForType(@NotNull Type type2) {
        switch (type2.getSort()) {
            case 9: 
            case 10: {
                return AsmTypes.OBJECT_REF_TYPE;
            }
        }
        PrimitiveType primitiveType = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(type2);
        if (primitiveType == null) {
            throw new UnsupportedOperationException();
        }
        return AsmTypes.sharedTypeForPrimitive(primitiveType);
    }

    public static Type refType(Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return AsmTypes.OBJECT_TYPE;
        }
        return type2;
    }

    public static StackValue complexWriteReadReceiver(StackValue stackValue) {
        return StackValue.complexReceiver(stackValue, false, true);
    }

    private static StackValue complexReceiver(StackValue stackValue, boolean ... isReadOperations) {
        if (stackValue instanceof Delegate) {
            StackValue.throwUnsupportedComplexOperation(((Delegate)stackValue).variableDescriptor);
        }
        if (stackValue instanceof StackValueWithSimpleReceiver) {
            return new DelegatedForComplexReceiver(stackValue.type, (StackValueWithSimpleReceiver)stackValue, new ComplexReceiver((StackValueWithSimpleReceiver)stackValue, isReadOperations));
        }
        return stackValue;
    }

    private static void throwUnsupportedComplexOperation(@NotNull CallableDescriptor descriptor2) {
        throw new RuntimeException("Augment assignment and increment are not supported for local delegated properties ans inline properties: " + descriptor2);
    }

    static class SafeFallback
    extends StackValueWithSimpleReceiver {
        @Nullable
        private final Label ifNull;

        public SafeFallback(@NotNull Type type2, @Nullable Label ifNull, StackValue receiver) {
            super(type2, false, false, receiver, true);
            this.ifNull = ifNull;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            Label end = new Label();
            v.goTo(end);
            v.mark(this.ifNull);
            v.pop();
            if (!this.type.equals(Type.VOID_TYPE)) {
                v.aconst(null);
            }
            v.mark(end);
            this.coerceTo(type2, v);
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            this.receiver.store(rightSide, v, skipReceiver);
            Label end = new Label();
            v.goTo(end);
            v.mark(this.ifNull);
            v.pop();
            v.mark(end);
        }
    }

    static class SafeCall
    extends StackValue {
        @NotNull
        private final Type type;
        private final StackValue receiver;
        @Nullable
        private final Label ifNull;

        public SafeCall(@NotNull Type type2, @NotNull StackValue value, @Nullable Label ifNull) {
            super(type2);
            this.type = type2;
            this.receiver = value;
            this.ifNull = ifNull;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            this.receiver.put(this.type, v);
            if (this.ifNull != null) {
                v.dup();
                v.ifnull(this.ifNull);
            }
            this.coerceTo(type2, v);
        }
    }

    public static class DelegatedForComplexReceiver
    extends StackValueWithSimpleReceiver {
        public final StackValueWithSimpleReceiver originalValue;

        public DelegatedForComplexReceiver(@NotNull Type type2, @NotNull StackValueWithSimpleReceiver originalValue, @NotNull ComplexReceiver receiver) {
            super(type2, DelegatedForComplexReceiver.bothReceiverStatic(originalValue), DelegatedForComplexReceiver.bothReceiverStatic(originalValue), receiver, originalValue.canHaveSideEffects());
            this.originalValue = originalValue;
        }

        private static boolean bothReceiverStatic(StackValueWithSimpleReceiver originalValue) {
            return !originalValue.isNonStaticAccess(true) && !originalValue.isNonStaticAccess(false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            this.originalValue.putSelector(type2, v);
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (!skipReceiver) {
                this.putReceiver(v, false);
            }
            this.originalValue.store(rightSide, v, true);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            this.originalValue.storeSelector(topOfStackType, v);
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withWriteReceiver) {
            this.originalValue.dup(v, withWriteReceiver);
        }
    }

    public static class Receiver
    extends StackValue {
        private final StackValue[] instructions;

        protected Receiver(@NotNull Type type2, StackValue ... receiverInstructions) {
            super(type2);
            this.instructions = receiverInstructions;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            for (StackValue instruction : this.instructions) {
                instruction.put(instruction.type, v);
            }
        }
    }

    private static class ComplexReceiver
    extends StackValue {
        private final StackValueWithSimpleReceiver originalValueWithReceiver;
        private final boolean[] isReadOperations;

        public ComplexReceiver(StackValueWithSimpleReceiver value, boolean[] isReadOperations) {
            super(value.type, value.receiver.canHaveSideEffects());
            this.originalValueWithReceiver = value;
            this.isReadOperations = isReadOperations;
            if (value instanceof CollectionElement && value.receiver instanceof CollectionElementReceiver) {
                ((CollectionElementReceiver)value.receiver).isComplexOperationWithDup = true;
            }
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            boolean wasPut = false;
            StackValue receiver = this.originalValueWithReceiver.receiver;
            for (boolean operation : this.isReadOperations) {
                if (!this.originalValueWithReceiver.isNonStaticAccess(operation)) continue;
                if (!wasPut) {
                    receiver.put(receiver.type, v);
                    wasPut = true;
                    continue;
                }
                receiver.dup(v, false);
            }
            if (!wasPut && receiver.canHaveSideEffects()) {
                receiver.put(Type.VOID_TYPE, v);
            }
        }
    }

    public static abstract class StackValueWithSimpleReceiver
    extends StackValue {
        public final boolean isStaticPut;
        public final boolean isStaticStore;
        @NotNull
        public final StackValue receiver;

        public StackValueWithSimpleReceiver(@NotNull Type type2, boolean isStaticPut, boolean isStaticStore, @NotNull StackValue receiver, boolean canHaveSideEffects) {
            super(type2, canHaveSideEffects);
            this.receiver = receiver;
            this.isStaticPut = isStaticPut;
            this.isStaticStore = isStaticStore;
        }

        @Override
        public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
            boolean hasReceiver = this.isNonStaticAccess(isRead);
            if (hasReceiver || this.receiver.canHaveSideEffects()) {
                this.receiver.put(hasReceiver ? this.receiver.type : Type.VOID_TYPE, v);
            }
        }

        @Override
        public boolean isNonStaticAccess(boolean isRead) {
            return isRead ? !this.isStaticPut : !this.isStaticStore;
        }

        public int receiverSize() {
            return this.receiver.type.getSize();
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withWriteReceiver) {
            if (!withWriteReceiver) {
                super.dup(v, false);
            } else {
                int receiverSize = this.isNonStaticAccess(false) ? this.receiverSize() : 0;
                switch (receiverSize) {
                    case 0: {
                        AsmUtil.dup(v, this.type);
                        break;
                    }
                    case 1: {
                        if (this.type.getSize() == 2) {
                            v.dup2X1();
                            break;
                        }
                        v.dupX1();
                        break;
                    }
                    case 2: {
                        if (this.type.getSize() == 2) {
                            v.dup2X2();
                            break;
                        }
                        v.dupX2();
                        break;
                    }
                    case -1: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (!skipReceiver) {
                this.putReceiver(v, false);
            }
            rightSide.put(rightSide.type, v);
            this.storeSelector(rightSide.type, v);
        }

        protected StackValueWithSimpleReceiver changeReceiver(@NotNull StackValue newReceiver) {
            return this;
        }
    }

    private static class PrefixIncrement
    extends StackValue {
        private final ResolvedCall resolvedCall;
        private final ExpressionCodegen codegen;
        private StackValue value;

        public PrefixIncrement(@NotNull Type type2, @NotNull StackValue value, ResolvedCall resolvedCall2, @NotNull ExpressionCodegen codegen) {
            super(type2);
            this.value = value;
            this.resolvedCall = resolvedCall2;
            this.codegen = codegen;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            this.value = StackValue.complexReceiver(this.value, new boolean[]{true, false, true});
            this.value.put(this.type, v);
            this.value.store(this.codegen.invokeFunction(this.resolvedCall, StackValue.onStack(this.type)), v, true);
            this.value.put(this.type, v, true);
            this.coerceTo(type2, v);
        }
    }

    private static class PreIncrementForLocalVar
    extends StackValue {
        private final int index;
        private final int increment;

        public PreIncrementForLocalVar(int index2, int increment) {
            super(Type.INT_TYPE);
            this.index = index2;
            this.increment = increment;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            v.iinc(this.index, this.increment);
            if (!type2.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type2, v);
            }
        }
    }

    private static class PostIncrement
    extends StackValue {
        private final int index;
        private final int increment;

        public PostIncrement(int index2, int increment) {
            super(Type.INT_TYPE);
            this.index = index2;
            this.increment = increment;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (!type2.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type2, v);
            }
            v.iinc(this.index, this.increment);
        }
    }

    private static class ThisOuter
    extends StackValue {
        private final ExpressionCodegen codegen;
        private final ClassDescriptor descriptor;
        private final boolean isSuper;
        private final boolean coerceType;

        public ThisOuter(ExpressionCodegen codegen, ClassDescriptor descriptor2, boolean isSuper, boolean coerceType) {
            super(AsmTypes.OBJECT_TYPE, false);
            this.codegen = codegen;
            this.descriptor = descriptor2;
            this.isSuper = isSuper;
            this.coerceType = coerceType;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            StackValue stackValue = this.codegen.generateThisOrOuter(this.descriptor, this.isSuper);
            stackValue.put(this.coerceType ? type2 : stackValue.type, v);
        }
    }

    public static class FieldForSharedVar
    extends StackValueWithSimpleReceiver {
        final Type owner;
        final String name;
        final boolean isLateinit;
        final Name variableName;

        public FieldForSharedVar(Type type2, Type owner, String name, Field receiver, boolean isLateinit, Name variableName) {
            super(type2, false, false, receiver, receiver.canHaveSideEffects());
            if (isLateinit && variableName == null) {
                throw new IllegalArgumentException("variableName should be non-null for captured lateinit variable " + name);
            }
            this.owner = owner;
            this.name = name;
            this.isLateinit = isLateinit;
            this.variableName = variableName;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            Type sharedType = FieldForSharedVar.sharedTypeForType(this.type);
            Type refType = FieldForSharedVar.refType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            if (this.isLateinit) {
                StackValue.genNonNullAssertForLateinit(v, this.variableName.asString());
            }
            this.coerceFrom(refType, v);
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.visitFieldInsn(181, FieldForSharedVar.sharedTypeForType(this.type).getInternalName(), "element", FieldForSharedVar.refType(this.type).getDescriptor());
        }

        @Override
        protected StackValueWithSimpleReceiver changeReceiver(@NotNull StackValue newReceiver) {
            return FieldForSharedVar.fieldForSharedVar(this, newReceiver);
        }
    }

    public static class Shared
    extends StackValueWithSimpleReceiver {
        private final int index;
        private final boolean isLateinit;
        private final Name name;

        public Shared(int index2, Type type2, boolean isLateinit, Name name) {
            super(type2, false, false, Shared.local(index2, AsmTypes.OBJECT_TYPE), false);
            this.index = index2;
            if (isLateinit && name == null) {
                throw new IllegalArgumentException("Lateinit shared local variable should have name: #" + index2 + " " + type2.getDescriptor());
            }
            this.isLateinit = isLateinit;
            this.name = name;
        }

        public Shared(int index2, Type type2) {
            this(index2, type2, false, null);
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            if (this.isLateinit) {
                StackValue.genNonNullAssertForLateinit(v, this.name.asString());
            }
            this.coerceFrom(refType, v);
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(181, sharedType.getInternalName(), "element", refType.getDescriptor());
        }
    }

    private static class Expression
    extends StackValue {
        private final KtExpression expression;
        private final ExpressionCodegen generator;

        public Expression(Type type2, KtExpression expression2, ExpressionCodegen generator) {
            super(type2);
            this.expression = expression2;
            this.generator = generator;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            this.generator.gen(this.expression, type2);
        }
    }

    public static class Property
    extends StackValueWithSimpleReceiver {
        private final CallableMethod getter;
        private final CallableMethod setter;
        private final Type backingFieldOwner;
        private final PropertyDescriptor descriptor;
        private final String fieldName;
        private final ExpressionCodegen codegen;
        private final ResolvedCall resolvedCall;
        private final boolean skipLateinitAssertion;

        public Property(@NotNull PropertyDescriptor descriptor2, @Nullable Type backingFieldOwner, @Nullable CallableMethod getter2, @Nullable CallableMethod setter2, boolean isStaticBackingField, @Nullable String fieldName, @NotNull Type type2, @NotNull StackValue receiver, @NotNull ExpressionCodegen codegen, @Nullable ResolvedCall resolvedCall2, boolean skipLateinitAssertion) {
            super(type2, Property.isStatic(isStaticBackingField, getter2), Property.isStatic(isStaticBackingField, setter2), receiver, true);
            this.backingFieldOwner = backingFieldOwner;
            this.getter = getter2;
            this.setter = setter2;
            this.descriptor = descriptor2;
            this.fieldName = fieldName;
            this.codegen = codegen;
            this.resolvedCall = resolvedCall2;
            this.skipLateinitAssertion = skipLateinitAssertion;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (this.getter == null) {
                assert (this.fieldName != null) : "Property should have either a getter or a field name: " + this.descriptor;
                assert (this.backingFieldOwner != null) : "Property should have either a getter or a backingFieldOwner: " + this.descriptor;
                if (this.inlineConstantIfNeeded(type2, v)) {
                    return;
                }
                v.visitFieldInsn(this.isStaticPut ? 178 : 180, this.backingFieldOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
                if (!this.skipLateinitAssertion) {
                    this.genNotNullAssertionForLateInitIfNeeded(v);
                }
                this.coerceTo(type2, v);
            } else {
                PropertyGetterDescriptor getterDescriptor = this.descriptor.getGetter();
                assert (getterDescriptor != null) : "Getter descriptor should be not null for " + this.descriptor;
                if (this.resolvedCall != null && getterDescriptor.isInline()) {
                    CallGenerator callGenerator = this.codegen.getOrCreateCallGenerator(this.resolvedCall, getterDescriptor);
                    callGenerator.processAndPutHiddenParameters(false);
                    callGenerator.genCall(this.getter, this.resolvedCall, false, this.codegen);
                } else {
                    this.getter.genInvokeInstruction(v);
                }
                Type typeOfValueOnStack = this.getter.getReturnType();
                if (DescriptorUtils.isAnnotationClass(this.descriptor.getContainingDeclaration())) {
                    if (this.type.equals(AsmTypes.K_CLASS_TYPE)) {
                        AsmUtil.wrapJavaClassIntoKClass(v);
                        typeOfValueOnStack = AsmTypes.K_CLASS_TYPE;
                    } else if (this.type.equals(AsmTypes.K_CLASS_ARRAY_TYPE)) {
                        AsmUtil.wrapJavaClassesIntoKClasses(v);
                        typeOfValueOnStack = AsmTypes.K_CLASS_ARRAY_TYPE;
                    }
                }
                Property.coerce(typeOfValueOnStack, type2, v);
                KotlinType returnType = this.descriptor.getReturnType();
                if (returnType != null && KotlinBuiltIns.isNothing(returnType)) {
                    v.aconst(null);
                    v.athrow();
                }
            }
        }

        private boolean inlineConstantIfNeeded(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (JvmCodegenUtil.isInlinedJavaConstProperty(this.descriptor)) {
                return this.inlineConstant(type2, v);
            }
            if (this.descriptor.isConst() && this.codegen.getState().getShouldInlineConstVals()) {
                return this.inlineConstant(type2, v);
            }
            return false;
        }

        private boolean inlineConstant(@NotNull Type type2, @NotNull InstructionAdapter v) {
            assert (AsmUtil.isPrimitive(this.type) || AsmTypes.JAVA_STRING_TYPE.equals(this.type)) : "Const property should have primitive or string type: " + this.descriptor;
            assert (this.isStaticPut) : "Const property should be static" + this.descriptor;
            ConstantValue<?> constantValue = this.descriptor.getCompileTimeInitializer();
            if (constantValue == null) {
                return false;
            }
            Object value = constantValue.getValue();
            if (this.type == Type.FLOAT_TYPE && value instanceof Double) {
                value = Float.valueOf(((Double)value).floatValue());
            }
            StackValue.constant(value, this.type).putSelector(type2, v);
            return true;
        }

        private void genNotNullAssertionForLateInitIfNeeded(@NotNull InstructionAdapter v) {
            if (!this.descriptor.isLateInit()) {
                return;
            }
            StackValue.genNonNullAssertForLateinit(v, this.descriptor.getName().asString());
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            PropertySetterDescriptor setterDescriptor = this.descriptor.getSetter();
            if (this.resolvedCall != null && setterDescriptor != null && setterDescriptor.isInline()) {
                assert (this.setter != null) : "Setter should be not null for " + this.descriptor;
                CallGenerator callGenerator = this.codegen.getOrCreateCallGenerator(this.resolvedCall, setterDescriptor);
                if (!skipReceiver) {
                    this.putReceiver(v, false);
                }
                callGenerator.processAndPutHiddenParameters(true);
                callGenerator.putValueIfNeeded(rightSide.type, rightSide);
                callGenerator.putHiddenParamsIntoLocals();
                callGenerator.genCall(this.setter, this.resolvedCall, false, this.codegen);
            } else {
                super.store(rightSide, v, skipReceiver);
            }
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (this.setter == null) {
                this.coerceFrom(topOfStackType, v);
                assert (this.fieldName != null) : "Property should have either a setter or a field name: " + this.descriptor;
                assert (this.backingFieldOwner != null) : "Property should have either a setter or a backingFieldOwner: " + this.descriptor;
                v.visitFieldInsn(this.isStaticStore ? 179 : 181, this.backingFieldOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
            } else {
                Property.coerce(topOfStackType, ArraysKt.last(this.setter.getParameterTypes()), v);
                this.setter.genInvokeInstruction(v);
                Type returnType = this.setter.getReturnType();
                if (returnType != Type.VOID_TYPE) {
                    AsmUtil.pop(v, returnType);
                }
            }
        }

        private static boolean isStatic(boolean isStaticBackingField, @Nullable CallableMethod callable) {
            if (isStaticBackingField && callable == null) {
                return true;
            }
            if (callable != null && callable.isStaticCall()) {
                JvmMethodParameterSignature parameter;
                JvmMethodParameterKind kind;
                List<JvmMethodParameterSignature> parameters2 = callable.getValueParameters();
                Iterator<JvmMethodParameterSignature> iterator2 = parameters2.iterator();
                while (iterator2.hasNext() && (kind = (parameter = iterator2.next()).getKind()) != JvmMethodParameterKind.VALUE) {
                    if (kind != JvmMethodParameterKind.RECEIVER && kind != JvmMethodParameterKind.THIS) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class Field
    extends StackValueWithSimpleReceiver {
        public final Type owner;
        public final String name;
        public final DeclarationDescriptor descriptor;

        public Field(@NotNull Type type2, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
            super(type2, isStatic, isStatic, receiver, receiver.canHaveSideEffects());
            this.owner = owner;
            this.name = name;
            this.descriptor = descriptor2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            v.visitFieldInsn(this.isStaticPut ? 178 : 180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.visitFieldInsn(this.isStaticStore ? 179 : 181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }

        @Override
        protected StackValueWithSimpleReceiver changeReceiver(@NotNull StackValue newReceiver) {
            return Field.field(this, newReceiver);
        }
    }

    public static class CollectionElement
    extends StackValueWithSimpleReceiver {
        private final Callable getter;
        private final Callable setter;
        private final ExpressionCodegen codegen;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;

        public CollectionElement(@NotNull CollectionElementReceiver collectionElementReceiver, @NotNull Type type2, @Nullable ResolvedCall<FunctionDescriptor> resolvedGetCall, @Nullable ResolvedCall<FunctionDescriptor> resolvedSetCall, @NotNull ExpressionCodegen codegen) {
            super(type2, false, false, collectionElementReceiver, true);
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.setter = resolvedSetCall == null ? null : codegen.resolveToCallable(codegen.accessibleFunctionDescriptor(resolvedSetCall), false, resolvedSetCall);
            this.getter = resolvedGetCall == null ? null : codegen.resolveToCallable(codegen.accessibleFunctionDescriptor(resolvedGetCall), false, resolvedGetCall);
            this.codegen = codegen;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (this.getter == null) {
                throw new UnsupportedOperationException("no getter specified");
            }
            CallGenerator callGenerator = this.getCallGenerator();
            callGenerator.genCall(this.getter, this.resolvedGetCall, this.genDefaultMaskIfPresent(callGenerator), this.codegen);
            this.coerceTo(type2, v);
        }

        private boolean genDefaultMaskIfPresent(CallGenerator callGenerator) {
            DefaultCallArgs defaultArgs = ((CollectionElementReceiver)this.receiver).defaultArgs;
            return defaultArgs.generateOnStackIfNeeded(callGenerator, true);
        }

        private CallGenerator getCallGenerator() {
            CallGenerator generator = ((CollectionElementReceiver)this.receiver).callGenerator;
            assert (generator != null) : "CollectionElementReceiver should be putted on stack before CollectionElement: getCall = " + this.resolvedGetCall + ",  setCall = " + this.resolvedSetCall;
            return generator;
        }

        @Override
        public int receiverSize() {
            if (CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedGetCall, 1) && CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedSetCall, 2)) {
                return 2;
            }
            return -1;
        }

        public static boolean isStandardStack(@NotNull KotlinTypeMapper typeMapper, @Nullable ResolvedCall<?> call2, int valueParamsSize) {
            if (call2 == null) {
                return true;
            }
            List<ValueParameterDescriptor> valueParameters = call2.getResultingDescriptor().getValueParameters();
            if (valueParameters.size() != valueParamsSize) {
                return false;
            }
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                if (typeMapper.mapType(valueParameter.getType()).getSize() == 1) continue;
                return false;
            }
            return !(call2.getDispatchReceiver() != null ? call2.getExtensionReceiver() != null : typeMapper.mapType(call2.getResultingDescriptor().getExtensionReceiverParameter().getType()).getSize() != 1);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (this.setter == null) {
                throw new UnsupportedOperationException("no setter specified");
            }
            Type lastParameterType = ArraysKt.last(this.setter.getParameterTypes());
            CollectionElement.coerce(topOfStackType, lastParameterType, v);
            this.getCallGenerator().putValueIfNeeded(lastParameterType, StackValue.onStack(lastParameterType));
            CollectionElementReceiver collectionElementReceiver = (CollectionElementReceiver)this.receiver;
            if (collectionElementReceiver.isGetter) {
                List arguments2 = collectionElementReceiver.valueArguments;
                List<Type> types = this.getter.getValueParameterTypes();
                for (int i = arguments2.size() - 1; i >= 0; --i) {
                    ResolvedValueArgument argument = (ResolvedValueArgument)arguments2.get(i);
                    if (!(argument instanceof DefaultValueArgument)) continue;
                    Type defaultType2 = types.get(i);
                    AsmUtil.swap(v, lastParameterType, defaultType2);
                    AsmUtil.pop(v, defaultType2);
                }
            }
            this.getCallGenerator().genCall(this.setter, this.resolvedSetCall, false, this.codegen);
            Type returnType = this.setter.getReturnType();
            if (returnType != Type.VOID_TYPE) {
                AsmUtil.pop(v, returnType);
            }
        }
    }

    public static class CollectionElementReceiver
    extends StackValue {
        private final Callable callable;
        private final boolean isGetter;
        private final ExpressionCodegen codegen;
        private final List<ResolvedValueArgument> valueArguments;
        private final FrameMap frame;
        private final StackValue receiver;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;
        private DefaultCallArgs defaultArgs;
        private CallGenerator callGenerator;
        boolean isComplexOperationWithDup;

        public CollectionElementReceiver(@NotNull Callable callable, @NotNull StackValue receiver, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, boolean isGetter, @NotNull ExpressionCodegen codegen, List<ResolvedValueArgument> valueArguments) {
            super(AsmTypes.OBJECT_TYPE);
            this.callable = callable;
            this.isGetter = isGetter;
            this.receiver = receiver;
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.valueArguments = valueArguments;
            this.codegen = codegen;
            this.frame = codegen.myFrameMap;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            ResolvedCall<FunctionDescriptor> call2 = this.isGetter ? this.resolvedGetCall : this.resolvedSetCall;
            StackValue newReceiver = StackValue.receiver(call2, this.receiver, this.codegen, this.callable);
            ArgumentGenerator generator = this.createArgumentGenerator();
            newReceiver.put(newReceiver.type, v);
            this.callGenerator.processAndPutHiddenParameters(false);
            this.defaultArgs = generator.generate(this.valueArguments, this.valueArguments, call2.getResultingDescriptor());
        }

        private ArgumentGenerator createArgumentGenerator() {
            ResolvedCall<FunctionDescriptor> resolvedCall2;
            assert (this.callGenerator == null) : "'putSelector' and 'createArgumentGenerator' methods should be called once for CollectionElementReceiver: " + this.callable;
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = this.isGetter ? this.resolvedGetCall : this.resolvedSetCall;
            assert (resolvedCall2 != null) : "Resolved call should be non-null: " + this.callable;
            this.callGenerator = !this.isComplexOperationWithDup ? this.codegen.getOrCreateCallGenerator(resolvedCall2) : this.codegen.defaultCallGenerator;
            return new CallBasedArgumentGenerator(this.codegen, this.callGenerator, resolvedCall2.getResultingDescriptor().getValueParameters(), this.callable.getValueParameterTypes());
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withReceiver) {
            this.dupReceiver(v);
        }

        public void dupReceiver(@NotNull InstructionAdapter v) {
            Type type2;
            int realReceiverIndex;
            Type realReceiverType;
            if (CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedGetCall, 1) && CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedSetCall, 2)) {
                v.dup2();
                return;
            }
            FrameMap.Mark mark = this.frame.mark();
            List<ValueParameterDescriptor> valueParameters = this.resolvedGetCall.getResultingDescriptor().getValueParameters();
            int firstParamIndex = -1;
            for (int i = valueParameters.size() - 1; i >= 0; --i) {
                Type type3 = this.codegen.typeMapper.mapType(valueParameters.get(i).getType());
                firstParamIndex = this.frame.enterTemp(type3);
                v.store(firstParamIndex, type3);
            }
            ReceiverValue receiverParameter = this.resolvedGetCall.getExtensionReceiver();
            int receiverIndex = -1;
            if (receiverParameter != null) {
                Type type4 = this.codegen.typeMapper.mapType(receiverParameter.getType());
                receiverIndex = this.frame.enterTemp(type4);
                v.store(receiverIndex, type4);
            }
            ReceiverValue dispatchReceiver = this.resolvedGetCall.getDispatchReceiver();
            int thisIndex = -1;
            if (dispatchReceiver != null) {
                thisIndex = this.frame.enterTemp(AsmTypes.OBJECT_TYPE);
                v.store(thisIndex, AsmTypes.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                realReceiverType = this.codegen.typeMapper.mapType(receiverParameter.getType());
                realReceiverIndex = receiverIndex;
            } else if (thisIndex != -1) {
                realReceiverType = AsmTypes.OBJECT_TYPE;
                realReceiverIndex = thisIndex;
            } else {
                throw new UnsupportedOperationException();
            }
            if (this.resolvedSetCall.getDispatchReceiver() != null) {
                if (this.resolvedSetCall.getExtensionReceiver() != null) {
                    this.codegen.generateReceiverValue(this.resolvedSetCall.getDispatchReceiver(), false).put(AsmTypes.OBJECT_TYPE, v);
                }
                v.load(realReceiverIndex, realReceiverType);
            } else if (this.resolvedSetCall.getExtensionReceiver() != null) {
                v.load(realReceiverIndex, realReceiverType);
            } else {
                throw new UnsupportedOperationException();
            }
            int index2 = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                type2 = this.codegen.typeMapper.mapType(valueParameter.getType());
                v.load(index2, type2);
                index2 -= type2.getSize();
            }
            if (thisIndex != -1) {
                v.load(thisIndex, AsmTypes.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                v.load(receiverIndex, realReceiverType);
            }
            index2 = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                type2 = this.codegen.typeMapper.mapType(valueParameter.getType());
                v.load(index2, type2);
                index2 -= type2.getSize();
            }
            mark.dropTo();
        }
    }

    private static class ArrayElement
    extends StackValueWithSimpleReceiver {
        private final Type type;

        public ArrayElement(Type type2, StackValue array, StackValue index2) {
            super(type2, false, false, new Receiver(Type.LONG_TYPE, array, index2), true);
            this.type = type2;
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.astore(this.type);
        }

        @Override
        public int receiverSize() {
            return 2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            v.aload(this.type);
            this.coerceTo(type2, v);
        }
    }

    public static class Constant
    extends StackValue {
        @Nullable
        public final Object value;

        public Constant(@Nullable Object value, Type type2) {
            super(type2, false);
            assert (!Type.BOOLEAN_TYPE.equals(type2)) : "Boolean constants should be created via 'StackValue.constant'";
            this.value = value;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (this.value instanceof Integer || this.value instanceof Byte || this.value instanceof Short) {
                v.iconst(((Number)this.value).intValue());
            } else if (this.value instanceof Character) {
                v.iconst(((Character)this.value).charValue());
            } else if (this.value instanceof Long) {
                v.lconst((Long)this.value);
            } else if (this.value instanceof Float) {
                v.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v.dconst((Double)this.value);
            } else {
                v.aconst(this.value);
            }
            if (this.value != null || AsmUtil.isPrimitive(type2)) {
                this.coerceTo(type2, v);
            }
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type2) {
            super(type2);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            this.coerceTo(type2, v);
        }

        @Override
        public void moveToTopOfStack(@NotNull Type type2, @NotNull InstructionAdapter v, int depth) {
            if (depth == 0) {
                this.put(type2, v);
            } else if (depth == 1) {
                int size = this.type.getSize();
                if (size == 1) {
                    v.swap();
                } else if (size == 2) {
                    v.dupX2();
                    v.pop();
                } else {
                    throw new UnsupportedOperationException("don't know how to move type " + type2 + " to top of stack");
                }
                this.coerceTo(type2, v);
            } else if (depth == 2) {
                int size = this.type.getSize();
                if (size == 1) {
                    v.dup2X1();
                    v.pop2();
                } else if (size == 2) {
                    v.dup2X2();
                    v.pop2();
                } else {
                    throw new UnsupportedOperationException("don't know how to move type " + type2 + " to top of stack");
                }
                this.coerceTo(type2, v);
            } else {
                throw new UnsupportedOperationException("unsupported move-to-top depth " + depth);
            }
        }
    }

    public static class Delegate
    extends StackValue {
        @NotNull
        private final StackValue delegateValue;
        @NotNull
        private final StackValue metadataValue;
        @NotNull
        private final VariableDescriptorWithAccessors variableDescriptor;
        @NotNull
        private final ExpressionCodegen codegen;

        private Delegate(@NotNull Type type2, @NotNull StackValue delegateValue, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull ExpressionCodegen codegen) {
            super(type2);
            this.delegateValue = delegateValue;
            this.metadataValue = metadataValue;
            this.variableDescriptor = variableDescriptor;
            this.codegen = codegen;
        }

        private ResolvedCall<FunctionDescriptor> getResolvedCall(boolean isGetter) {
            VariableAccessorDescriptor accessor;
            BindingContext bindingContext = this.codegen.getState().getBindingContext();
            VariableAccessorDescriptor variableAccessorDescriptor = accessor = isGetter ? this.variableDescriptor.getGetter() : this.variableDescriptor.getSetter();
            assert (accessor != null) : "Accessor descriptor for delegated local property should be present " + this.variableDescriptor;
            ResolvedCall<FunctionDescriptor> resolvedCall2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor);
            assert (resolvedCall2 != null) : "Resolve call should be recorded for delegate call " + this.variableDescriptor;
            return resolvedCall2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.getResolvedCall(true);
            List<? extends ValueArgument> arguments2 = resolvedCall2.getCall().getValueArguments();
            assert (arguments2.size() == 2) : "Resolved call for 'getValue' should have 2 arguments, but was " + arguments2.size() + ": " + resolvedCall2;
            this.codegen.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
            this.codegen.tempVariables.put(arguments2.get(1).asElement(), this.metadataValue);
            StackValue lastValue = this.codegen.invokeFunction(resolvedCall2, this.delegateValue);
            lastValue.put(type2, v);
            this.codegen.tempVariables.remove(arguments2.get(0).asElement());
            this.codegen.tempVariables.remove(arguments2.get(1).asElement());
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.getResolvedCall(false);
            List<? extends ValueArgument> arguments2 = resolvedCall2.getCall().getValueArguments();
            assert (arguments2.size() == 3) : "Resolved call for 'setValue' should have 3 arguments, but was " + arguments2.size() + ": " + resolvedCall2;
            this.codegen.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
            this.codegen.tempVariables.put(arguments2.get(1).asElement(), this.metadataValue);
            this.codegen.tempVariables.put(arguments2.get(2).asElement(), rightSide);
            StackValue lastValue = this.codegen.invokeFunction(resolvedCall2, this.delegateValue);
            lastValue.put(Type.VOID_TYPE, v);
            this.codegen.tempVariables.remove(arguments2.get(0).asElement());
            this.codegen.tempVariables.remove(arguments2.get(1).asElement());
            this.codegen.tempVariables.remove(arguments2.get(2).asElement());
        }
    }

    public static class Local
    extends StackValue {
        public final int index;
        private final boolean isLateinit;
        private final Name name;

        private Local(int index2, Type type2, boolean isLateinit, Name name) {
            super(type2, false);
            if (index2 < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
            if (isLateinit && name == null) {
                throw new IllegalArgumentException("Lateinit local variable should have name: #" + index2 + " " + type2.getDescriptor());
            }
            this.index = index2;
            this.isLateinit = isLateinit;
            this.name = name;
        }

        private Local(int index2, Type type2) {
            this(index2, type2, false, null);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            v.load(this.index, this.type);
            if (this.isLateinit) {
                StackValue.genNonNullAssertForLateinit(v, this.name.asString());
            }
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.store(this.index, this.type);
            if (this.isLateinit) {
                PseudoInsnsKt.storeNotNull(v);
            }
        }
    }

    private static class None
    extends StackValue {
        public static final None INSTANCE = new None();

        private None() {
            super(Type.VOID_TYPE, false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            this.coerceTo(type2, v);
        }
    }
}

