/* gstyle-private.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gstyle", gir_namespace = "Gstyle", gir_version = "1.0", lower_case_cprefix = "gstyle_")]
namespace Gstyle {
	[CCode (cheader_filename = "gstyle-private.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gstyle_cielab_get_type ()")]
	[Compact]
	public class Cielab {
		public Gstyle.Cielab copy ();
		public void free ();
	}
	[CCode (cheader_filename = "gstyle-private.h", type_id = "gstyle_color_get_type ()")]
	public class Color : GLib.Object {
		[CCode (has_construct_function = false)]
		public Color (string? name, Gstyle.ColorKind kind, uint red, uint green, uint blue, uint alpha);
		public static Gdk.RGBA convert_cielab_to_rgb (Gstyle.Cielab lab);
		public static void convert_cielab_to_xyz (Gstyle.Cielab lab, Gstyle.XYZ xyz);
		public static void convert_hsl_to_rgb (double hue, double saturation, double lightness, Gdk.RGBA rgba);
		public static void convert_hsv_to_rgb (double hue, double saturation, double value, Gdk.RGBA rgba);
		public static void convert_hsv_to_xyz (double hue, double saturation, double value, out Gstyle.XYZ xyz);
		public static void convert_rgb_to_cielab (Gdk.RGBA rgba, out Gstyle.Cielab lab);
		public static void convert_rgb_to_hsl (Gdk.RGBA rgba, out double hue, out double saturation, out double lightness);
		public static void convert_rgb_to_hsv (Gdk.RGBA rgba, out double hue, out double saturation, out double value);
		public static void convert_rgb_to_xyz (Gdk.RGBA rgba, Gstyle.XYZ xyz);
		public static void convert_xyz_to_cielab (Gstyle.XYZ xyz, Gstyle.Cielab lab);
		public static void convert_xyz_to_hsv (Gstyle.XYZ xyz, out double hue, out double saturation, out double value);
		public static void convert_xyz_to_rgb (Gstyle.XYZ xyz, Gdk.RGBA rgba);
		public Gstyle.Color copy ();
		public static double delta_e (Gstyle.Cielab lab1, Gstyle.Cielab lab2);
		public void fill (Gstyle.Color dst_color);
		public Gdk.RGBA fill_rgba ();
		[CCode (has_construct_function = false)]
		public Color.from_hsla (string name, Gstyle.ColorKind kind, double hue, double saturation, double lightness, double alpha);
		[CCode (has_construct_function = false)]
		public Color.from_rgba (string? name, Gstyle.ColorKind kind, Gdk.RGBA rgba);
		[CCode (has_construct_function = false)]
		public Color.from_string (string? name, string color_string);
		public static GLib.GenericArray<Gstyle.Color> fuzzy_parse_color_string (string color_string);
		public Gstyle.ColorKind get_kind ();
		public unowned string get_name ();
		public Gdk.RGBA? get_rgba ();
		public static GLib.GenericArray<Gstyle.ColorItem>? parse (string string);
		public static bool parse_color_string (string color_string, out Gdk.RGBA rgba, out Gstyle.ColorKind kind);
		public void set_alpha (double alpha);
		public void set_kind (Gstyle.ColorKind kind);
		public void set_name (string? name);
		public void set_rgba (Gdk.RGBA rgba);
		public void to_hsla (out double hue, out double saturation, out double lightness, out double alpha);
		public string to_string (Gstyle.ColorKind kind);
		public Gstyle.ColorKind kind { get; set construct; }
		public string name { get; set construct; }
		public Gdk.RGBA rgba { get; set construct; }
	}
	[CCode (cheader_filename = "gstyle-private.h", ref_function = "gstyle_color_item_ref", type_id = "gstyle_color_item_get_type ()", unref_function = "gstyle_color_item_unref")]
	[Compact]
	public class ColorItem {
		[CCode (has_construct_function = false)]
		public ColorItem (Gstyle.Color? color, int start, int len);
		public Gstyle.ColorItem copy ();
		public void free ();
		public unowned Gstyle.Color get_color ();
		public uint get_len ();
		public uint get_start ();
		public unowned Gstyle.ColorItem @ref ();
		public void set_color (Gstyle.Color? color);
		public void unref ();
	}
	[CCode (cheader_filename = "gstyle-private.h", type_id = "gstyle_color_panel_get_type ()")]
	public class ColorPanel : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		public ColorPanel ();
		public Gstyle.ColorFilter get_filter ();
		public unowned Gstyle.PaletteWidget? get_palette_widget ();
		public Gdk.RGBA get_rgba ();
		public void get_xyz (out Gstyle.XYZ xyz);
		public void set_filter (Gstyle.ColorFilter filter);
		public void set_prefs_pages (Gtk.Widget components_page, Gtk.Widget colorstrings_page, Gtk.Widget palettes_page, Gtk.Widget palettes_list_page);
		public void set_rgba (Gdk.RGBA rgba);
		public void set_xyz (Gstyle.XYZ xyz);
		public void show_palette (Gstyle.Palette palette);
		public Gstyle.ColorFilter filter { get; set construct; }
		[NoAccessorMethod]
		public bool hsv_visible { get; set construct; }
		[NoAccessorMethod]
		public bool lab_visible { get; set construct; }
		[NoAccessorMethod]
		public Gstyle.ColorUnit rgb_unit { get; set construct; }
		[NoAccessorMethod]
		public bool rgb_visible { get; set construct; }
		public Gdk.RGBA rgba { get; set construct; }
		[NoAccessorMethod]
		public Gstyle.ColorPanelStringsVisibleFlags strings_visible { get; set construct; }
		[NoAccessorMethod]
		public Gstyle.XYZ xyz { owned get; set construct; }
		public signal void update_prefs (Gstyle.ColorPanelPrefs object);
	}
	[CCode (cheader_filename = "gstyle-private.h", type_id = "gstyle_color_plane_get_type ()")]
	public class ColorPlane : Gtk.DrawingArea, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public ColorPlane ();
		public unowned Gtk.Adjustment get_component_adjustment (Gstyle.ColorComponent comp);
		public Gdk.RGBA get_filtered_rgba ();
		public Gdk.RGBA get_rgba ();
		public void get_xyz (out Gstyle.XYZ xyz);
		public void set_filter_func (Gstyle.ColorFilterFunc? filter_cb);
		public void set_mode (Gstyle.ColorPlaneMode mode);
		public void set_preferred_unit (Gstyle.ColorUnit preferred_unit);
		public void set_rgba (Gdk.RGBA rgba);
		public void set_xyz (Gstyle.XYZ xyz);
		[NoAccessorMethod]
		public Gstyle.ColorPlaneMode mode { get; set construct; }
		public Gdk.RGBA rgba { get; set construct; }
		[NoAccessorMethod]
		public Gstyle.XYZ xyz { owned get; set construct; }
	}
	[CCode (cheader_filename = "gstyle-private.h", type_id = "gstyle_color_scale_get_type ()")]
	public class ColorScale : Gtk.Scale, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		public ColorScale (Gtk.Adjustment adjustment);
		public int add_color_stop (double offset, double red, double green, double blue, double alpha);
		public int add_rgba_color_stop (double offset, Gdk.RGBA rgba);
		public void clear_color_stops ();
		public Gstyle.ColorScaleKind get_kind ();
		public bool remove_color_stop (int id);
		public void set_custom_data (uint32 data);
		public void set_filter_func (Gstyle.ColorFilterFunc? filter_cb);
		public void set_kind (Gstyle.ColorScaleKind kind);
		public Gstyle.ColorScaleKind kind { get; set construct; }
	}
	[CCode (cheader_filename = "gstyle-private.h", type_id = "gstyle_color_widget_get_type ()")]
	public class ColorWidget : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public ColorWidget ();
		public Gstyle.ColorWidget copy ();
		public unowned Gstyle.Color get_color ();
		public Gstyle.ColorKind get_fallback_name_kind ();
		public bool get_fallback_name_visible ();
		public unowned Gstyle.Color get_filtered_color ();
		public bool get_name_visible ();
		public void set_color (Gstyle.Color? color);
		public void set_fallback_name_kind (Gstyle.ColorKind kind);
		public void set_fallback_name_visible (bool visible);
		public void set_filter_func (Gstyle.ColorFilterFunc? filter_func);
		public void set_name_visible (bool visible);
		[CCode (has_construct_function = false)]
		public ColorWidget.with_color (Gstyle.Color color);
		public Gstyle.Color color { get; set construct; }
		[NoAccessorMethod]
		public Gstyle.ColorWidgetDndLockFlags dnd_lock { get; set construct; }
		public Gstyle.ColorKind fallback_name_kind { get; set construct; }
		public bool fallback_name_visible { get; set construct; }
		public bool name_visible { get; set construct; }
	}
	[CCode (cheader_filename = "gstyle-private.h", type_id = "gstyle_eyedropper_get_type ()")]
	public class Eyedropper : Gtk.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public Eyedropper (Gdk.Event event);
		public Gdk.Event source_event { construct; }
		public signal void color_picked (Gdk.RGBA rgba);
		public signal void grab_released ();
	}
	[CCode (cheader_filename = "gstyle-private.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gstyle_hsv_get_type ()")]
	[Compact]
	public class HSV {
		public Gstyle.HSV copy ();
		public void free ();
	}
	[CCode (cheader_filename = "gstyle-private.h", type_id = "gstyle_palette_get_type ()")]
	public class Palette : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		public Palette ();
		public bool add (Gstyle.Color color) throws GLib.Error;
		public bool add_at_index (Gstyle.Color color, int position) throws GLib.Error;
		public static GLib.Quark error_quark ();
		[CCode (has_construct_function = false)]
		public Palette.from_buffer (Gtk.TextBuffer buffer, Gtk.TextIter? begin, Gtk.TextIter? end, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Palette.from_file (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool get_changed ();
		public unowned Gstyle.Color? get_color_at_index (uint index);
		public unowned GLib.GenericArray<Gstyle.Color> get_colors ();
		public GLib.File get_file ();
		public unowned string get_id ();
		public int get_index (Gstyle.Color color);
		public uint get_len ();
		public unowned string get_name ();
		public unowned GLib.GenericArray<Gstyle.Color>? lookup (string name);
		public bool remove (Gstyle.Color color);
		public bool remove_at_index (int position);
		public bool save_to_xml (GLib.File file) throws GLib.Error;
		public void set_changed (bool changed);
		public void set_id (string id);
		public void set_name (string name);
		public bool changed { get; set; }
		public GLib.File colors { get; }
		[NoAccessorMethod]
		public string domain { owned get; construct; }
		public GLib.File file { owned get; construct; }
		public string id { get; set construct; }
		public uint len { get; }
		public string name { get; set construct; }
	}
	[CCode (cheader_filename = "gstyle-private.h", type_id = "gstyle_palette_widget_get_type ()")]
	public class PaletteWidget : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public PaletteWidget ();
		public bool add (Gstyle.Palette palette);
		public GLib.GenericArray<Gstyle.Color> fuzzy_parse_color_string (string color_string);
		public Gstyle.PaletteWidgetDndLockFlags get_dnd_lock ();
		public GLib.List<weak Gstyle.Palette> get_list ();
		public int get_n_palettes ();
		public unowned Gstyle.Palette get_palette_at_index (uint index);
		public unowned Gstyle.Palette get_palette_by_id (string id);
		public unowned Gtk.Widget get_placeholder ();
		public unowned Gstyle.Palette? get_selected_palette ();
		public Gstyle.PaletteWidgetSortMode get_sort_mode ();
		public unowned GLib.ListStore get_store ();
		public Gstyle.PaletteWidgetViewMode get_view_mode ();
		public bool remove (Gstyle.Palette palette);
		public void remove_all ();
		public bool remove_by_id (string id);
		public void set_dnd_lock (Gstyle.PaletteWidgetDndLockFlags flags);
		public void set_placeholder (Gtk.Widget placeholder);
		public void set_sort_mode (Gstyle.PaletteWidgetSortMode mode);
		public void set_view_mode (Gstyle.PaletteWidgetViewMode mode);
		public bool show_palette (Gstyle.Palette palette);
		public Gstyle.PaletteWidgetDndLockFlags dnd_lock { get; set construct; }
		public Gtk.Widget placeholder { get; set; }
		[NoAccessorMethod]
		public string selected_palette_id { owned get; set; }
		public Gstyle.PaletteWidgetSortMode sort_mode { get; set; }
		public Gstyle.PaletteWidgetViewMode view_mode { get; set; }
		public signal void activated (Gstyle.Palette palette, int position);
		public signal void palette_added (Gstyle.Palette palette);
		public signal void palette_removed (Gstyle.Palette palette);
	}
	[CCode (cheader_filename = "gstyle-private.h", type_id = "gstyle_slidein_get_type ()")]
	public class Slidein : Gtk.EventBox, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Slidein ();
		public void add_slide (Gtk.Widget slide);
		public Gstyle.SlideinDirectionType get_direction_type ();
		public bool get_interpolate_size ();
		public bool get_revealed ();
		public double get_slide_fraction ();
		public void remove_slide ();
		public bool reveal_slide (bool reveal);
		public void set_direction_type (Gstyle.SlideinDirectionType direction_type);
		public void set_interpolate_size (bool interpolate_size);
		public void set_slide_fraction (double slide_fraction);
		public Gstyle.SlideinDirectionType direction_type { get; set; }
		[NoAccessorMethod]
		public double duration { get; set; }
		public bool interpolate_size { get; set; }
		public bool revealed { get; }
		public double slide_fraction { get; set; }
		[NoAccessorMethod]
		public uint slide_margin { get; set; }
		public signal void closing ();
		public signal void opening ();
	}
	[CCode (cheader_filename = "gstyle-private.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gstyle_xyz_get_type ()")]
	[Compact]
	public class XYZ {
		public Gstyle.XYZ copy ();
		public void free ();
	}
	[CCode (cheader_filename = "gstyle-private.h", cname = "_GstyleCielab", has_type_id = false)]
	public struct _Cielab {
		public double l;
		public double a;
		public double b;
		public double alpha;
	}
	[CCode (cheader_filename = "gstyle-private.h", cname = "_GstyleColorItem", has_type_id = false)]
	public struct _ColorItem {
		public weak Gstyle.Color color;
		public uint start;
		public uint len;
		public int ref_count;
	}
	[CCode (cheader_filename = "gstyle-private.h", cname = "_GstyleHSV", has_type_id = false)]
	public struct _HSV {
		public double h;
		public double s;
		public double v;
		public double alpha;
	}
	[CCode (cheader_filename = "gstyle-private.h", cname = "_GstyleXYZ", has_type_id = false)]
	public struct _XYZ {
		public double x;
		public double y;
		public double z;
		public double alpha;
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "", has_type_id = false)]
	public enum ColorComponent {
		[CCode (cname = "GSTYLE_COLOR_COMPONENT_HSV_H")]
		STYLE_COLOR_COMPONENT_HSV_H,
		[CCode (cname = "GSTYLE_COLOR_COMPONENT_HSV_S")]
		STYLE_COLOR_COMPONENT_HSV_S,
		[CCode (cname = "GSTYLE_COLOR_COMPONENT_HSV_V")]
		STYLE_COLOR_COMPONENT_HSV_V,
		[CCode (cname = "GSTYLE_COLOR_COMPONENT_LAB_L")]
		STYLE_COLOR_COMPONENT_LAB_L,
		[CCode (cname = "GSTYLE_COLOR_COMPONENT_LAB_A")]
		STYLE_COLOR_COMPONENT_LAB_A,
		[CCode (cname = "GSTYLE_COLOR_COMPONENT_LAB_B")]
		STYLE_COLOR_COMPONENT_LAB_B,
		[CCode (cname = "GSTYLE_COLOR_COMPONENT_RGB_RED")]
		STYLE_COLOR_COMPONENT_RGB_RED,
		[CCode (cname = "GSTYLE_COLOR_COMPONENT_RGB_GREEN")]
		STYLE_COLOR_COMPONENT_RGB_GREEN,
		[CCode (cname = "GSTYLE_COLOR_COMPONENT_RGB_BLUE")]
		STYLE_COLOR_COMPONENT_RGB_BLUE,
		[CCode (cname = "N_GSTYLE_COLOR_COMPONENT")]
		_GSTYLE_COLOR_COMPONENT,
		[CCode (cname = "GSTYLE_COLOR_COMPONENT_NONE")]
		STYLE_COLOR_COMPONENT_NONE
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_COLOR_FILTER_", type_id = "gstyle_color_filter_get_type ()")]
	public enum ColorFilter {
		NONE,
		ACHROMATOPSIA,
		ACHROMATOMALY,
		DEUTERANOPIA,
		DEUTERANOMALY,
		PROTANOPIA,
		PROTANOMALY,
		TRITANOPIA,
		TRITANOMALY,
		WEBSAFE;
		public static void achromatomaly (Gdk.RGBA rgba, out Gdk.RGBA filter_rgba, void* user_data);
		public static void achromatopsia (Gdk.RGBA rgba, out Gdk.RGBA filter_rgba, void* user_data);
		public static void deuteranomaly (Gdk.RGBA rgba, out Gdk.RGBA filter_rgba, void* user_data);
		public static void deuteranopia (Gdk.RGBA rgba, out Gdk.RGBA filter_rgba, void* user_data);
		public static void protanomaly (Gdk.RGBA rgba, out Gdk.RGBA filter_rgba, void* user_data);
		public static void protanopia (Gdk.RGBA rgba, out Gdk.RGBA filter_rgba, void* user_data);
		public static void tritanomaly (Gdk.RGBA rgba, out Gdk.RGBA filter_rgba, void* user_data);
		public static void tritanopia (Gdk.RGBA rgba, out Gdk.RGBA filter_rgba, void* user_data);
		public static void websafe (Gdk.RGBA rgba, out Gdk.RGBA filter_rgba, void* user_data);
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_COLOR_KIND_", type_id = "gstyle_color_kind_get_type ()")]
	public enum ColorKind {
		UNKNOW,
		ORIGINAL,
		[CCode (cname = "GSTYLE_COLOR_KIND_RGB_HEX6")]
		RGBHEX6,
		[CCode (cname = "GSTYLE_COLOR_KIND_RGB_HEX3")]
		RGBHEX3,
		RGB,
		[CCode (cname = "GSTYLE_COLOR_KIND_RGB_PERCENT")]
		RGBPERCENT,
		RGBA,
		[CCode (cname = "GSTYLE_COLOR_KIND_RGBA_PERCENT")]
		RGBAPERCENT,
		HSL,
		HSLA,
		PREDEFINED
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_COLOR_PANEL_PREFS_", type_id = "gstyle_color_panel_prefs_get_type ()")]
	public enum ColorPanelPrefs {
		COMPONENTS,
		[CCode (cname = "GSTYLE_COLOR_PANEL_PREFS_COLOR_STRINGS")]
		COLORSTRINGS,
		PALETTES,
		[CCode (cname = "GSTYLE_COLOR_PANEL_PREFS_PALETTES_LIST")]
		PALETTESLIST
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_COLOR_PANEL_STRINGS_VISIBLE_FLAGS_", type_id = "gstyle_color_panel_strings_visible_flags_get_type ()")]
	[Flags]
	public enum ColorPanelStringsVisibleFlags {
		NONE,
		HEX3,
		HEX6,
		RGB,
		RGBA,
		HSL,
		HSLA
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_COLOR_PLANE_MODE_", type_id = "gstyle_color_plane_mode_get_type ()")]
	public enum ColorPlaneMode {
		HUE,
		SATURATION,
		BRIGHTNESS,
		CIELAB_L,
		CIELAB_A,
		CIELAB_B,
		RED,
		GREEN,
		BLUE
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_COLOR_SCALE_KIND_", type_id = "gstyle_color_scale_kind_get_type ()")]
	public enum ColorScaleKind {
		HUE,
		GREY,
		ALPHA,
		RED,
		GREEN,
		BLUE,
		[CCode (cname = "GSTYLE_COLOR_SCALE_KIND_CUSTOM")]
		CUSTOM_STOPS,
		[CCode (cname = "GSTYLE_COLOR_SCALE_KIND_CUSTOM")]
		CUSTOM_DATA
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_COLOR_UNIT_", type_id = "gstyle_color_unit_get_type ()")]
	public enum ColorUnit {
		NONE,
		PERCENT,
		VALUE
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_COLOR_WIDGET_DND_LOCK_FLAGS_", type_id = "gstyle_color_widget_dnd_lock_flags_get_type ()")]
	[Flags]
	public enum ColorWidgetDndLockFlags {
		NONE,
		KIND,
		NAME,
		ALPHA,
		COLOR,
		ALL
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_PALETTE_ERROR_", has_type_id = false)]
	public enum PaletteError {
		DUP_COLOR_NAME,
		EMPTY,
		FILE,
		FORMAT,
		PARSE
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_PALETTE_WIDGET_DND_LOCK_FLAGS_", type_id = "gstyle_palette_widget_dnd_lock_flags_get_type ()")]
	[Flags]
	public enum PaletteWidgetDndLockFlags {
		NONE,
		DRAG,
		DROP,
		ALL
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_PALETTE_WIDGET_SORT_MODE_", type_id = "gstyle_palette_widget_sort_mode_get_type ()")]
	public enum PaletteWidgetSortMode {
		ORIGINAL,
		LIGHT,
		APPROCHING
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_PALETTE_WIDGET__VIEW_MODE_", type_id = "gstyle_palette_widget_view_mode_get_type ()")]
	public enum PaletteWidgetViewMode {
		LIST,
		SWATCHS
	}
	[CCode (cheader_filename = "gstyle-private.h", cprefix = "GSTYLE_SLIDEIN_DIRECTION_TYPE_", type_id = "gstyle_slidein_type_get_type ()")]
	public enum SlideinDirectionType {
		NONE,
		RIGHT,
		LEFT,
		UP,
		DOWN
	}
	[CCode (cheader_filename = "gstyle-private.h", instance_pos = 2.9)]
	public delegate void ColorFilterFunc (Gdk.RGBA rgba, Gdk.RGBA filter_rgba);
	[CCode (cheader_filename = "gstyle-private.h", cname = "GSTYLE_COLOR_SCALE_CUSTOM_DATA_BYTE_SIZE")]
	public const int COLOR_SCALE_CUSTOM_DATA_BYTE_SIZE;
	[CCode (cheader_filename = "gstyle-private.h", cname = "GSTYLE_COLOR_SCALE_CUSTOM_DATA_PIXEL_SIZE")]
	public const int COLOR_SCALE_CUSTOM_DATA_PIXEL_SIZE;
}
