/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.bib;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibData;
import com.dickimawbooks.texparserlib.bib.BibTeXSyntaxException;
import com.dickimawbooks.texparserlib.bib.BibValue;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;

public class BibPreamble
extends BibData {
    private String entryType;
    private BibValueList preamble;

    public BibPreamble() {
        this("preamble");
    }

    public BibPreamble(String string) {
        this.entryType = string;
    }

    @Override
    public String getEntryType() {
        return this.entryType;
    }

    public BibValueList getPreamble() {
        return this.preamble;
    }

    @Override
    public void parseContents(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.preamble = new BibValueList();
        this.readValue(teXParser, teXObjectList, this.preamble, teXObject);
        if (this.preamble.isEmpty()) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.missing_field_part");
        }
        for (int i = 0; i < this.preamble.size(); ++i) {
            BibValue bibValue = (BibValue)this.preamble.get(i);
        }
    }

    @Override
    public String format(byte by, char c, char c2, byte by2) {
        return String.format("@%s%c%s%c", BibPreamble.applyCase(this.entryType, by), Character.valueOf(c), this.preamble.applyDelim(by2), Character.valueOf(c2));
    }

    public String toString() {
        return String.format("%s[type=%s,contents=%s]", this.getClass().getSimpleName(), this.entryType, this.preamble);
    }
}

