/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.explorer.propertysheet.EditorPropertyDisplayer;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyDialogManager;
import org.openide.explorer.propertysheet.PropertyDisplayer_Editable;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class CustomEditorDisplayer
implements PropertyDisplayer_Editable {
    private int updatePolicy = 0;
    private Node.Property prop;
    private PropertyEnv env = null;
    private PropertyEditor editor = null;
    private Component customEditor = null;
    boolean ignoreChanges = false;
    private PropertyChangeListener editorListener = null;
    private EnvListener envListener = null;
    private PropertyModel model = null;
    private Object originalValue = null;
    private EventListenerList listenerList = null;
    private boolean ignoreChanges2 = false;
    private PropertyChangeListener remoteEnvListener = null;
    private VetoableChangeListener remotevEnvListener = null;

    public CustomEditorDisplayer(Node.Property property) {
        this.prop = property;
    }

    public CustomEditorDisplayer(Node.Property property, PropertyModel propertyModel) {
        this(property);
        this.model = propertyModel;
    }

    @Override
    public void setUpdatePolicy(int n) {
        this.updatePolicy = n;
        if (this.env != null) {
            this.env.setChangeImmediate(n != 2);
        }
    }

    private Component getCustomEditor() {
        if (this.customEditor == null) {
            this.customEditor = this.getPropertyEditor().getCustomEditor();
        }
        return this.customEditor;
    }

    PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.setPropertyEditor(PropUtils.getPropertyEditor(this.getProperty()));
        }
        return this.editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropertyEditor(PropertyEditor propertyEditor) {
        block8: {
            if (this.editor != null) {
                this.detachFromPropertyEditor(this.editor);
                this.ignoreChanges = true;
            }
            this.editor = propertyEditor;
            try {
                if (propertyEditor == null) break block8;
                if (!propertyEditor.supportsCustomEditor()) {
                    Class clazz = this.prop.getValueType();
                    throw new IllegalArgumentException("#177688: property editor " + propertyEditor + " for property " + this.prop + " does not support a custom editor; valueType=" + clazz.getName() + "; PropertyEditorManager says: " + PropertyEditorManager.findEditor(clazz) + "; search path is: " + Arrays.toString(PropertyEditorManager.getEditorSearchPath()) + "; CCL: " + Thread.currentThread().getContextClassLoader());
                }
                try {
                    this.originalValue = propertyEditor.getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PropertyEnv propertyEnv = new PropertyEnv();
                propertyEnv.setFeatureDescriptor(EditorPropertyDisplayer.findFeatureDescriptor(this));
                this.setPropertyEnv(propertyEnv);
                if (propertyEditor instanceof ExPropertyEditor) {
                    ((ExPropertyEditor)propertyEditor).attachEnv(propertyEnv);
                }
                this.attachToPropertyEditor(propertyEditor);
            }
            finally {
                this.ignoreChanges = false;
            }
        }
    }

    private void setPropertyEnv(PropertyEnv propertyEnv) {
        if (this.env != null) {
            this.detachFromEnv(this.env);
        }
        this.env = propertyEnv;
        if (propertyEnv != null) {
            propertyEnv.setChangeImmediate(this.getUpdatePolicy() != 2);
            this.attachToEnv(propertyEnv);
        }
    }

    private void attachToEnv(PropertyEnv propertyEnv) {
        propertyEnv.addPropertyChangeListener(this.getEnvListener());
        propertyEnv.addVetoableChangeListener(this.getEnvListener());
        propertyEnv.setBeans(EditorPropertyDisplayer.findBeans(this));
    }

    private void detachFromEnv(PropertyEnv propertyEnv) {
        propertyEnv.removePropertyChangeListener(this.getEnvListener());
        propertyEnv.removeVetoableChangeListener(this.getEnvListener());
    }

    private void attachToPropertyEditor(PropertyEditor propertyEditor) {
        propertyEditor.addPropertyChangeListener(this.getEditorListener());
    }

    private void detachFromPropertyEditor(PropertyEditor propertyEditor) {
        propertyEditor.removePropertyChangeListener(this.getEditorListener());
    }

    private PropertyChangeListener getEditorListener() {
        if (this.editorListener == null) {
            this.editorListener = new EditorListener();
        }
        return this.editorListener;
    }

    private EnvListener getEnvListener() {
        if (this.envListener == null) {
            this.envListener = new EnvListener();
        }
        return this.envListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit() throws IllegalArgumentException {
        try {
            Object object;
            this.ignoreChanges = true;
            PropertyEditor propertyEditor = this.getPropertyEditor();
            Object object2 = this.getEnteredValue();
            try {
                if (object2 != null && object2.equals(this.getProperty().getValue())) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception exception) {
                Logger.getLogger(CustomEditorDisplayer.class.getName()).log(Level.WARNING, null, exception);
                try {
                    if (this.getProperty().canRead()) {
                        propertyEditor.setValue(this.model.getValue());
                    }
                }
                catch (ProxyNode.DifferentValuesException differentValuesException) {
                }
                catch (Exception exception2) {
                    PropertyDialogManager.notify(exception2);
                }
                boolean bl = false;
                return bl;
            }
            PropertyEnv propertyEnv = this.getPropertyEnv();
            Exception exception = PropUtils.updatePropertyEditor(propertyEditor, object2);
            if (exception == null && propertyEnv != null && PropertyEnv.STATE_NEEDS_VALIDATION.equals(propertyEnv.getState())) {
                object = propertyEnv.silentlySetState(PropertyEnv.STATE_VALID, object2);
                System.err.println("  result of silent set state: " + (String)object);
                if (object != null && !PropertyEnv.STATE_VALID.equals(propertyEnv.getState())) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error setting value");
                    Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)object);
                    if (!PropertyEnv.STATE_INVALID.equals(propertyEnv.getState())) {
                        propertyEnv.silentlySetState(PropertyEnv.STATE_INVALID, null);
                    }
                    throw illegalArgumentException;
                }
            }
            object = Boolean.FALSE;
            if (exception == null) {
                object = PropUtils.noDlgUpdateProp(this.getModel(), propertyEditor);
                this.originalValue = propertyEditor.getValue();
                if (object instanceof Exception && !(object instanceof ProxyNode.DifferentValuesException)) {
                    exception = (Exception)object;
                }
                if (object instanceof InvocationTargetException || object instanceof IllegalAccessException) {
                    PropertyDialogManager.notify((Exception)object);
                }
            }
            if (exception != null) {
                if (exception instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)exception;
                }
                PropertyDialogManager.notify(exception);
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error setting value");
                Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)PropUtils.findLocalizedMessage(exception, object2, this.getProperty().getDisplayName()));
                throw illegalArgumentException;
            }
            boolean bl = Boolean.TRUE.equals(object);
            if (bl) {
                this.fireActionPerformed();
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    PropertyModel getModel() {
        if (this.model == null) {
            return new NodePropertyModel(this.getProperty(), null);
        }
        return this.model;
    }

    void setModel(PropertyModel propertyModel) {
        this.model = propertyModel;
    }

    @Override
    public PropertyEnv getPropertyEnv() {
        return this.env;
    }

    @Override
    public Component getComponent() {
        return this.getCustomEditor();
    }

    @Override
    public Object getEnteredValue() {
        PropertyEditor propertyEditor = this.getPropertyEditor();
        Object object = this.customEditor instanceof EnhancedCustomPropertyEditor ? ((EnhancedCustomPropertyEditor)((Object)this.customEditor)).getPropertyValue() : propertyEditor.getValue();
        return object;
    }

    @Override
    public Node.Property getProperty() {
        return this.prop;
    }

    @Override
    public int getUpdatePolicy() {
        return this.updatePolicy;
    }

    @Override
    public String isModifiedValueLegal() {
        boolean bl = true;
        String string = null;
        PropertyEditor propertyEditor = this.getPropertyEditor();
        if (this.env != null) {
            bl = this.env.getState() != PropertyEnv.STATE_INVALID;
            System.err.println(" Attempting to validate env");
            if (bl) {
                if (PropertyEnv.STATE_NEEDS_VALIDATION.equals(this.env.getState())) {
                    string = this.env.silentlySetState(PropertyEnv.STATE_VALID, this.getEnteredValue());
                    bl = string == null;
                }
            }
        } else if (propertyEditor instanceof EnhancedCustomPropertyEditor) {
            Object object = ((EnhancedCustomPropertyEditor)((Object)propertyEditor)).getPropertyValue();
            try {
                propertyEditor.setValue(object);
            }
            catch (IllegalStateException illegalStateException) {
                bl = false;
                string = PropUtils.findLocalizedMessage(illegalStateException, object, this.getProperty().getDisplayName());
            }
        }
        if (!bl && string == null) {
            string = NbBundle.getMessage(CustomEditorDisplayer.class, (String)"FMT_CannotUpdateProperty", (Object)propertyEditor.getValue(), (Object)this.getProperty().getDisplayName());
        }
        return string;
    }

    @Override
    public boolean isValueModified() {
        boolean bl;
        PropertyEditor propertyEditor = this.getPropertyEditor();
        boolean bl2 = bl = propertyEditor.getValue() != this.originalValue;
        if (!bl && propertyEditor instanceof EnhancedCustomPropertyEditor) {
            Object object = ((EnhancedCustomPropertyEditor)((Object)propertyEditor)).getPropertyValue();
            bl = object != null ? object.equals(this.originalValue) : this.originalValue == null;
        }
        return bl;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void reset() {
        try {
            this.originalValue = this.getProperty().getValue();
            this.getPropertyEditor().setValue(this.originalValue);
        }
        catch (Exception exception) {
            Logger.getLogger(CustomEditorDisplayer.class.getName()).log(Level.WARNING, null, exception);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        Container container = (Container)this.getComponent();
        if (container instanceof Container) {
            this.setEnabled(container, bl);
        }
        container.setEnabled(bl);
    }

    public void setEnabled(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Boolean bl2;
            if (!(componentArray[i] instanceof JScrollBar)) {
                componentArray[i].setEnabled(false);
            } else {
                ((JScrollBar)componentArray[i]).setFocusable(bl);
            }
            if (!(componentArray[i] instanceof Container)) continue;
            boolean bl3 = false;
            if (componentArray[i] instanceof JComponent && (bl2 = (Boolean)((JComponent)componentArray[i]).getClientProperty("dontEnableMe")) != null) {
                bl3 = bl2;
            }
            if (bl3) continue;
            this.setEnabled((Container)componentArray[i], bl);
        }
        container.setEnabled(bl);
    }

    @Override
    public void setEnteredValue(Object object) {
        PropUtils.updatePropertyEditor(this.getPropertyEditor(), object);
    }

    @Override
    public void setActionCommand(String string) {
    }

    @Override
    public String getActionCommand() {
        return null;
    }

    @Override
    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, actionListener);
    }

    @Override
    public synchronized void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    private void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, "userChangedValue");
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    @Override
    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    void setRemoteEnvListener(PropertyChangeListener propertyChangeListener) {
        this.remoteEnvListener = propertyChangeListener;
    }

    void setRemoteEnvVetoListener(VetoableChangeListener vetoableChangeListener) {
        this.remotevEnvListener = vetoableChangeListener;
    }

    private class EditorListener
    implements PropertyChangeListener {
        private EditorListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (CustomEditorDisplayer.this.ignoreChanges) {
                return;
            }
            if ("propertyValueValid".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (CustomEditorDisplayer.this.ignoreChanges2) {
                return;
            }
            CustomEditorDisplayer.this.ignoreChanges2 = true;
            if (CustomEditorDisplayer.this.getUpdatePolicy() != 2) {
                CustomEditorDisplayer.this.commit();
            }
            CustomEditorDisplayer.this.fireStateChanged();
            CustomEditorDisplayer.this.ignoreChanges2 = false;
        }
    }

    private class EnvListener
    implements PropertyChangeListener,
    VetoableChangeListener {
        private EnvListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CustomEditorDisplayer.this.fireStateChanged();
            if (CustomEditorDisplayer.this.remoteEnvListener != null) {
                CustomEditorDisplayer.this.remoteEnvListener.propertyChange(propertyChangeEvent);
            }
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (CustomEditorDisplayer.this.remotevEnvListener != null) {
                CustomEditorDisplayer.this.remotevEnvListener.vetoableChange(propertyChangeEvent);
            }
        }
    }
}

