/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.vncviewer.Dialog;
import com.tigervnc.vncviewer.Parameters;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

class ClipboardDialog
extends Dialog {
    private JButton clearButton;
    private JButton sendButton;
    private JButton cancelButton;
    private static boolean listen = true;
    static ClipboardDialog dialog;
    static MyJTextArea textArea;
    static Toolkit tk;
    static LogWriter vlog;

    public ClipboardDialog() {
        super(false);
        this.setTitle("VNC Clipboard Viewer");
        this.setPreferredSize(new Dimension(640, 480));
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                ClipboardDialog.clientCutText();
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane(textArea);
        this.getContentPane().add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        this.clearButton = new JButton("Clear");
        jPanel.add(this.clearButton);
        this.sendButton = new JButton("Send to VNC server");
        jPanel.add(this.sendButton);
        this.cancelButton = new JButton("Cancel");
        jPanel.add(this.cancelButton);
        this.getContentPane().add("South", jPanel);
        this.addListeners(this);
        this.pack();
    }

    public static void showDialog(Container container) {
        if (dialog == null) {
            dialog = new ClipboardDialog();
        }
        dialog.show(container);
    }

    public void show(Container container) {
        super.showDialog(container);
    }

    @Override
    public void endDialog() {
        super.endDialog();
        dialog.dispose();
    }

    public static void serverCutText(String string) {
        if (textArea.getText().equals(string)) {
            return;
        }
        listen = false;
        textArea.setText(string);
        textArea.copy();
        listen = true;
    }

    public static void clientCutText() {
        textArea.paste();
        textArea.setCaretPosition(0);
    }

    public void setSendingEnabled(boolean bl) {
        this.sendButton.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton && (JButton)object == this.clearButton) {
            ClipboardDialog.serverCutText(new String(""));
        } else if (object instanceof JButton && (JButton)object == this.sendButton) {
            String string = textArea.getText();
            VncViewer.cc.writeClientCutText(string, string.length());
            this.endDialog();
        } else if (object instanceof JButton && (JButton)object == this.cancelButton) {
            this.endDialog();
        }
    }

    static {
        textArea = new MyJTextArea();
        tk = Toolkit.getDefaultToolkit();
        vlog = new LogWriter("ClipboardDialog");
    }

    protected static class MyJTextArea
    extends JTextArea {
        public MyJTextArea() {
            this.setTransferHandler(new VncTransferHandler());
            this.getDocument().addDocumentListener(new MyTextListener());
            this.setFocusable(false);
            this.setLineWrap(false);
            this.setWrapStyleWord(true);
        }

        private class MyTextListener
        implements DocumentListener {
            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (!listen) {
                    return;
                }
                String string = textArea.getText();
                if (Parameters.sendClipboard.getValue()) {
                    VncViewer.cc.writeClientCutText(string, string.length());
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }
        }

        private class VncTransferHandler
        extends TransferHandler {
            private LogWriter vlog = new LogWriter("VncTransferHandler");

            private VncTransferHandler() {
            }

            @Override
            public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
                if (!(jComponent instanceof JTextComponent)) {
                    return;
                }
                String string = ((JTextComponent)jComponent).getText();
                try {
                    if (string.equals((String)clipboard.getData(DataFlavor.stringFlavor))) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    this.vlog.info(iOException.toString());
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    this.vlog.info(unsupportedFlavorException.toString());
                }
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, null);
            }

            @Override
            public boolean importData(JComponent jComponent, Transferable transferable) {
                if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                    try {
                        DataFlavor dataFlavor = null;
                        for (DataFlavor dataFlavor2 : transferable.getTransferDataFlavors()) {
                            if (!dataFlavor2.isMimeTypeEqual("text/plain") || !dataFlavor2.isRepresentationClassInputStream()) continue;
                            dataFlavor = dataFlavor2;
                            break;
                        }
                        if (dataFlavor == null) {
                            return false;
                        }
                        CharBuffer charBuffer = CharBuffer.allocate(Parameters.maxCutText.getValue());
                        Reader reader = dataFlavor.getReaderForText(transferable);
                        int n = reader.read(charBuffer.array(), 0, charBuffer.length());
                        reader.close();
                        charBuffer.limit(n < 0 ? 0 : n);
                        if (jComponent instanceof JTextComponent && !charBuffer.toString().equals(((JTextComponent)jComponent).getText())) {
                            ((JTextComponent)jComponent).setText(charBuffer.toString());
                        }
                        return true;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.vlog.error("ERROR: Too much data on local clipboard!");
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        this.vlog.info(unsupportedFlavorException.toString());
                    }
                    catch (IOException iOException) {
                        this.vlog.info(iOException.toString());
                    }
                }
                return false;
            }

            @Override
            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    if (!dataFlavor.isMimeTypeEqual("text/plain") || !dataFlavor.isRepresentationClassReader()) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

