/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoInterpolate
implements UndoOperation {
    private int _startIndex = 0;
    private int _totalInserted = 0;
    private DataPoint[] _points = null;

    public UndoInterpolate(TrackInfo trackInfo, int n) {
        this._startIndex = trackInfo.getSelection().getStart();
        this._points = trackInfo.cloneSelectedRange();
        this._totalInserted = n;
    }

    public String getDescription() {
        return String.valueOf(I18nManager.getText("undo.insert")) + " (" + this._totalInserted + ")";
    }

    public void performUndo(TrackInfo trackInfo) throws UndoException {
        int n = trackInfo.getTrack().getNumPoints() - this._totalInserted;
        DataPoint[] dataPointArray = trackInfo.getTrack().cloneContents();
        DataPoint[] dataPointArray2 = new DataPoint[n];
        System.arraycopy(dataPointArray, 0, dataPointArray2, 0, this._startIndex);
        System.arraycopy(this._points, 0, dataPointArray2, this._startIndex, this._points.length);
        int n2 = this._startIndex + this._points.length;
        System.arraycopy(dataPointArray, n2 + this._totalInserted, dataPointArray2, n2, n - n2);
        trackInfo.getTrack().replaceContents(dataPointArray2);
        trackInfo.getSelection().clearAll();
    }
}

