/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import org.netbeans.core.windows.view.ui.toolbars.DnDSupport;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.openide.awt.Actions;
import org.openide.awt.MouseUtils;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

final class ToolbarContainer
extends JPanel {
    static final String PROP_DRAGGER = "_toolbar_dragger_";
    private static final Logger LOG = Logger.getLogger(Toolbar.class.getName());
    private final Toolbar toolbar;
    private JComponent dragger;
    private final DnDSupport dnd;
    private final boolean draggable;
    private DropTarget dropTarget;
    private int dropIndex = -1;
    private boolean dropBefore;
    private static final int TOP = 2;
    private static final int LEFT = 3;
    private static final int BOTTOM = 2;
    private static final int RIGHT = 3;
    private static Class synthIconClass = null;
    private static boolean testExecuted = false;
    private static Boolean isXP = null;
    private static Map<RenderingHints.Key, Object> hintsMap = null;

    public ToolbarContainer(Toolbar toolbar, final DnDSupport dnDSupport, boolean bl) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.toolbar = toolbar;
        this.dnd = dnDSupport;
        this.draggable = bl;
        this.add((Component)toolbar, "Center");
        toolbar.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                dnDSupport.register(containerEvent.getChild());
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                dnDSupport.unregister(containerEvent.getChild());
            }
        });
        String string = UIManager.getLookAndFeel().getID();
        if (string.equals("Windows")) {
            toolbar.setBorder(Boolean.getBoolean("netbeans.small.main.window") ? BorderFactory.createEmptyBorder(1, 1, 1, 1) : BorderFactory.createEmptyBorder());
        } else if (!"Aqua".equals(string) && !"GTK".equals(string)) {
            Border border = UIManager.getBorder("Nb.ToolBar.border");
            if (null == border) {
                border = UIManager.getBorder("ToolBar.border");
            }
            if (border == null || border instanceof MetalBorders.ToolBarBorder) {
                border = BorderFactory.createEtchedBorder(1);
            }
            toolbar.setBorder((Border)new CompoundBorder(border, new EmptyBorder(2, 3, 2, 3)));
        } else if ("Aqua".equals(string)) {
            toolbar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            toolbar.setOpaque(false);
        }
        if (!"Aqua".equals(string)) {
            toolbar.putClientProperty((Object)"JToolBar.isRollover", (Object)Boolean.TRUE);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (null == this.dragger && this.isDraggable()) {
            this.dragger = this.createDragger();
            this.dragger.setToolTipText(Actions.cutAmpersand((String)this.toolbar.getDisplayName()));
            this.dragger.addMouseListener((MouseListener)new MouseUtils.PopupMouseAdapter(){

                protected void showPopup(MouseEvent mouseEvent) {
                    ToolbarConfiguration toolbarConfiguration = ToolbarConfiguration.findConfiguration(ToolbarPool.getDefault().getConfiguration());
                    if (null != toolbarConfiguration) {
                        toolbarConfiguration.getContextMenu().show(ToolbarContainer.this.dragger, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.addToolbarDragger();
        }
        this.registerDnd();
        if (null == this.dropTarget) {
            this.dropTarget = new DropTarget((Component)this.toolbar, this.dnd);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(0, 0);
        dimension.height = this.toolbar.getMinimumSize().height;
        if (this.toolbar.getComponentCount() <= 1) {
            dimension.width += ToolbarPool.getDefault().getPreferredIconSize();
        } else {
            dimension.width += this.toolbar.getComponent((int)0).getMinimumSize().width;
            if (this.toolbar.getComponentCount() > 1) {
                dimension.width += this.toolbar.getComponent((int)1).getMinimumSize().width;
            }
        }
        Insets insets = this.toolbar.getInsets();
        if (null != insets) {
            dimension.width += insets.left + insets.right;
        }
        return dimension;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.unregisterDnd();
        if (null != this.dropTarget) {
            this.dropTarget.removeDropTargetListener(this.dnd);
            this.dropTarget = null;
        }
    }

    Toolbar getToolbar() {
        return this.toolbar;
    }

    @Override
    public String getName() {
        return null == this.toolbar ? super.getName() : this.toolbar.getName();
    }

    private void addToolbarDragger() {
        Component component = null;
        for (Component component2 : this.toolbar.getComponents()) {
            JComponent jComponent;
            if (!(component2 instanceof JComponent) || !Boolean.TRUE.equals((jComponent = (JComponent)component2).getClientProperty(PROP_DRAGGER))) continue;
            component = component2;
            break;
        }
        if (null != component) {
            this.dragger = (JComponent)component;
        } else {
            this.toolbar.add((Component)this.dragger, 0);
        }
    }

    private void registerDnd() {
        for (Component component : this.toolbar.getComponents()) {
            JComponent jComponent;
            Object object;
            if (!(component instanceof JComponent) || !((object = (jComponent = (JComponent)component).getClientProperty("file")) instanceof DataObject)) continue;
            this.dnd.register(component);
        }
        if (this.isDraggable() && null != this.dragger) {
            this.dnd.register(this.dragger);
        }
    }

    private void unregisterDnd() {
        for (Component component : this.toolbar.getComponents()) {
            this.dnd.unregister(component);
        }
        if (null != this.dragger) {
            this.dnd.unregister(this.dragger);
        }
    }

    private boolean isDraggable() {
        return this.draggable;
    }

    private JComponent createDragger() {
        JPanel jPanel;
        Object object;
        String string = UIManager.getString("Nb.MainWindow.Toolbar.Dragger");
        if (null != string) {
            try {
                object = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass(string);
                jPanel = (JPanel)((Class)object).newInstance();
                if (jPanel instanceof JComponent) {
                    JComponent jComponent = jPanel;
                    jComponent.setCursor(Cursor.getPredefinedCursor(13));
                    jComponent.putClientProperty(PROP_DRAGGER, Boolean.TRUE);
                    return jComponent;
                }
            }
            catch (Exception exception) {
                Logger.getLogger(ToolbarContainer.class.getName()).log(Level.INFO, null, exception);
            }
        }
        object = UIManager.getLookAndFeel().getID();
        jPanel = null;
        jPanel = ((String)object).endsWith("Windows") ? (ToolbarContainer.isXPTheme() ? new ToolbarXP() : new ToolbarGrip()) : (((String)object).equals("Aqua") ? new ToolbarAqua() : (((String)object).equals("GTK") ? new ToolbarGtk() : new ToolbarBump()));
        jPanel.setCursor(Cursor.getPredefinedCursor(13));
        jPanel.putClientProperty(PROP_DRAGGER, Boolean.TRUE);
        return jPanel;
    }

    void setDropGesture(int n, boolean bl) {
        this.dropIndex = n;
        this.dropBefore = bl;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.dropIndex >= 0) {
            this.paintDropGesture(graphics);
        }
    }

    private void paintDropGesture(Graphics graphics) {
        Component component = this.toolbar.getComponentAtIndex(this.dropIndex);
        if (null == component) {
            return;
        }
        Point point = component.getLocation();
        int n = point.x;
        if (!this.dropBefore) {
            n += component.getWidth();
            if (this.dropIndex == this.toolbar.getComponentCount() - 1) {
                n -= 3;
            }
        }
        this.drawDropLine(graphics, n);
    }

    private void drawDropLine(Graphics graphics, int n) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        int n2 = this.getHeight();
        graphics.drawLine(n, 3, n, n2 - 4);
        graphics.drawLine(n - 1, 3, n - 1, n2 - 4);
        graphics.drawLine(n + 1, 2, n + 1 + 2, 2);
        graphics.drawLine(n + 1, n2 - 3, n + 1 + 2, n2 - 3);
        graphics.drawLine(n - 2, 2, n - 2 - 2, 2);
        graphics.drawLine(n - 2, n2 - 3, n - 2 - 2, n2 - 3);
        graphics.setColor(color);
    }

    private static boolean useSynthIcon() {
        if (!testExecuted) {
            testExecuted = true;
            try {
                synthIconClass = ClassLoader.getSystemClassLoader().loadClass("sun.swing.plaf.synth.SynthIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.INFO, null, classNotFoundException);
            }
        }
        return synthIconClass != null;
    }

    private static boolean isXPTheme() {
        if (isXP == null) {
            Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
            isXP = Boolean.TRUE.equals(bl) ? Boolean.TRUE : Boolean.FALSE;
        }
        return isXP;
    }

    static final Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap<RenderingHints.Key, Object>();
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return hintsMap;
    }

    private final class ToolbarGrip
    extends JPanel {
        static final int HGAP = 1;
        static final int VGAP = 2;
        static final int STEP = 1;
        private static final int GRIP_WIDTH = 2;
        int columns;
        Dimension dim;
        Dimension max;

        public ToolbarGrip() {
            this(1);
        }

        public ToolbarGrip(int n) {
            this.columns = n;
            int n2 = (n - 1) * 1 + n * 2 + 2;
            this.dim = new Dimension(n2, n2);
            this.max = new Dimension(n2, Integer.MAX_VALUE);
            this.setBorder(new EmptyBorder(2, 1, 2, 1));
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = 2;
            int n2 = dimension.height - 1 - 2;
            int n3 = n2 - n;
            graphics.setColor(this.getBackground());
            int n4 = 0;
            int n5 = 1;
            while (n4 < this.columns) {
                graphics.draw3DRect(n5, n, 2, n3, true);
                ++n4;
                n5 += 3;
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.dim;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    private final class ToolbarXP
    extends JPanel {
        private static final int GRIP_WIDTH = 7;
        Dimension dim = new Dimension(7, 7);
        Dimension max = new Dimension(7, Integer.MAX_VALUE);

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = 3;
            for (int i = 4; i < this.getHeight() - 4; i += 4) {
                graphics.setColor(UIManager.getColor("controlLtHighlight"));
                graphics.fillRect(n + 1, i + 1, 2, 2);
                Color color = UIManager.getColor("controlShadow");
                graphics.setColor(color);
                graphics.drawLine(n + 1, i + 1, n + 1, i + 1);
                int n2 = color.getRed();
                int n3 = color.getGreen();
                int n4 = color.getBlue();
                Color color2 = this.getBackground();
                int n5 = color2.getRed();
                int n6 = color2.getGreen();
                int n7 = color2.getBlue();
                int n8 = (n5 - n2) / 5;
                int n9 = (n6 - n3) / 5;
                int n10 = (n7 - n4) / 5;
                color = new Color(n2 += n8, n3 += n9, n4 += n10);
                graphics.setColor(color);
                graphics.drawLine(n + 1, i, n + 1, i);
                color = new Color(n2 += n8, n3 += n9, n4 += n10);
                graphics.setColor(color);
                graphics.drawLine(n, i + 1, n, i + 1);
                color = new Color(n2 += n8, n3 += n9, n4 += n10);
                graphics.setColor(color);
                graphics.drawLine(n, i, n, i);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.dim;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(7, ToolbarContainer.this.toolbar.getHeight() - 4);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    private final class ToolbarAqua
    extends JPanel {
        private static final int GRIP_WIDTH = 8;
        Dimension dim;
        Dimension max;

        public ToolbarAqua() {
            super(new BorderLayout());
            JToolBar.Separator separator = new JToolBar.Separator();
            separator.setOrientation(1);
            separator.setForeground(UIManager.getColor("NbSplitPane.background"));
            this.add((Component)separator, "Center");
            this.dim = new Dimension(8, 8);
            this.max = new Dimension(8, Integer.MAX_VALUE);
            this.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        }

        @Override
        public Dimension getMinimumSize() {
            return this.dim;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    private final class ToolbarGtk
    extends JPanel {
        int TOPGAP;
        int BOTGAP;
        private static final int GRIP_WIDTH = 6;
        Dimension dim;
        Dimension max;

        public ToolbarGtk() {
            int n = 6;
            if (ToolbarContainer.useSynthIcon()) {
                this.TOPGAP = 0;
                this.BOTGAP = 0;
            } else {
                this.TOPGAP = 2;
                this.BOTGAP = 2;
            }
            this.dim = new Dimension(n, n);
            this.max = new Dimension(n, Integer.MAX_VALUE);
        }

        @Override
        public void paint(Graphics graphics) {
            if (ToolbarContainer.useSynthIcon()) {
                int n = ToolbarContainer.this.toolbar.getHeight() - this.BOTGAP;
                Icon icon = UIManager.getIcon("ToolBar.handleIcon");
                Region region = Region.TOOL_BAR;
                SynthStyleFactory synthStyleFactory = SynthLookAndFeel.getStyleFactory();
                SynthStyle synthStyle = synthStyleFactory.getStyle((JComponent)ToolbarContainer.this.toolbar, region);
                SynthContext synthContext = new SynthContext((JComponent)ToolbarContainer.this.toolbar, region, synthStyle, 1024);
                Method method = null;
                try {
                    method = synthIconClass.getMethod("getIconWidth", Icon.class, SynthContext.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    LOG.log(Level.WARNING, null, noSuchMethodException);
                }
                int n2 = 0;
                try {
                    n2 = (Integer)method.invoke(null, icon, synthContext);
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOG.log(Level.WARNING, null, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    LOG.log(Level.WARNING, null, invocationTargetException);
                }
                try {
                    method = synthIconClass.getMethod("paintIcon", Icon.class, SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    LOG.log(Level.WARNING, null, noSuchMethodException);
                }
                try {
                    method.invoke(null, icon, synthContext, graphics, new Integer(0), new Integer(-1), new Integer(n2), new Integer(n));
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOG.log(Level.WARNING, null, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    LOG.log(Level.WARNING, null, invocationTargetException);
                }
            } else {
                Dimension dimension = this.getSize();
                int n = dimension.height - this.BOTGAP;
                graphics.setColor(this.getBackground());
                int n3 = 0;
                while (n3 + 1 < dimension.width) {
                    int n4 = this.TOPGAP;
                    while (n4 + 1 < n) {
                        graphics.setColor(this.getBackground().brighter());
                        graphics.drawLine(n3, n4, n3, n4);
                        if (n3 + 5 < dimension.width && n4 + 5 < n) {
                            graphics.drawLine(n3 + 2, n4 + 2, n3 + 2, n4 + 2);
                        }
                        graphics.setColor(this.getBackground().darker().darker());
                        graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                        if (n3 + 5 < dimension.width && n4 + 5 < n) {
                            graphics.drawLine(n3 + 3, n4 + 3, n3 + 3, n4 + 3);
                        }
                        n4 += 4;
                    }
                    n3 += 4;
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.dim;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(6, ToolbarPool.getDefault().getPreferredIconSize());
        }

        @Override
        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    private final class ToolbarBump
    extends JPanel {
        static final int TOPGAP = 2;
        static final int BOTGAP = 2;
        private static final int GRIP_WIDTH = 6;
        Dimension dim;
        Dimension max;

        public ToolbarBump() {
            int n = 6;
            this.dim = new Dimension(n, n);
            this.max = new Dimension(n, Integer.MAX_VALUE);
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.height - 2;
            graphics.setColor(this.getBackground());
            int n2 = 0;
            while (n2 + 1 < dimension.width) {
                int n3 = 2;
                while (n3 + 1 < n) {
                    graphics.setColor(this.getBackground().brighter());
                    graphics.drawLine(n2, n3, n2, n3);
                    if (n2 + 5 < dimension.width && n3 + 5 < n) {
                        graphics.drawLine(n2 + 2, n3 + 2, n2 + 2, n3 + 2);
                    }
                    graphics.setColor(this.getBackground().darker().darker());
                    graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + 1);
                    if (n2 + 5 < dimension.width && n3 + 5 < n) {
                        graphics.drawLine(n2 + 3, n3 + 3, n2 + 3, n3 + 3);
                    }
                    n3 += 4;
                }
                n2 += 4;
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.dim;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.max;
        }
    }
}

