/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.HeaderComponent;
import org.netbeans.lib.profiler.ui.swing.ProfilerColumnModel;
import org.netbeans.lib.profiler.ui.swing.ProfilerRowSorter;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableActions;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableHover;
import org.netbeans.lib.profiler.ui.swing.renderer.Movable;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

public class ProfilerTable
extends JTable {
    public static final String PROP_NO_HOVER = "ProfilerTableHover_NoHover";
    private ScrollableRenderer _renderer;
    private boolean isCustomRendering;
    private int mainColumn = 0;
    private boolean shadeUnfocusedSelection = false;
    private boolean columnWidthsValid;
    private Set<Integer> scrollableColumns;
    private final boolean hideableColums;
    private Action defaultAction;

    public ProfilerTable(TableModel tableModel, boolean bl, boolean bl2, int[] nArray) {
        super(tableModel);
        this.hideableColums = bl2;
        this.setupModels(bl);
        this.setupAppearance();
        if (nArray != null && nArray.length > 0) {
            this.initScrollableColumns(nArray);
        }
    }

    protected void setupModels(boolean bl) {
        this.setAutoCreateRowSorter(false);
        if (bl) {
            this.setRowSorter(this.createRowSorter());
        }
    }

    protected void setupAppearance() {
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(true);
        this.setRowMargin(0);
        this.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        ProfilerTableActions.install(this);
        ProfilerTableHover.install(this);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilerTable.this.performDefaultAction();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    ProfilerTable.this.performDefaultAction();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ProfilerTable.this.focusGained();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ProfilerTable.this.focusLost();
            }
        });
    }

    private void focusGained() {
        this.repaint();
    }

    private void focusLost() {
        this.repaint();
    }

    public void setDefaultRenderer(Class<?> clazz, ProfilerRenderer profilerRenderer) {
        super.setDefaultRenderer(clazz, ProfilerTable.createCellRenderer(profilerRenderer));
    }

    public void setColumnRenderer(int n, ProfilerRenderer profilerRenderer) {
        int n2 = this.convertColumnIndexToModel(n);
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        tableColumn.setCellRenderer(ProfilerTable.createCellRenderer(profilerRenderer));
    }

    public static TableCellRenderer createCellRenderer(final ProfilerRenderer profilerRenderer) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                profilerRenderer.setValue(object, jTable.convertRowIndexToModel(n));
                return profilerRenderer.getComponent();
            }
        };
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        int n3;
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        boolean bl = this.isCellSelected(n, n2);
        if (bl && this.isEnabled()) {
            n3 = !this.shadeUnfocusedSelection || super.isFocusOwner() ? 1 : 0;
            component.setForeground(n3 != 0 ? this.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
            component.setBackground(n3 != 0 ? this.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
        } else if (!this.isEnabled()) {
            component.setForeground(UIManager.getColor("TextField.inactiveForeground"));
            component.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        } else {
            component.setForeground(this.getForeground());
            component.setBackground((n & 1) == 0 ? this.getBackground() : UIUtils.getDarker(this.getBackground()));
        }
        component.move(0, 0);
        n3 = this.convertColumnIndexToModel(n2);
        if (!this.isCustomRendering() && this.isScrollableColumn(n3)) {
            int n4 = this.getColumnPreferredWidth(n3);
            return this.getScrollableRenderer(component, n3, n4);
        }
        return component;
    }

    private ScrollableRenderer getScrollableRenderer(Component component, int n, int n2) {
        if (this._renderer == null) {
            this._renderer = new ScrollableRenderer();
        }
        this._renderer.setRenderer(component, this.getColumnOffset(n), n2);
        return this._renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Component getRenderer(TableCellRenderer tableCellRenderer, int n, int n2, boolean bl) {
        this.isCustomRendering = true;
        try {
            Object object;
            Component component = this.prepareRenderer(tableCellRenderer, n, n2);
            component.setSize(component.getPreferredSize().width, this.getRowHeight());
            if (bl) {
                component.setSize(component.getPreferredSize().width, this.getRowHeight());
                if (!ProfilerTable.isLeadingAlign(component)) {
                    object = this.getColumnModel();
                    int n3 = -component.getWidth();
                    int n4 = object.getColumn(n2).getWidth();
                    int n5 = this.convertColumnIndexToModel(n2);
                    n3 = this.isScrollableColumn(n5) ? (n3 += Math.max(n4, this.getColumnPreferredWidth(n5))) : (n3 += n4);
                    component.move(n3 - object.getColumnMargin(), 0);
                }
            }
            object = component;
            return object;
        }
        finally {
            this.isCustomRendering = false;
        }
    }

    @Override
    public boolean isFocusOwner() {
        return !this.isCustomRendering() && super.isFocusOwner();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setVisibleRows(int n) {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        dimension.height = n * this.getRowHeight();
        this.setPreferredScrollableViewportSize(dimension);
    }

    final boolean isCustomRendering() {
        return this.isCustomRendering;
    }

    public final void setMainColumn(int n) {
        this.mainColumn = n;
    }

    public final int getMainColumn() {
        return this.mainColumn;
    }

    public void selectRow(int n, boolean bl) {
        this.setRowSelectionInterval(n, n);
        if (bl) {
            this.scrollRectToVisible(this.getCellRect(n, this.getSelectedColumn(), true));
        }
    }

    public void selectColumn(int n, boolean bl) {
        this.setColumnSelectionInterval(n, n);
        if (bl) {
            this.scrollRectToVisible(this.getCellRect(this.getSelectedRow(), n, true));
        }
    }

    public void selectValue(Object object, int n, boolean bl) {
        if (object == null) {
            return;
        }
        int n2 = this.convertColumnIndexToView(n);
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!object.equals(this.getValueAt(i, n2))) continue;
            this.selectRow(i, bl);
            break;
        }
    }

    public Object getSelectedValue(int n) {
        int n2 = this.getSelectedRow();
        if (n2 == -1) {
            return null;
        }
        if (n2 >= this.getModel().getRowCount()) {
            return null;
        }
        return this.getValueAt(n2, this.convertColumnIndexToView(n));
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Object object = this.getSelectedValue(this.mainColumn);
        super.tableChanged(tableModelEvent);
        if (object != null) {
            this.selectValue(object, this.mainColumn, false);
        }
    }

    public final void setShadeUnfocusedSelection(boolean bl) {
        this.shadeUnfocusedSelection = bl;
    }

    public final boolean shadesUnfocusedSelection() {
        return this.shadeUnfocusedSelection;
    }

    ProfilerColumnModel _getColumnModel() {
        return (ProfilerColumnModel)this.getColumnModel();
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new ProfilerColumnModel();
    }

    public void setFitWidthColumn(int n) {
        this._getColumnModel().setFitWidthColumn(n);
    }

    public void setDefaultColumnWidth(int n) {
        this._getColumnModel().setDefaultColumnWidth(n);
    }

    public void setDefaultColumnWidth(int n, int n2) {
        this._getColumnModel().setDefaultColumnWidth(n, n2);
    }

    public void setColumnToolTips(String[] stringArray) {
        this._getColumnModel().setColumnToolTips(stringArray);
    }

    public void setColumnVisibility(int n, boolean bl) {
        ProfilerColumnModel profilerColumnModel = this._getColumnModel();
        TableColumn tableColumn = profilerColumnModel.getColumn(this.convertColumnIndexToView(n));
        profilerColumnModel.setColumnVisibility(tableColumn, bl, this);
    }

    public boolean isColumnVisible(int n) {
        int n2 = this.convertColumnIndexToView(n);
        return this._getColumnModel().isColumnVisible(n2);
    }

    public void setColumnOffset(int n, int n2) {
        if (this._getColumnModel().setColumnOffset(n, n2)) {
            n = this.convertColumnIndexToView(n);
            Rectangle rectangle = this.getCellRect(0, n, true);
            this.repaint(rectangle.x, 0, rectangle.width, this.getHeight());
        }
    }

    public Set<Integer> getScrollableColumns() {
        return this.scrollableColumns;
    }

    public boolean isScrollableColumn(int n) {
        return this.scrollableColumns != null && this.scrollableColumns.contains(n);
    }

    public int getColumnOffset(int n) {
        return this._getColumnModel().getColumnOffset(n);
    }

    private void updateColumnsPreferredWidth() {
        Rectangle rectangle = this.getVisibleRect();
        if (rectangle.isEmpty()) {
            return;
        }
        Point point = rectangle.getLocation();
        int n = this.rowAtPoint(rectangle.getLocation());
        point.translate(0, rectangle.height - 1);
        int n2 = this.rowAtPoint(point);
        ProfilerColumnModel profilerColumnModel = this._getColumnModel();
        for (int n3 : this.scrollableColumns) {
            int n4 = this.convertColumnIndexToView(n3);
            int n5 = this.computeColumnPreferredWidth(n3, n4, n, n2);
            profilerColumnModel.setColumnPreferredWidth(n3, n5);
        }
        this.columnWidthsValid = true;
    }

    public void updateColumnPreferredWidth(int n) {
        Rectangle rectangle = this.getVisibleRect();
        if (rectangle.isEmpty()) {
            return;
        }
        Point point = rectangle.getLocation();
        int n2 = this.rowAtPoint(rectangle.getLocation());
        point.translate(0, rectangle.height - 1);
        int n3 = this.rowAtPoint(point);
        int n4 = this.convertColumnIndexToView(n);
        int n5 = this.computeColumnPreferredWidth(n, n4, n2, n3);
        this._getColumnModel().setColumnPreferredWidth(n, n5);
    }

    protected int computeColumnPreferredWidth(int n, int n2, int n3, int n4) {
        int n5 = 0;
        for (int i = n3; i <= n4; ++i) {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(i, n2);
            Component component = this.getRenderer(tableCellRenderer, i, n2, false);
            n5 = Math.max(component.getPreferredSize().width, n5);
        }
        return n5;
    }

    public int getColumnPreferredWidth(int n) {
        if (!this.columnWidthsValid) {
            this.updateColumnsPreferredWidth();
        }
        return this._getColumnModel().getColumnPreferredWidth(n);
    }

    private void initScrollableColumns(int[] nArray) {
        this.scrollableColumns = new HashSet<Integer>(nArray.length);
        for (int n : nArray) {
            this.scrollableColumns.add(n);
        }
        this.columnWidthsValid = false;
        if (this.isSortable()) {
            this.getRowSorter().addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent rowSorterEvent) {
                    if (RowSorterEvent.Type.SORTED.equals((Object)rowSorterEvent.getType())) {
                        ProfilerTable.this.updateColumnsPreferredWidth();
                    }
                }
            });
        } else {
            this.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    ProfilerTable.this.updateColumnsPreferredWidth();
                }
            });
        }
    }

    boolean isLeadingAlign(int n) {
        if (this.getRowCount() == 0) {
            return true;
        }
        int n2 = this.convertColumnIndexToView(n);
        TableCellRenderer tableCellRenderer = this.getCellRenderer(0, n2);
        return ProfilerTable.isLeadingAlign(this.getRenderer(tableCellRenderer, 0, n2, false));
    }

    static boolean isLeadingAlign(Component component) {
        int n = component instanceof ProfilerRenderer ? ((ProfilerRenderer)((Object)component)).getHorizontalAlignment() : (component instanceof JLabel ? ((JLabel)component).getHorizontalAlignment() : 10);
        return n == 10 || n == 2;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        JScrollPane jScrollPane = this.getEnclosingScrollPane();
        if (jScrollPane != null) {
            boolean bl = this.hideableColums && !UIUtils.isAquaLookAndFeel();
            ActionListener actionListener = !bl ? null : new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProfilerTable.this.chooseColumns((Component)actionEvent.getSource(), null);
                }
            };
            HeaderComponent headerComponent = !bl ? new HeaderComponent(actionListener) : new HeaderComponent(actionListener){
                private Icon icon;
                {
                    this.icon = Icons.getIcon((String)"GeneralIcons.SortDescending");
                }

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    int n = (this.getWidth() - this.icon.getIconWidth()) / 2 - 1;
                    int n2 = (this.getHeight() - this.icon.getIconHeight()) / 2;
                    this.icon.paintIcon(this, graphics, n, n2);
                }
            };
            jScrollPane.setCorner("UPPER_RIGHT_CORNER", headerComponent);
            if (this.scrollableColumns != null && !this.scrollableColumns.isEmpty()) {
                jScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        if (!adjustmentEvent.getValueIsAdjusting()) {
                            ProfilerTable.this.updateColumnsPreferredWidth();
                        }
                    }
                });
            }
        }
    }

    private JScrollPane getEnclosingScrollPane() {
        Container container = SwingUtilities.getUnwrappedParent(this);
        if (!(container instanceof JViewport)) {
            return null;
        }
        Container container2 = ((JViewport)container).getParent();
        return container2 instanceof JScrollPane ? (JScrollPane)container2 : null;
    }

    private void chooseColumns(Component component, Point point) {
        final ProfilerColumnModel profilerColumnModel = this._getColumnModel();
        ArrayList<TableColumn> arrayList = Collections.list(profilerColumnModel.getColumns());
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (final TableColumn tableColumn : arrayList) {
            jPopupMenu.add(new JCheckBoxMenuItem(tableColumn.getHeaderValue().toString(), tableColumn.getWidth() > 0){
                {
                    super(string, bl);
                    this.setEnabled(tableColumn.getModelIndex() != 0);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    profilerColumnModel.setColumnVisibility(tableColumn, this.isSelected(), ProfilerTable.this);
                }
            });
        }
        if (point == null) {
            point = new Point(component.getSize().width - jPopupMenu.getPreferredSize().width - 1, component.getHeight() - 1);
        }
        jPopupMenu.show(component, point.x, point.y);
    }

    @Override
    public void doLayout() {
        boolean bl;
        JTableHeader jTableHeader;
        ProfilerColumnModel profilerColumnModel = this._getColumnModel();
        int n = profilerColumnModel.getFitWidthColumn();
        JTableHeader jTableHeader2 = jTableHeader = n != -1 ? this.getTableHeader() : null;
        boolean bl2 = jTableHeader == null ? false : (bl = jTableHeader.getResizingColumn() != null);
        if (bl || n == -1) {
            super.doLayout();
        } else {
            Enumeration<TableColumn> enumeration = profilerColumnModel.getColumns();
            TableColumn tableColumn = null;
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn2 = enumeration.nextElement();
                if (tableColumn2.getModelIndex() == n) {
                    if (!profilerColumnModel.isColumnVisible(tableColumn2)) {
                        super.doLayout();
                        return;
                    }
                    tableColumn = tableColumn2;
                    continue;
                }
                n2 += tableColumn2.getWidth();
            }
            if (tableColumn != null) {
                tableColumn.setWidth(this.getWidth() - n2);
            }
        }
    }

    boolean isSortable() {
        return this.getRowSorter() != null;
    }

    ProfilerRowSorter _getRowSorter() {
        return (ProfilerRowSorter)this.getRowSorter();
    }

    protected TableRowSorter createRowSorter() {
        ProfilerRowSorter profilerRowSorter = new ProfilerRowSorter(this.getModel());
        profilerRowSorter.setDefaultSortOrder(SortOrder.DESCENDING);
        profilerRowSorter.setDefaultSortOrder(0, SortOrder.ASCENDING);
        profilerRowSorter.setSortColumn(0);
        return profilerRowSorter;
    }

    public void disableColumnSorting(int n) {
        ProfilerRowSorter profilerRowSorter = this._getRowSorter();
        if (profilerRowSorter == null) {
            return;
        }
        int n2 = this.convertColumnIndexToView(n);
        profilerRowSorter.setSortable(n2, false);
    }

    public void setSortColumn(int n) {
        if (this.isSortable()) {
            this._getRowSorter().setSortColumn(n);
        }
    }

    public void setDefaultSortOrder(int n, SortOrder sortOrder) {
        if (this.isSortable()) {
            this._getRowSorter().setDefaultSortOrder(n, sortOrder);
        }
    }

    public void setDefaultAction(Action action) {
        this.defaultAction = action;
    }

    public void performDefaultAction() {
        if (this.defaultAction != null) {
            this.defaultAction.actionPerformed(null);
        }
    }

    public void loadColumns(Properties properties) {
        this._getColumnModel().loadFromStorage(properties, this);
        if (this.isSortable()) {
            this._getRowSorter().loadFromStorage(properties, this);
        }
    }

    public void saveColumns(Properties properties) {
        this._getColumnModel().saveToStorage(properties, this);
        if (this.isSortable()) {
            this._getRowSorter().saveToStorage(properties, this);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.columnAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    return null;
                }
                ProfilerColumnModel profilerColumnModel = ProfilerTable.this._getColumnModel();
                TableColumn tableColumn = profilerColumnModel.getColumn(n);
                String string = profilerColumnModel.getColumnToolTip(tableColumn.getModelIndex());
                return string;
            }

            @Override
            protected void processMouseEvent(MouseEvent mouseEvent) {
                if (ProfilerTable.this.hideableColums && UIUtils.isAquaLookAndFeel() && mouseEvent.isPopupTrigger()) {
                    ProfilerTable.this.chooseColumns((Component)mouseEvent.getSource(), mouseEvent.getPoint());
                }
                super.processMouseEvent(mouseEvent.getClickCount() > 1 ? ProfilerTable.this.clearClicks(mouseEvent) : mouseEvent);
            }
        };
    }

    private MouseEvent clearClicks(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), 1, mouseEvent.isPopupTrigger(), mouseEvent.getButton());
        return mouseEvent2;
    }

    private class ScrollableRenderer
    extends Component {
        private Component impl;
        private Movable implM;
        private int offset;
        private int prefWidth;
        private int marginOffset;

        private ScrollableRenderer() {
        }

        void setRenderer(Component component, int n, int n2) {
            this.impl = component;
            this.offset = n;
            this.prefWidth = n2;
            this.marginOffset = ProfilerTable.isLeadingAlign(this.impl) ? 0 : ProfilerTable.this.getColumnModel().getColumnMargin();
            this.implM = component instanceof Movable ? (Movable)((Object)component) : null;
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.prefWidth > n3) {
                this.offset += this.marginOffset;
            }
            this.impl.setSize(Math.max(n3, this.prefWidth), n4);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.impl.getPreferredSize();
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.implM != null) {
                this.implM.move(-this.offset, 0);
                this.impl.paint(graphics);
            } else {
                graphics.translate(-this.offset, 0);
                this.impl.paint(graphics);
            }
        }
    }
}

