/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import org.apache.ivy.core.cache.CacheResourceOptions;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.osgi.obr.xml.OBRXMLParser;
import org.apache.ivy.osgi.repo.AbstractOSGiResolver;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.xml.sax.SAXException;

public class OBRResolver
extends AbstractOSGiResolver {
    private String repoXmlURL;
    private String repoXmlFile;
    private Long metadataTtl;
    private Boolean forceMetadataUpdate;

    public void setRepoXmlFile(String string) {
        this.repoXmlFile = string;
    }

    public void setRepoXmlURL(String string) {
        this.repoXmlURL = string;
    }

    public void setMetadataTtl(Long l) {
        this.metadataTtl = l;
    }

    public void setForceMetadataUpdate(Boolean bl) {
        this.forceMetadataUpdate = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() {
        if (this.repoXmlFile != null && this.repoXmlURL != null) {
            throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: repoXmlFile and repoXmlUrl cannot be set both");
        }
        if (this.repoXmlFile != null) {
            File file = new File(this.repoXmlFile);
            this.loadRepoFromFile(file.getParentFile().toURI(), file, this.repoXmlFile);
        } else if (this.repoXmlURL != null) {
            ArtifactDownloadReport artifactDownloadReport;
            Object object;
            URL uRL;
            try {
                uRL = new URL(this.repoXmlURL);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: repoXmlURL '" + this.repoXmlURL + "' is not an URL");
            }
            EventManager eventManager = this.getEventManager();
            try {
                if (eventManager != null) {
                    this.getRepository().addTransferListener(eventManager);
                }
                object = new URLResource(uRL);
                CacheResourceOptions cacheResourceOptions = new CacheResourceOptions();
                if (this.metadataTtl != null) {
                    cacheResourceOptions.setTtl(this.metadataTtl);
                }
                if (this.forceMetadataUpdate != null) {
                    cacheResourceOptions.setForce(this.forceMetadataUpdate);
                }
                artifactDownloadReport = this.getRepositoryCacheManager().downloadRepositoryResource((Resource)object, "obr", "obr", "xml", cacheResourceOptions, this.getRepository());
            }
            finally {
                if (eventManager != null) {
                    this.getRepository().removeTransferListener(eventManager);
                }
            }
            try {
                object = new URI(this.repoXmlURL);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException("illegal uri");
            }
            this.loadRepoFromFile((URI)object, artifactDownloadReport.getLocalFile(), this.repoXmlURL);
        } else {
            throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: repoXmlFile or repoXmlUrl is missing");
        }
    }

    private void loadRepoFromFile(URI uRI, File file, String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: the file " + string + " was not found");
        }
        try {
            this.setRepoDescriptor(OBRXMLParser.parse(uRI, fileInputStream));
        }
        catch (ParseException parseException) {
            throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: the file " + string + " is incorrectly formed (" + parseException.getMessage() + ")");
        }
        catch (IOException iOException) {
            throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: the file " + string + " could not be read (" + iOException.getMessage() + ")");
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("The OBR repository resolver " + this.getName() + " couldn't be configured: the file " + string + " has incorrect XML (" + sAXException.getMessage() + ")");
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

