/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyThread;
import org.jruby.ext.fiber.ThreadFiber;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ThreadService {
    private final Ruby runtime;
    private ThreadContext mainContext;
    private final ThreadLocal<SoftReference<ThreadContext>> localContext;
    private ThreadGroup rubyThreadGroup;
    private final Map<Object, RubyThread> rubyThreadMap;
    private final ReentrantLock criticalLock = new ReentrantLock();

    public ThreadService(Ruby runtime) {
        this.runtime = runtime;
        this.localContext = new ThreadLocal();
        try {
            this.rubyThreadGroup = new ThreadGroup("Ruby Threads#" + runtime.hashCode());
        }
        catch (SecurityException e) {
            this.rubyThreadGroup = Thread.currentThread().getThreadGroup();
        }
        this.rubyThreadMap = Collections.synchronizedMap(new WeakHashMap());
    }

    public void disposeCurrentThread() {
        this.localContext.set(null);
        this.rubyThreadMap.remove(Thread.currentThread());
    }

    public void initMainThread() {
        this.mainContext = ThreadContext.newContext(this.runtime);
        this.localContext.set(new SoftReference<ThreadContext>(this.mainContext));
    }

    public final ThreadContext getCurrentContext() {
        ThreadContext context = null;
        while (context == null) {
            SoftReference<ThreadContext> ref = this.localContext.get();
            if (ref == null) {
                ref = this.adoptCurrentThread();
                context = ref.get();
            } else {
                context = ref.get();
            }
            if (context != null) continue;
            this.localContext.set(null);
        }
        return context;
    }

    private SoftReference<ThreadContext> adoptCurrentThread() {
        Thread current2 = Thread.currentThread();
        RubyThread.adopt(this.runtime.getThread(), current2);
        return this.localContext.get();
    }

    public RubyThread getMainThread() {
        return this.mainContext.getThread();
    }

    public void setMainThread(Thread thread2, RubyThread rubyThread) {
        this.mainContext.setThread(rubyThread);
        this.rubyThreadMap.put(thread2, rubyThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RubyThread[] getActiveRubyThreads() {
        Map<Object, RubyThread> map2 = this.rubyThreadMap;
        synchronized (map2) {
            ArrayList<RubyThread> rtList = new ArrayList<RubyThread>(this.rubyThreadMap.size());
            for (Map.Entry<Object, RubyThread> entry : this.rubyThreadMap.entrySet()) {
                Future f;
                Thread t;
                Object key2 = entry.getKey();
                if (key2 == null || (key2 instanceof Thread ? !(t = (Thread)key2).isAlive() : key2 instanceof Future && ((f = (Future)key2).isDone() || f.isCancelled()))) continue;
                rtList.add(entry.getValue());
            }
            return rtList.toArray(new RubyThread[rtList.size()]);
        }
    }

    public synchronized ThreadContext registerNewThread(RubyThread thread2) {
        ThreadContext context = ThreadContext.newContext(this.runtime);
        this.localContext.set(new SoftReference<ThreadContext>(context));
        context.setThread(thread2);
        ThreadFiber.initRootFiber(context);
        return context;
    }

    public synchronized void associateThread(Object threadOrFuture, RubyThread rubyThread) {
        this.rubyThreadMap.put(threadOrFuture, rubyThread);
    }

    public synchronized void unregisterThread(RubyThread thread2) {
        this.rubyThreadMap.remove(Thread.currentThread());
        this.getCurrentContext().setThread(null);
        this.localContext.set(null);
    }

    public void setCritical(boolean critical) {
        if (critical && !this.criticalLock.isHeldByCurrentThread()) {
            this.acquireCritical();
        } else if (!critical && this.criticalLock.isHeldByCurrentThread()) {
            this.releaseCritical();
        }
    }

    private void acquireCritical() {
        this.criticalLock.lock();
    }

    private void releaseCritical() {
        this.criticalLock.unlock();
    }

    public boolean getCritical() {
        return this.criticalLock.isHeldByCurrentThread();
    }

    @Deprecated
    public Map<Object, RubyThread> getRubyThreadMap() {
        return this.rubyThreadMap;
    }

    @Deprecated
    public void deliverEvent(RubyThread sender, RubyThread target, Event event2) {
    }

    @Deprecated
    public ThreadGroup getRubyThreadGroup() {
        return this.rubyThreadGroup;
    }

    @Deprecated
    public ThreadContext getThreadContextForThread(RubyThread thread2) {
        return thread2.getContext();
    }

    @Deprecated
    public synchronized void dissociateThread(Object threadOrFuture) {
        this.rubyThreadMap.remove(threadOrFuture);
    }

    @Deprecated
    public final void setCurrentContext(ThreadContext context) {
        this.localContext.set(new SoftReference<ThreadContext>(context));
    }

    @Deprecated
    public boolean getPolling() {
        return this.rubyThreadMap.size() > 1;
    }

    @Deprecated
    public static class Event {
        public final String description;
        public final Type type;
        public final IRubyObject exception;

        public Event(String description, Type type2) {
            this(description, type2, null);
        }

        public Event(String description, Type type2, IRubyObject exception2) {
            this.description = description;
            this.type = type2;
            this.exception = exception2;
        }

        public String toString() {
            switch (this.type) {
                case KILL: {
                    return this.description;
                }
                case RAISE: {
                    return this.description + ": " + this.exception.getMetaClass().getRealClass();
                }
                case WAKEUP: {
                    return this.description;
                }
            }
            return "";
        }

        @Deprecated
        public static Event kill(RubyThread sender, RubyThread target, Type type2) {
            return new Event(sender.toString() + " sent KILL to " + target, type2);
        }

        @Deprecated
        public static Event raise(RubyThread sender, RubyThread target, Type type2, IRubyObject exception2) {
            return new Event(sender.toString() + " sent KILL to " + target, type2, exception2);
        }

        @Deprecated
        public static Event wakeup(RubyThread sender, RubyThread target, Type type2) {
            return new Event(sender.toString() + " sent KILL to " + target, type2);
        }

        public static enum Type {
            KILL,
            RAISE,
            WAKEUP;

        }
    }
}

