/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.MergeFunction;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public abstract class MergingLexerAdapterBase
extends DelegateLexer {
    private IElementType myTokenType;
    private int myState;
    private int myTokenStart;

    public MergingLexerAdapterBase(Lexer original) {
        super(original);
    }

    public abstract MergeFunction getMergeFunction();

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            MergingLexerAdapterBase.$$$reportNull$$$0(0);
        }
        super.start(buffer, startOffset, endOffset, initialState);
        this.myTokenType = null;
        this.myState = 0;
        this.myTokenStart = 0;
    }

    @Override
    public int getState() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myState;
    }

    @Override
    public IElementType getTokenType() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenType;
    }

    @Override
    public int getTokenStart() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenStart;
    }

    @Override
    public int getTokenEnd() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return super.getTokenStart();
    }

    @Override
    public void advance() {
        this.myTokenType = null;
        this.myState = 0;
        this.myTokenStart = 0;
    }

    private void locateToken() {
        if (this.myTokenType == null) {
            Lexer orig = this.getDelegate();
            this.myTokenType = orig.getTokenType();
            this.myTokenStart = orig.getTokenStart();
            this.myState = orig.getState();
            if (this.myTokenType == null) {
                return;
            }
            orig.advance();
            this.myTokenType = this.getMergeFunction().merge(this.myTokenType, orig);
        }
    }

    public Lexer getOriginal() {
        return this.getDelegate();
    }

    @Override
    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            MergingLexerAdapterBase.$$$reportNull$$$0(1);
        }
        MyLexerPosition pos = (MyLexerPosition)position;
        this.getDelegate().restore(pos.getOriginalPosition());
        this.myTokenType = pos.getType();
        this.myTokenStart = pos.getOffset();
        this.myState = pos.getOldState();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getDelegate() + "]";
    }

    @Override
    @NotNull
    public LexerPosition getCurrentPosition() {
        MyLexerPosition myLexerPosition = new MyLexerPosition(this.myTokenStart, this.myTokenType, this.getDelegate().getCurrentPosition(), this.myState);
        if (myLexerPosition == null) {
            MergingLexerAdapterBase.$$$reportNull$$$0(2);
        }
        return myLexerPosition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lexer/MergingLexerAdapterBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lexer/MergingLexerAdapterBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLexerPosition
    implements LexerPosition {
        private final int myOffset;
        private final IElementType myTokenType;
        private final LexerPosition myOriginalPosition;
        private final int myOldState;

        public MyLexerPosition(int offset, IElementType tokenType, LexerPosition originalPosition, int oldState) {
            this.myOffset = offset;
            this.myTokenType = tokenType;
            this.myOriginalPosition = originalPosition;
            this.myOldState = oldState;
        }

        @Override
        public int getOffset() {
            return this.myOffset;
        }

        @Override
        public int getState() {
            return this.myOriginalPosition.getState();
        }

        public IElementType getType() {
            return this.myTokenType;
        }

        public LexerPosition getOriginalPosition() {
            return this.myOriginalPosition;
        }

        public int getOldState() {
            return this.myOldState;
        }
    }
}

