/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Editor
extends UserDataHolder {
    public static final Editor[] EMPTY_ARRAY = new Editor[0];

    @NotNull
    public Document getDocument();

    public boolean isViewer();

    @NotNull
    public JComponent getComponent();

    @NotNull
    public JComponent getContentComponent();

    public void setBorder(@Nullable Border var1);

    public Insets getInsets();

    @NotNull
    public SelectionModel getSelectionModel();

    @NotNull
    public MarkupModel getMarkupModel();

    @NotNull
    public FoldingModel getFoldingModel();

    @NotNull
    public ScrollingModel getScrollingModel();

    @NotNull
    public CaretModel getCaretModel();

    @NotNull
    public SoftWrapModel getSoftWrapModel();

    @NotNull
    public EditorSettings getSettings();

    @NotNull
    public EditorColorsScheme getColorsScheme();

    public int getLineHeight();

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition var1);

    public int logicalPositionToOffset(@NotNull LogicalPosition var1);

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition var1);

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition var1);

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition var1);

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition var1);

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int var1);

    @NotNull
    public VisualPosition offsetToVisualPosition(int var1);

    @NotNull
    public VisualPosition offsetToVisualPosition(int var1, boolean var2, boolean var3);

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point var1);

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point var1);

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D var1);

    @NotNull
    default public Point offsetToXY(int offset) {
        Point point = this.offsetToXY(offset, false, false);
        if (point == null) {
            Editor.$$$reportNull$$$0(0);
        }
        return point;
    }

    @NotNull
    default public Point offsetToXY(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.offsetToVisualPosition(offset, leanForward, beforeSoftWrap);
        Point point = this.visualPositionToXY(visualPosition);
        if (point == null) {
            Editor.$$$reportNull$$$0(1);
        }
        return point;
    }

    @NotNull
    default public Point2D offsetToPoint2D(int offset) {
        Point2D point2D = this.offsetToPoint2D(offset, false, false);
        if (point2D == null) {
            Editor.$$$reportNull$$$0(2);
        }
        return point2D;
    }

    @NotNull
    default public Point2D offsetToPoint2D(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.offsetToVisualPosition(offset, leanForward, beforeSoftWrap);
        Point2D point2D = this.visualPositionToPoint2D(visualPosition);
        if (point2D == null) {
            Editor.$$$reportNull$$$0(3);
        }
        return point2D;
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener var1);

    public void removeEditorMouseListener(@NotNull EditorMouseListener var1);

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener var1);

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener var1);

    public boolean isDisposed();

    @Nullable
    public Project getProject();

    public boolean isInsertMode();

    public boolean isColumnMode();

    public boolean isOneLineMode();

    @NotNull
    public EditorGutter getGutter();

    @Nullable
    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent var1);

    public void setHeaderComponent(@Nullable JComponent var1);

    public boolean hasHeaderComponent();

    @Nullable
    public JComponent getHeaderComponent();

    @NotNull
    public IndentsModel getIndentsModel();

    @NotNull
    public InlayModel getInlayModel();

    @NotNull
    public EditorKind getEditorKind();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/editor/Editor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToXY";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToPoint2D";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

