/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class IntegrationKey {
    @NotNull
    private final String myIdeProjectName;
    @NotNull
    private final String myIdeProjectLocationHash;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final String myExternalProjectConfigPath;

    public IntegrationKey(@NotNull Project ideProject, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectConfigPath) {
        if (ideProject == null) {
            IntegrationKey.$$$reportNull$$$0(0);
        }
        if (externalSystemId == null) {
            IntegrationKey.$$$reportNull$$$0(1);
        }
        if (externalProjectConfigPath == null) {
            IntegrationKey.$$$reportNull$$$0(2);
        }
        this(ideProject.getName(), ideProject.getLocationHash(), externalSystemId, externalProjectConfigPath);
    }

    public IntegrationKey(@NotNull String ideProjectName, @NotNull String ideProjectLocationHash, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectConfigPath) {
        if (ideProjectName == null) {
            IntegrationKey.$$$reportNull$$$0(3);
        }
        if (ideProjectLocationHash == null) {
            IntegrationKey.$$$reportNull$$$0(4);
        }
        if (externalSystemId == null) {
            IntegrationKey.$$$reportNull$$$0(5);
        }
        if (externalProjectConfigPath == null) {
            IntegrationKey.$$$reportNull$$$0(6);
        }
        this.myIdeProjectName = ideProjectName;
        this.myIdeProjectLocationHash = ideProjectLocationHash;
        this.myExternalSystemId = externalSystemId;
        this.myExternalProjectConfigPath = externalProjectConfigPath;
    }

    @NotNull
    public String getIdeProjectName() {
        String string = this.myIdeProjectName;
        if (string == null) {
            IntegrationKey.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getIdeProjectLocationHash() {
        String string = this.myIdeProjectLocationHash;
        if (string == null) {
            IntegrationKey.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            IntegrationKey.$$$reportNull$$$0(9);
        }
        return projectSystemId;
    }

    @NotNull
    public String getExternalProjectConfigPath() {
        String string = this.myExternalProjectConfigPath;
        if (string == null) {
            IntegrationKey.$$$reportNull$$$0(10);
        }
        return string;
    }

    public int hashCode() {
        int result = this.myIdeProjectName.hashCode();
        result = 31 * result + this.myIdeProjectLocationHash.hashCode();
        result = 31 * result + this.myExternalSystemId.hashCode();
        result = 31 * result + this.myExternalProjectConfigPath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationKey key = (IntegrationKey)o;
        if (!this.myExternalSystemId.equals(key.myExternalSystemId)) {
            return false;
        }
        if (!this.myIdeProjectLocationHash.equals(key.myIdeProjectLocationHash)) {
            return false;
        }
        if (!this.myIdeProjectName.equals(key.myIdeProjectName)) {
            return false;
        }
        return this.myExternalProjectConfigPath.equals(key.myExternalProjectConfigPath);
    }

    public String toString() {
        return String.format("%s project '%s'", this.myExternalSystemId.toString().toLowerCase(), this.myIdeProjectName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectConfigPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProjectName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProjectLocationHash";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/util/IntegrationKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/util/IntegrationKey";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeProjectName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeProjectLocationHash";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectConfigPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

