/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class OnOffButton
extends JToggleButton {
    private String myOnText = "ON";
    private String myOffText = "OFF";

    public OnOffButton() {
        this.setBorder(null);
        this.setOpaque(false);
    }

    public String getOnText() {
        return this.myOnText;
    }

    public void setOnText(String onText) {
        this.myOnText = onText;
    }

    public String getOffText() {
        return this.myOffText;
    }

    public void setOffText(String offText) {
        this.myOffText = offText;
    }

    @Override
    public String getUIClassID() {
        return "OnOffButtonUI";
    }

    @Override
    public void updateUI() {
        Object uiClassName = UIManager.get(this.getUIClassID());
        this.setUI(uiClassName == null ? DefaultOnOffButtonUI.createUI(this) : UIManager.getUI(this));
    }

    private static class DefaultOnOffButtonUI
    extends BasicToggleButtonUI {
        private DefaultOnOffButtonUI() {
        }

        public static ComponentUI createUI(JComponent c) {
            c.setAlignmentY(0.5f);
            return new DefaultOnOffButtonUI();
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            int vGap = JBUI.scale((int)4);
            OnOffButton button = (OnOffButton)c;
            String text = button.getOffText().length() > button.getOnText().length() ? button.getOffText() : button.getOnText();
            text = text.toUpperCase(Locale.getDefault());
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int w = fm.stringWidth(text);
            int h = fm.getHeight();
            return new Dimension(w += 3 * (h += 2 * vGap) / 2, h);
        }

        @Override
        public void paint(Graphics gr, JComponent c) {
            if (!(c instanceof OnOffButton)) {
                return;
            }
            int toggleArc = JBUI.scale((int)3);
            int buttonArc = JBUI.scale((int)5);
            int vGap = JBUI.scale((int)4);
            int hGap = JBUI.scale((int)3);
            int border = 1;
            OnOffButton button = (OnOffButton)c;
            Dimension size = button.getSize();
            int w = size.width - 2 * vGap;
            int h = size.height - 2 * hGap;
            if (h % 2 == 1) {
                --h;
            }
            Graphics2D g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int xOff = (button.getWidth() - w) / 2;
            int yOff = (button.getHeight() - h) / 2;
            g.translate(xOff, yOff);
            if (button.isSelected()) {
                g.setColor((Color)new JBColor(new Color(74, 146, 73), new Color(77, 105, 76)));
                g.fillRoundRect(0, 0, w, h, buttonArc, buttonArc);
                g.setColor((Color)new JBColor((Color)Gray._192, (Color)Gray._80));
                g.drawRoundRect(0, 0, w, h, buttonArc, buttonArc);
                g.setColor((Color)new JBColor((Color)Gray._200, (Color)Gray._100));
                g.fillRoundRect(w - h, border, h, h - border, toggleArc, toggleArc);
                g.setColor(UIUtil.getListForeground((boolean)true));
                g.drawString(button.getOnText(), h / 2, h - vGap);
            } else {
                g.setColor(UIUtil.getPanelBackground());
                g.fillRoundRect(0, 0, w, h, buttonArc, buttonArc);
                g.setColor((Color)new JBColor((Color)Gray._192, (Color)Gray._100));
                g.drawRoundRect(0, 0, w, h, buttonArc, buttonArc);
                g.setColor(UIUtil.getLabelDisabledForeground());
                g.drawString(button.getOffText(), h + vGap, h - vGap);
                g.setColor(JBColor.border());
                g.setPaint(new GradientPaint(h, 0.0f, (Color)new JBColor((Color)Gray._158, (Color)Gray._100), 0.0f, h, (Color)new JBColor((Color)Gray._210, (Color)Gray._100)));
                g.fillRoundRect(0, 0, h, h, toggleArc, toggleArc);
            }
            g.translate(-xOff, -yOff);
        }

        @Override
        public Dimension getMinimumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        @Override
        public Dimension getMaximumSize(JComponent c) {
            return this.getPreferredSize(c);
        }
    }
}

