/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.CollectionListModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FilteringListModel<T>
extends AbstractListModel {
    private final ListModel myOriginalModel;
    private final List<T> myData = new ArrayList<T>();
    private Condition<T> myCondition = null;
    private final ListDataListener myListDataListener = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent e) {
            FilteringListModel.this.refilter();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            FilteringListModel.this.refilter();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            FilteringListModel.this.refilter();
        }
    };

    public FilteringListModel(ListModel originalModel) {
        this.myOriginalModel = originalModel;
        this.myOriginalModel.addListDataListener(this.myListDataListener);
    }

    protected FilteringListModel(JList list) {
        this(list.getModel());
        list.setModel(this);
    }

    public void dispose() {
        this.myOriginalModel.removeListDataListener(this.myListDataListener);
    }

    public void setFilter(Condition<T> condition2) {
        this.myCondition = condition2;
        this.refilter();
    }

    private void removeAllElements() {
        int index1 = this.myData.size() - 1;
        if (index1 >= 0) {
            this.myData.clear();
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public void refilter() {
        this.removeAllElements();
        int count = 0;
        for (int i = 0; i < this.myOriginalModel.getSize(); ++i) {
            Object elt = this.myOriginalModel.getElementAt(i);
            if (!this.passElement(elt)) continue;
            this.addToFiltered(elt);
            ++count;
        }
        if (count > 0) {
            this.fireIntervalAdded(this, 0, count - 1);
        }
    }

    protected void addToFiltered(T elt) {
        this.myData.add(elt);
    }

    @Override
    public int getSize() {
        return this.myData.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.myData.get(index);
    }

    public int getElementIndex(T element) {
        return this.myData.indexOf(element);
    }

    private boolean passElement(T element) {
        return this.myCondition == null || this.myCondition.value(element);
    }

    public boolean contains(T value) {
        return this.myData.contains(value);
    }

    public ListModel getOriginalModel() {
        return this.myOriginalModel;
    }

    public void addAll(List elements) {
        this.myData.addAll(elements);
        ((CollectionListModel)this.myOriginalModel).add(elements);
    }

    public void replaceAll(List elements) {
        this.myData.clear();
        this.myData.addAll(elements);
        ((CollectionListModel)this.myOriginalModel).replaceAll(elements);
    }

    public void remove(int index) {
        ((DefaultListModel)this.myOriginalModel).removeElement(this.myData.get(index));
    }
}

