/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.ClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBViewport;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StatusText {
    public static final SimpleTextAttributes DEFAULT_ATTRIBUTES = SimpleTextAttributes.GRAYED_ATTRIBUTES;
    public static final String DEFAULT_EMPTY_TEXT = UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]);
    private static final int Y_GAP = JBUI.scale((int)2);
    @Nullable
    private Component myOwner;
    private Component myMouseTarget;
    @NotNull
    private final MouseMotionListener myMouseMotionListener;
    @NotNull
    private final ClickListener myClickListener;
    private boolean myIsDefaultText;
    private String myText = "";
    @NotNull
    protected final SimpleColoredComponent myComponent = new SimpleColoredComponent();
    @NotNull
    private final SimpleColoredComponent mySecondaryComponent = new SimpleColoredComponent();
    private final List<ActionListener> myClickListeners = new ArrayList<ActionListener>();
    private final List<ActionListener> mySecondaryListeners = new ArrayList<ActionListener>();
    private boolean myHasActiveClickListeners;
    private boolean myShowAboveCenter = true;

    protected StatusText(JComponent owner) {
        this();
        this.attachTo(owner);
    }

    public StatusText() {
        this.myClickListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                ActionListener actionListener;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getButton() == 1 && clickCount == 1 && (actionListener = StatusText.this.findActionListenerAt(e.getPoint())) != null) {
                    actionListener.actionPerformed(new ActionEvent((Object)this, 0, ""));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/StatusText$1", "onClick"));
            }
        };
        this.myMouseMotionListener = new MouseAdapter(){
            private Cursor myOriginalCursor;

            @Override
            public void mouseMoved(MouseEvent e) {
                if (StatusText.this.isStatusVisible()) {
                    if (StatusText.this.findActionListenerAt(e.getPoint()) != null) {
                        if (this.myOriginalCursor == null) {
                            this.myOriginalCursor = StatusText.this.myMouseTarget.getCursor();
                            StatusText.this.myMouseTarget.setCursor(Cursor.getPredefinedCursor(12));
                        }
                    } else if (this.myOriginalCursor != null) {
                        StatusText.this.myMouseTarget.setCursor(this.myOriginalCursor);
                        this.myOriginalCursor = null;
                    }
                }
            }
        };
        this.myComponent.setOpaque(false);
        this.myComponent.setFont(UIUtil.getLabelFont());
        this.setText(DEFAULT_EMPTY_TEXT, DEFAULT_ATTRIBUTES);
        this.myIsDefaultText = true;
        this.mySecondaryComponent.setOpaque(false);
        this.mySecondaryComponent.setFont(UIUtil.getLabelFont());
    }

    public void attachTo(@Nullable Component owner) {
        this.attachTo(owner, owner);
    }

    public void attachTo(@Nullable Component owner, @Nullable Component mouseTarget) {
        if (this.myMouseTarget != null) {
            this.myClickListener.uninstall(this.myMouseTarget);
            this.myMouseTarget.removeMouseMotionListener(this.myMouseMotionListener);
        }
        this.myOwner = owner;
        this.myMouseTarget = mouseTarget;
        if (this.myMouseTarget != null) {
            this.myClickListener.installOn(this.myMouseTarget);
            this.myMouseTarget.addMouseMotionListener(this.myMouseMotionListener);
        }
    }

    protected abstract boolean isStatusVisible();

    @Nullable
    private ActionListener findActionListenerAt(int xCoord, int yCoord) {
        if (this.myComponent.getPreferredSize().height >= yCoord) {
            return StatusText.findListener(this.myComponent, this.myClickListeners, xCoord);
        }
        return StatusText.findListener(this.mySecondaryComponent, this.mySecondaryListeners, xCoord);
    }

    @Nullable
    private static ActionListener findListener(@NotNull SimpleColoredComponent component, @NotNull List<ActionListener> listeners, int xCoord) {
        int index;
        if (component == null) {
            StatusText.$$$reportNull$$$0(0);
        }
        if (listeners == null) {
            StatusText.$$$reportNull$$$0(1);
        }
        if ((index = component.findFragmentAt(xCoord)) >= 0 && index < listeners.size()) {
            return listeners.get(index);
        }
        return null;
    }

    @Nullable
    private ActionListener findActionListenerAt(Point point) {
        if (!this.myHasActiveClickListeners || !this.isStatusVisible()) {
            return null;
        }
        point = SwingUtilities.convertPoint(this.myMouseTarget, point, this.myOwner);
        Rectangle b = this.getTextComponentBound();
        if (b.contains(point)) {
            return this.findActionListenerAt(point.x - b.x, point.y - b.y);
        }
        return null;
    }

    protected Rectangle getTextComponentBound() {
        Rectangle ownerRec = this.myOwner == null ? new Rectangle(0, 0, 0, 0) : this.myOwner.getBounds();
        Dimension size = this.getPreferredSize();
        int x = (ownerRec.width - size.width) / 2;
        int y = (ownerRec.height - size.height) / (this.myShowAboveCenter ? 3 : 2);
        return new Rectangle(x, y, size.width, size.height);
    }

    public final boolean isShowAboveCenter() {
        return this.myShowAboveCenter;
    }

    public final StatusText setShowAboveCenter(boolean showAboveCenter) {
        this.myShowAboveCenter = showAboveCenter;
        return this;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            StatusText.$$$reportNull$$$0(2);
        }
        return string;
    }

    public StatusText setText(String text) {
        return this.setText(text, DEFAULT_ATTRIBUTES);
    }

    public StatusText setText(String text, SimpleTextAttributes attrs) {
        return this.clear().appendText(text, attrs);
    }

    public StatusText clear() {
        this.myText = "";
        this.myComponent.clear();
        this.myClickListeners.clear();
        this.mySecondaryComponent.clear();
        this.mySecondaryListeners.clear();
        this.myHasActiveClickListeners = false;
        this.repaintOwner();
        return this;
    }

    private void repaintOwner() {
        if (this.myOwner != null && this.isStatusVisible()) {
            this.myOwner.repaint();
        }
    }

    public StatusText appendText(String text) {
        return this.appendText(text, DEFAULT_ATTRIBUTES);
    }

    public StatusText appendText(String text, SimpleTextAttributes attrs) {
        return this.appendText(text, attrs, null);
    }

    public StatusText appendText(String text, SimpleTextAttributes attrs, ActionListener listener) {
        if (this.myIsDefaultText) {
            this.clear();
            this.myIsDefaultText = false;
        }
        this.myText = this.myText + text;
        this.myComponent.append(text, attrs);
        this.myClickListeners.add(listener);
        if (listener != null) {
            this.myHasActiveClickListeners = true;
        }
        this.repaintOwner();
        return this;
    }

    public StatusText appendSecondaryText(String text, SimpleTextAttributes attrs, ActionListener listener) {
        this.mySecondaryComponent.append(text, attrs);
        this.mySecondaryListeners.add(listener);
        if (listener != null) {
            this.myHasActiveClickListeners = true;
        }
        this.repaintOwner();
        return this;
    }

    public void paint(Component owner, Graphics g) {
        if (!this.isStatusVisible()) {
            return;
        }
        if (owner == this.myOwner) {
            this.doPaintStatusText(g, this.getTextComponentBound());
        } else {
            this.paintOnComponentUnderViewport(owner, g);
        }
    }

    private void paintOnComponentUnderViewport(Component component, Graphics g) {
        JBViewport viewport = (JBViewport)ObjectUtils.tryCast((Object)this.myOwner, JBViewport.class);
        if (viewport == null || viewport.getView() != component || viewport.isPaintingNow()) {
            return;
        }
        Rectangle textBoundsInViewport = this.getTextComponentBound();
        int xInOwner = textBoundsInViewport.x - component.getX();
        int yInOwner = textBoundsInViewport.y - component.getY();
        Rectangle textBoundsInOwner = new Rectangle(xInOwner, yInOwner, textBoundsInViewport.width, textBoundsInViewport.height);
        this.doPaintStatusText(g, textBoundsInOwner);
        viewport.repaint(textBoundsInViewport);
    }

    private void doPaintStatusText(@NotNull Graphics g, @NotNull Rectangle bounds) {
        if (g == null) {
            StatusText.$$$reportNull$$$0(3);
        }
        if (bounds == null) {
            StatusText.$$$reportNull$$$0(4);
        }
        if (!this.hasSecondaryText()) {
            StatusText.paintComponentInBounds(this.myComponent, g, bounds);
        } else {
            Rectangle primaryBounds = StatusText.adjustComponentBounds(this.myComponent, bounds);
            Rectangle secondaryBounds = StatusText.adjustComponentBounds(this.mySecondaryComponent, bounds);
            secondaryBounds.y += primaryBounds.height + Y_GAP;
            StatusText.paintComponentInBounds(this.myComponent, g, primaryBounds);
            StatusText.paintComponentInBounds(this.mySecondaryComponent, g, secondaryBounds);
        }
    }

    @NotNull
    private static Rectangle adjustComponentBounds(@NotNull JComponent component, @NotNull Rectangle bounds) {
        if (component == null) {
            StatusText.$$$reportNull$$$0(5);
        }
        if (bounds == null) {
            StatusText.$$$reportNull$$$0(6);
        }
        Dimension size = component.getPreferredSize();
        Rectangle rectangle = new Rectangle(bounds.x + (bounds.width - size.width) / 2, bounds.y, size.width, size.height);
        if (rectangle == null) {
            StatusText.$$$reportNull$$$0(7);
        }
        return rectangle;
    }

    private boolean hasSecondaryText() {
        return this.mySecondaryComponent.getCharSequence(false).length() > 0;
    }

    private static void paintComponentInBounds(@NotNull SimpleColoredComponent component, @NotNull Graphics g, @NotNull Rectangle bounds) {
        if (component == null) {
            StatusText.$$$reportNull$$$0(8);
        }
        if (g == null) {
            StatusText.$$$reportNull$$$0(9);
        }
        if (bounds == null) {
            StatusText.$$$reportNull$$$0(10);
        }
        Graphics2D g2 = (Graphics2D)g.create(bounds.x, bounds.y, bounds.width, bounds.height);
        component.setBounds(0, 0, bounds.width, bounds.height);
        component.paint(g2);
        g2.dispose();
    }

    @NotNull
    public SimpleColoredComponent getComponent() {
        SimpleColoredComponent simpleColoredComponent = this.myComponent;
        if (simpleColoredComponent == null) {
            StatusText.$$$reportNull$$$0(11);
        }
        return simpleColoredComponent;
    }

    public Dimension getPreferredSize() {
        Dimension componentSize = this.myComponent.getPreferredSize();
        if (!this.hasSecondaryText()) {
            return componentSize;
        }
        Dimension secondaryComponentSize = this.mySecondaryComponent.getPreferredSize();
        return new Dimension(Math.max(componentSize.width, secondaryComponentSize.width), componentSize.height + secondaryComponentSize.height + Y_GAP);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/StatusText";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/StatusText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustComponentBounds";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findListener";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doPaintStatusText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "adjustComponentBounds";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "paintComponentInBounds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

