/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XLineBreakpointType<P extends XBreakpointProperties>
extends XBreakpointType<XLineBreakpoint<P>, P> {
    protected XLineBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            XLineBreakpointType.$$$reportNull$$$0(0);
        }
        if (title == null) {
            XLineBreakpointType.$$$reportNull$$$0(1);
        }
        super(id, title);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            XLineBreakpointType.$$$reportNull$$$0(2);
        }
        if (project == null) {
            XLineBreakpointType.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Nullable
    public abstract P createBreakpointProperties(@NotNull VirtualFile var1, int var2);

    @Override
    public String getDisplayText(XLineBreakpoint<P> breakpoint) {
        return XLineBreakpointType.fileLineDisplayText(breakpoint.getPresentableFilePath(), breakpoint.getLine());
    }

    private static String fileLineDisplayText(String path2, int line) {
        return XDebuggerBundle.message("xbreakpoint.default.display.text", line + 1, path2);
    }

    @Override
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<P> breakpoint) {
        if (breakpoint == null) {
            XLineBreakpointType.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    public String getShortText(XLineBreakpoint<P> breakpoint) {
        return XLineBreakpointType.fileLineDisplayText(breakpoint.getShortFilePath(), breakpoint.getLine());
    }

    @Override
    public final XLineBreakpoint<P> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<P> creator) {
        if (creator == null) {
            XLineBreakpointType.$$$reportNull$$$0(5);
        }
        return null;
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<P> breakpoint, @Nullable XDebugSession currentSession) {
        if (breakpoint == null) {
            XLineBreakpointType.$$$reportNull$$$0(6);
        }
        return Collections.emptyList();
    }

    public Icon getTemporaryIcon() {
        return AllIcons.Debugger.Db_temporary_breakpoint;
    }

    public int getPriority() {
        return 0;
    }

    public boolean canBeHitInOtherPlaces() {
        return false;
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<P> breakpoint) {
        return null;
    }

    @NotNull
    public List<? extends XLineBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            XLineBreakpointType.$$$reportNull$$$0(7);
        }
        if (position == null) {
            XLineBreakpointType.$$$reportNull$$$0(8);
        }
        List list = Collections.emptyList();
        if (list == null) {
            XLineBreakpointType.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/breakpoints/XLineBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/breakpoints/XLineBreakpointType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBreakpoint";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPopupMenuActions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class XLinePsiElementBreakpointVariant
    extends XLineBreakpointAllVariant {
        private final PsiElement myElement;

        public XLinePsiElementBreakpointVariant(XSourcePosition position, PsiElement element) {
            if (position == null) {
                XLinePsiElementBreakpointVariant.$$$reportNull$$$0(0);
            }
            super(position);
            this.myElement = element;
        }

        @Override
        public Icon getIcon() {
            return this.myElement.getIcon(0);
        }

        @Override
        public String getText() {
            return StringUtil.shortenTextWithEllipsis((String)this.myElement.getText(), (int)100, (int)0);
        }

        @Override
        public TextRange getHighlightRange() {
            return this.myElement.getTextRange();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/breakpoints/XLineBreakpointType$XLinePsiElementBreakpointVariant", "<init>"));
        }
    }

    public class XLineBreakpointAllVariant
    extends XLineBreakpointVariant {
        protected final XSourcePosition mySourcePosition;

        public XLineBreakpointAllVariant(XSourcePosition position) {
            if (position == null) {
                XLineBreakpointAllVariant.$$$reportNull$$$0(0);
            }
            this.mySourcePosition = position;
        }

        @Override
        public String getText() {
            return "All";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Debugger.MultipleBreakpoints;
        }

        @Override
        @Nullable
        public TextRange getHighlightRange() {
            return null;
        }

        @Override
        @Nullable
        public P createProperties() {
            return XLineBreakpointType.this.createBreakpointProperties(this.mySourcePosition.getFile(), this.mySourcePosition.getLine());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointAllVariant", "<init>"));
        }
    }

    public abstract class XLineBreakpointVariant {
        public abstract String getText();

        @Nullable
        public abstract Icon getIcon();

        @Nullable
        public abstract TextRange getHighlightRange();

        @Nullable
        public abstract P createProperties();
    }
}

