/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="HgGlobalSettings", storages={@Storage(value="hg.xml", roamingType=RoamingType.PER_OS), @Storage(value="vcs.xml", deprecated=true)})
public class HgGlobalSettings
implements PersistentStateComponent<State> {
    @NonNls
    private static final String[] DEFAULT_WINDOWS_PATHS = new String[]{"C:\\Program Files\\Mercurial", "C:\\Program Files (x86)\\Mercurial", "C:\\cygwin\\bin"};
    @NonNls
    private static final String[] DEFAULT_UNIX_PATHS = new String[]{"/usr/local/bin", "/usr/bin", "/opt/local/bin", "/opt/bin", "/usr/local/mercurial"};
    @NonNls
    private static final String DEFAULT_WINDOWS_HG = "hg.exe";
    @NonNls
    private static final String DEFAULT_UNIX_HG = "hg";
    private static final int FIVE_MINUTES = 300;
    private State myState = new State();
    private String myDetectedHgExecutable;

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    @NotNull
    public String defaultHgExecutable() {
        String hgExecutable = this.myState.myHgExecutable;
        if (hgExecutable != null) {
            String string = hgExecutable;
            if (string == null) {
                HgGlobalSettings.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (this.myDetectedHgExecutable == null) {
            String[] paths;
            String programName;
            if (SystemInfo.isWindows) {
                programName = DEFAULT_WINDOWS_HG;
                paths = DEFAULT_WINDOWS_PATHS;
            } else {
                programName = DEFAULT_UNIX_HG;
                paths = DEFAULT_UNIX_PATHS;
            }
            for (String p : paths) {
                File f = new File(p, programName);
                if (!f.exists()) continue;
                this.myDetectedHgExecutable = f.getAbsolutePath();
                break;
            }
            if (this.myDetectedHgExecutable == null) {
                this.myDetectedHgExecutable = programName;
            }
        }
        String string = this.myDetectedHgExecutable;
        if (string == null) {
            HgGlobalSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getRememberedUserName(@NotNull String stringUrl) {
        if (stringUrl == null) {
            HgGlobalSettings.$$$reportNull$$$0(2);
        }
        return this.myState.myRememberedUserNames.get(stringUrl);
    }

    public void addRememberedUrl(@Nullable String stringUrl, @Nullable String username) {
        if (StringUtil.isEmptyOrSpaces((String)stringUrl)) {
            return;
        }
        if (username == null) {
            username = "";
        }
        this.myState.myRememberedUserNames.put(stringUrl, username);
    }

    @NotNull
    public String getHgExecutable() {
        String string = this.myState.myHgExecutable == null ? this.defaultHgExecutable() : this.myState.myHgExecutable;
        if (string == null) {
            HgGlobalSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setHgExecutable(String hgExecutable) {
        this.myState.myHgExecutable = hgExecutable;
    }

    public static int getIncomingCheckIntervalSeconds() {
        return 300;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/HgGlobalSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultHgExecutable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/HgGlobalSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHgExecutable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRememberedUserName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        public String myHgExecutable = null;
        public Map<String, String> myRememberedUserNames = new HashMap();
    }
}

