/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.charset;

import com.intellij.lang.properties.charset.Native2AsciiCharset;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class Native2AsciiCharsetEncoder
extends CharsetEncoder {
    private static final char ANCHOR = (char)(Boolean.getBoolean("idea.native2ascii.lowercase") ? 97 : 65);
    private final Charset myBaseCharset;

    public Native2AsciiCharsetEncoder(Native2AsciiCharset charset) {
        super(charset, 1.0f, 6.0f);
        this.myBaseCharset = charset.getBaseCharset();
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        while (in.position() < in.limit()) {
            in.mark();
            try {
                char c = in.get();
                if (c < '\u0080') {
                    ByteBuffer byteBuffer = this.myBaseCharset.encode(Character.toString(c));
                    out.put(byteBuffer);
                    continue;
                }
                if (out.remaining() < 6) {
                    throw new BufferOverflowException();
                }
                out.put((byte)92);
                out.put((byte)117);
                out.put(Native2AsciiCharsetEncoder.toHexChar(c >> 12));
                out.put(Native2AsciiCharsetEncoder.toHexChar(c >> 8 & 0xF));
                out.put(Native2AsciiCharsetEncoder.toHexChar(c >> 4 & 0xF));
                out.put(Native2AsciiCharsetEncoder.toHexChar(c & 0xF));
            }
            catch (BufferUnderflowException e) {
                in.reset();
            }
            catch (BufferOverflowException e) {
                in.reset();
                return CoderResult.OVERFLOW;
            }
        }
        return CoderResult.UNDERFLOW;
    }

    private static byte toHexChar(int digit) {
        if (digit < 10) {
            return (byte)(48 + digit);
        }
        return (byte)(ANCHOR - 10 + digit);
    }
}

