/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.google.common.collect.Lists;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PydevXmlUtils;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.AbstractFrameCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GetCompletionsCommand
extends AbstractFrameCommand {
    private String myActionToken;
    private List<PydevCompletionVariant> myCompletions = null;

    public GetCompletionsCommand(RemoteDebugger debugger, String threadId, String frameId, String myActionToken) {
        super(debugger, 120, threadId, frameId);
        this.myActionToken = myActionToken;
    }

    @Override
    public boolean isResponseExpected() {
        return true;
    }

    @Override
    protected void processResponse(@NotNull ProtocolFrame response) throws PyDebuggerException {
        if (response == null) {
            GetCompletionsCommand.$$$reportNull$$$0(0);
        }
        super.processResponse(response);
        try {
            this.myCompletions = PydevXmlUtils.xmlToCompletions(response.getPayload(), this.myActionToken);
        }
        catch (Exception e) {
            throw new PyDebuggerException("cant obtain completions", e);
        }
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        super.buildPayload(payload);
        payload.add("FRAME").add(this.myActionToken);
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions() {
        if (this.myCompletions != null) {
            List<PydevCompletionVariant> list = this.myCompletions;
            if (list == null) {
                GetCompletionsCommand.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (arrayList == null) {
            GetCompletionsCommand.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/GetCompletionsCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/GetCompletionsCommand";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processResponse";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

