/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.config;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnServerFileManager;
import org.jetbrains.idea.svn.config.AmbiguousPatternsFinder;
import org.jetbrains.idea.svn.config.CompositeRunnable;
import org.jetbrains.idea.svn.config.ConfigureProxiesOptionsPanel;
import org.jetbrains.idea.svn.config.DefaultProxyGroup;
import org.jetbrains.idea.svn.config.GroupConfigurable;
import org.jetbrains.idea.svn.config.GroupsValidator;
import org.jetbrains.idea.svn.config.PatternsListener;
import org.jetbrains.idea.svn.config.ProxyGroup;
import org.jetbrains.idea.svn.config.RepositoryUrlFilter;
import org.jetbrains.idea.svn.config.TestConnectionPerformer;
import org.jetbrains.idea.svn.config.ValidationListener;

public class SvnConfigureProxiesComponent
extends MasterDetailsComponent {
    private final SvnServerFileManager myManager;
    private final CompositeRunnable myTreeUpdaterValidator;
    private final Runnable myValidator;
    private JComponent myComponent;
    private final TestConnectionPerformer myTestConnectionPerformer;
    private ConfigureProxiesOptionsPanel myDefaultGroupPanel;

    public SvnConfigureProxiesComponent(SvnServerFileManager manager, GroupsValidator validator, TestConnectionPerformer testConnectionPerformer) {
        this.myTestConnectionPerformer = testConnectionPerformer;
        this.myValidator = validator;
        this.myTreeUpdaterValidator = new CompositeRunnable(this.TREE_UPDATER, this.myValidator);
        this.initTree();
        this.myManager = manager;
        this.fillTree();
        validator.add(this);
    }

    @NotNull
    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = super.createComponent();
        }
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            SvnConfigureProxiesComponent.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    public String getDisplayName() {
        return "HTTP proxies configuration";
    }

    public String getHelpTopic() {
        return null;
    }

    private String getNewName() {
        return "Unnamed";
    }

    private void addGroup(ProxyGroup template) {
        ProxyGroup group = template == null ? new ProxyGroup(this.getNewName(), "", ContainerUtil.newHashMap()) : new ProxyGroup(this.getNewName(), template.getPatterns(), template.getProperties());
        this.addNode(this.createNodeForObject(group), this.myRoot);
        this.selectNodeInTree(group);
    }

    public List<String> getGlobalGroupRepositories(Collection<String> all) {
        LinkedList<String> result = new LinkedList<String>(all);
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            GroupConfigurable groupConfigurable = (GroupConfigurable)node.getConfigurable();
            if (groupConfigurable.getEditableObject().isDefault()) continue;
            result.removeAll(groupConfigurable.getRepositories());
        }
        return result;
    }

    public boolean validate(ValidationListener listener) {
        String groupName;
        GroupConfigurable groupConfigurable;
        MasterDetailsComponent.MyNode node;
        int i;
        Ref errorMessageRef = new Ref();
        HashSet<String> checkSet = new HashSet<String>();
        AmbiguousPatternsFinder ambiguousPatternsFinder = new AmbiguousPatternsFinder();
        for (i = 0; i < this.myRoot.getChildCount(); ++i) {
            node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            groupConfigurable = (GroupConfigurable)node.getConfigurable();
            groupName = groupConfigurable.getEditableObject().getName();
            if (checkSet.contains(groupName)) {
                listener.onError(SvnBundle.message("dialog.edit.http.proxies.settings.error.same.group.names.text", groupName), this.myComponent, true);
                return false;
            }
            checkSet.add(groupName);
        }
        for (i = 0; i < this.myRoot.getChildCount(); ++i) {
            node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            groupConfigurable = (GroupConfigurable)node.getConfigurable();
            groupConfigurable.applyImpl();
            if (!groupConfigurable.validate((Ref<String>)errorMessageRef)) {
                listener.onError((String)errorMessageRef.get(), this.myComponent, false);
                return false;
            }
            if (groupConfigurable.getEditableObject().isDefault()) continue;
            groupName = groupConfigurable.getEditableObject().getName();
            List<String> urls = groupConfigurable.getRepositories();
            ambiguousPatternsFinder.acceptUrls(groupName, urls);
        }
        if (!ambiguousPatternsFinder.isValid((Ref<String>)errorMessageRef)) {
            listener.onError((String)errorMessageRef.get(), this.myComponent, false);
            return false;
        }
        return true;
    }

    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add(new AnAction("Add", "Add", IconUtil.getAddIcon()){
            {
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)SvnConfigureProxiesComponent.this.myTree);
            }

            public void actionPerformed(AnActionEvent event) {
                SvnConfigureProxiesComponent.this.addGroup(null);
            }
        });
        result.add((AnAction)new MasterDetailsComponent.MyDeleteAction(SvnConfigureProxiesComponent.forAll(o -> {
            MasterDetailsComponent.MyNode node;
            if (o instanceof MasterDetailsComponent.MyNode && (node = (MasterDetailsComponent.MyNode)o).getConfigurable() instanceof GroupConfigurable) {
                ProxyGroup group = ((GroupConfigurable)node.getConfigurable()).getEditableObject();
                return !group.isDefault();
            }
            return false;
        })){

            public void actionPerformed(AnActionEvent e) {
                TreePath path = SvnConfigureProxiesComponent.this.myTree.getSelectionPath();
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)path.getLastPathComponent();
                MasterDetailsComponent.MyNode parentNode = (MasterDetailsComponent.MyNode)node.getParent();
                int idx = parentNode.getIndex((TreeNode)node);
                super.actionPerformed(e);
                int n = idx = idx == parentNode.getChildCount() ? idx - 1 : idx;
                if (parentNode.getChildCount() > 0) {
                    TreePath newSelectedPath = new TreePath(parentNode.getPath()).pathByAddingChild(parentNode.getChildAt(idx));
                    SvnConfigureProxiesComponent.this.myTree.setSelectionPath(newSelectedPath);
                }
            }
        });
        result.add(new AnAction("Copy", "Copy", PlatformIcons.COPY_ICON){
            {
                this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(68, 2)), (JComponent)SvnConfigureProxiesComponent.this.myTree);
            }

            public void actionPerformed(AnActionEvent event) {
                try {
                    SvnConfigureProxiesComponent.this.getSelectedConfigurable().apply();
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
                ProxyGroup selectedGroup = (ProxyGroup)SvnConfigureProxiesComponent.this.getSelectedObject();
                if (selectedGroup != null) {
                    SvnConfigureProxiesComponent.this.addGroup(selectedGroup);
                }
            }

            public void update(AnActionEvent event) {
                super.update(event);
                event.getPresentation().setEnabled(SvnConfigureProxiesComponent.this.getSelectedObject() != null);
            }
        });
        return result;
    }

    public void apply() throws ConfigurationException {
        ArrayList<ProxyGroup> groups = new ArrayList<ProxyGroup>(this.myRoot.getChildCount());
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            GroupConfigurable groupConfigurable = (GroupConfigurable)node.getConfigurable();
            groupConfigurable.apply();
            groups.add(groupConfigurable.getEditableObject());
        }
        this.myManager.updateUserServerFile(groups);
    }

    public void reset() {
        super.reset();
        this.myManager.updateFromFile();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            GroupConfigurable groupConfigurable = (GroupConfigurable)node.getConfigurable();
            groupConfigurable.reset();
        }
    }

    private MasterDetailsComponent.MyNode createNodeForObject(ProxyGroup group) {
        ConfigureProxiesOptionsPanel panel = new ConfigureProxiesOptionsPanel(this.myValidator, this.myTestConnectionPerformer);
        GroupConfigurable gc = new GroupConfigurable(group, this.myTreeUpdaterValidator, panel);
        if (group.isDefault()) {
            this.myDefaultGroupPanel = panel;
        }
        assert (this.myDefaultGroupPanel != null);
        panel.setPatternsListener(group.isDefault() ? PatternsListener.Empty.instance : new RepositoryUrlFilter(panel, this, this.myDefaultGroupPanel));
        return new MasterDetailsComponent.MyNode((NamedConfigurable)gc, group.isDefault());
    }

    private void fillTree() {
        this.myRoot.removeAllChildren();
        DefaultProxyGroup defaultProxyGroup = this.myManager.getDefaultGroup();
        defaultProxyGroup = defaultProxyGroup == null ? new DefaultProxyGroup(Collections.emptyMap()) : defaultProxyGroup;
        Map<String, ProxyGroup> userGroups = this.myManager.getGroups();
        this.myRoot.add((MutableTreeNode)this.createNodeForObject(defaultProxyGroup));
        for (Map.Entry<String, ProxyGroup> entry : userGroups.entrySet()) {
            this.myRoot.add((MutableTreeNode)this.createNodeForObject(entry.getValue()));
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, (Comparator)GroupNodesComparator.getInstance());
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        return GroupNodesComparator.getInstance();
    }

    public void setIsValid(boolean valid) {
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            GroupConfigurable groupConfigurable = (GroupConfigurable)node.getConfigurable();
            groupConfigurable.setIsValid(valid);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/config/SvnConfigureProxiesComponent", "createComponent"));
    }

    private static class GroupNodesComparator
    implements Comparator<MasterDetailsComponent.MyNode> {
        private static final GroupNodesComparator instance = new GroupNodesComparator();

        private GroupNodesComparator() {
        }

        private static GroupNodesComparator getInstance() {
            return instance;
        }

        @Override
        public int compare(MasterDetailsComponent.MyNode node1, MasterDetailsComponent.MyNode node2) {
            if (node1.getConfigurable() instanceof GroupConfigurable && node2.getConfigurable() instanceof GroupConfigurable) {
                ProxyGroup group1 = ((GroupConfigurable)node1.getConfigurable()).getEditableObject();
                ProxyGroup group2 = ((GroupConfigurable)node2.getConfigurable()).getEditableObject();
                if (group1.isDefault()) {
                    return -1;
                }
                if (group2.isDefault()) {
                    return 1;
                }
            }
            return node1.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
        }
    }
}

