/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusClient;

public class SvnKitStatusClient
extends BaseSvnClient
implements StatusClient {
    private SVNStatusClient myStatusClient;
    @Nullable
    private final ISVNStatusFileProvider myProvider;
    @Nullable
    private final ProgressTracker myHandler;

    public SvnKitStatusClient() {
        this(null, null);
    }

    public SvnKitStatusClient(@Nullable ISVNStatusFileProvider provider, @Nullable ProgressTracker handler) {
        this.myProvider = provider;
        this.myHandler = handler;
    }

    @Override
    public long doStatus(@NotNull File path, @Nullable SVNRevision revision, @NotNull Depth depth, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, @NotNull StatusConsumer handler) throws SvnBindException {
        if (path == null) {
            SvnKitStatusClient.$$$reportNull$$$0(0);
        }
        if (depth == null) {
            SvnKitStatusClient.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            SvnKitStatusClient.$$$reportNull$$$0(2);
        }
        try {
            return this.getStatusClient().doStatus(path, revision, SvnKitStatusClient.toDepth(depth), remote, reportAll, includeIgnored, collectParentExternals, status -> {
                if (handler == null) {
                    SvnKitStatusClient.$$$reportNull$$$0(6);
                }
                try {
                    handler.consume(Status.create(status));
                }
                catch (SvnBindException e) {
                    throw new SvnExceptionWrapper(e);
                }
            }, null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
        catch (SvnExceptionWrapper e) {
            Throwable cause = e.getCause();
            if (cause instanceof SvnBindException) {
                throw (SvnBindException)((Object)cause);
            }
            throw new SvnBindException(cause);
        }
    }

    @Override
    @Nullable
    public Status doStatus(@NotNull File path, boolean remote) throws SvnBindException {
        if (path == null) {
            SvnKitStatusClient.$$$reportNull$$$0(3);
        }
        try {
            return Status.create(this.getStatusClient().doStatus(path, remote));
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private SVNStatusClient getStatusClient() {
        SVNStatusClient sVNStatusClient = this.myHandler != null || this.myProvider != null ? this.ensureStatusClient() : this.myVcs.getSvnKitManager().createStatusClient();
        if (sVNStatusClient == null) {
            SvnKitStatusClient.$$$reportNull$$$0(4);
        }
        return sVNStatusClient;
    }

    @NotNull
    private SVNStatusClient ensureStatusClient() {
        if (this.myStatusClient == null) {
            this.myStatusClient = this.myVcs.getSvnKitManager().createStatusClient();
            this.myStatusClient.setFilesProvider(this.myProvider);
            this.myStatusClient.setEventHandler(SvnKitStatusClient.toEventHandler(this.myHandler));
        }
        SVNStatusClient sVNStatusClient = this.myStatusClient;
        if (sVNStatusClient == null) {
            SvnKitStatusClient.$$$reportNull$$$0(5);
        }
        return sVNStatusClient;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depth";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/status/SvnKitStatusClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/status/SvnKitStatusClient";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusClient";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureStatusClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doStatus";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doStatus$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

