/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.svnkit;

import com.intellij.openapi.application.ApplicationManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnWorkingCopyFormatHolder;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;

public class SvnKitAdminAreaFactorySelector
implements ISVNAdminAreaFactorySelector {
    public Collection getEnabledFactories(File path, Collection factories, boolean writeAccess) throws SVNException {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return factories;
        }
        if (!writeAccess) {
            return factories;
        }
        Collection result = null;
        WorkingCopyFormat presetFormat = SvnWorkingCopyFormatHolder.getPresetFormat();
        if (presetFormat != null) {
            result = SvnKitAdminAreaFactorySelector.format2Factories(presetFormat, factories);
        }
        if (result == null) {
            WorkingCopyFormat format = SvnFormatSelector.getWorkingCopyFormat(path);
            result = SvnKitAdminAreaFactorySelector.format2Factories(format, factories);
        }
        if (result == null) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_NOT_DIRECTORY));
        }
        return result;
    }

    @Nullable
    static Collection format2Factories(WorkingCopyFormat format, Collection factories) {
        if (WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)format)) {
            return factories;
        }
        if (WorkingCopyFormat.ONE_DOT_SIX.equals((Object)format)) {
            return SvnKitAdminAreaFactorySelector.factoriesFor16(factories);
        }
        if (WorkingCopyFormat.ONE_DOT_FIVE.equals((Object)format)) {
            return SvnKitAdminAreaFactorySelector.factoriesFor15(factories);
        }
        if (WorkingCopyFormat.ONE_DOT_FOUR.equals((Object)format)) {
            return SvnKitAdminAreaFactorySelector.factoriesFor14(factories);
        }
        if (WorkingCopyFormat.ONE_DOT_THREE.equals((Object)format)) {
            return SvnKitAdminAreaFactorySelector.factoriesFor13(factories);
        }
        return null;
    }

    private static Collection<SVNAdminAreaFactory> factoriesFor13(Collection factories) {
        for (Object item : factories) {
            SVNAdminAreaFactory factory = (SVNAdminAreaFactory)item;
            int supportedVersion = factory.getSupportedVersion();
            if (WorkingCopyFormat.ONE_DOT_THREE.getFormat() != supportedVersion) continue;
            return Collections.singletonList(factory);
        }
        return Collections.emptyList();
    }

    private static Collection<SVNAdminAreaFactory> factoriesFor14(Collection factories) {
        ArrayList<SVNAdminAreaFactory> result = new ArrayList<SVNAdminAreaFactory>(2);
        for (Object item : factories) {
            SVNAdminAreaFactory factory = (SVNAdminAreaFactory)item;
            int supportedVersion = factory.getSupportedVersion();
            if (WorkingCopyFormat.ONE_DOT_FOUR.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_THREE.getFormat() != supportedVersion) continue;
            result.add(factory);
        }
        return result;
    }

    private static Collection<SVNAdminAreaFactory> factoriesFor15(Collection factories) {
        ArrayList<SVNAdminAreaFactory> result = new ArrayList<SVNAdminAreaFactory>(2);
        for (Object item : factories) {
            SVNAdminAreaFactory factory = (SVNAdminAreaFactory)item;
            int supportedVersion = factory.getSupportedVersion();
            if (WorkingCopyFormat.ONE_DOT_FOUR.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_THREE.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_FIVE.getFormat() != supportedVersion) continue;
            result.add(factory);
        }
        return result;
    }

    private static Collection<SVNAdminAreaFactory> factoriesFor16(Collection factories) {
        ArrayList<SVNAdminAreaFactory> result = new ArrayList<SVNAdminAreaFactory>(2);
        for (Object item : factories) {
            SVNAdminAreaFactory factory = (SVNAdminAreaFactory)item;
            int supportedVersion = factory.getSupportedVersion();
            if (WorkingCopyFormat.ONE_DOT_FOUR.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_THREE.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_FIVE.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_SIX.getFormat() != supportedVersion) continue;
            result.add(factory);
        }
        return result;
    }
}

