/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.BasicAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitVcsSettings;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitFetchResult;
import git4idea.update.GitFetcher;
import git4idea.update.GitUpdateResult;
import git4idea.util.GitPreservingProcess;
import icons.GithubIcons;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubRebaseAction
extends DumbAwareAction {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String CANNOT_PERFORM_GITHUB_REBASE = "Can't perform GitHub rebase";

    public GithubRebaseAction() {
        super("Rebase my GitHub fork", "Rebase your GitHub forked repository relative to the origin", GithubIcons.Github_icon);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDefault()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitRepository gitRepository = GithubUtil.getGitRepository(project, file);
        if (gitRepository == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (!GithubUtil.isRepositoryOnGitHub(gitRepository)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDisposed() || !GithubUtil.testGitExecutable(project)) {
            return;
        }
        GithubRebaseAction.rebaseMyGithubFork(project, file);
    }

    private static void rebaseMyGithubFork(final @NotNull Project project, @Nullable VirtualFile file) {
        GitRepository gitRepository;
        if (project == null) {
            GithubRebaseAction.$$$reportNull$$$0(0);
        }
        if ((gitRepository = GithubUtil.getGitRepository(project, file)) == null) {
            GithubNotifications.showError(project, CANNOT_PERFORM_GITHUB_REBASE, "Can't find git repository");
            return;
        }
        BasicAction.saveAll();
        new Task.Backgroundable(project, "Rebasing GitHub Fork..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                gitRepository.update();
                String upstreamRemoteUrl = GithubUtil.findUpstreamRemote(gitRepository);
                if (upstreamRemoteUrl == null) {
                    LOG.info("Configuring upstream remote");
                    indicator.setText("Configuring upstream remote...");
                    upstreamRemoteUrl = GithubRebaseAction.configureUpstreamRemote(project, gitRepository, indicator);
                    if (upstreamRemoteUrl == null) {
                        return;
                    }
                }
                if (!GithubUrlUtil.isGithubUrl(upstreamRemoteUrl)) {
                    GithubNotifications.showError(project, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Configured upstream is not a GitHub repository: " + upstreamRemoteUrl);
                    return;
                }
                GithubFullPath userAndRepo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(upstreamRemoteUrl);
                String login = GithubSettings.getInstance().getLogin();
                if (userAndRepo != null && userAndRepo.getUser().equals(login)) {
                    GithubNotifications.showError(project, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Configured upstream seems to be your own repository: " + upstreamRemoteUrl);
                    return;
                }
                LOG.info("Fetching upstream");
                indicator.setText("Fetching upstream...");
                if (!GithubRebaseAction.fetchParent(project, gitRepository, indicator)) {
                    return;
                }
                LOG.info("Rebasing current branch");
                indicator.setText("Rebasing current branch...");
                GithubRebaseAction.rebaseCurrentBranch(project, gitRepository, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubRebaseAction$1", "run"));
            }
        }.queue();
    }

    @Nullable
    static String configureUpstreamRemote(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull ProgressIndicator indicator) {
        GithubRepoDetailed repositoryInfo;
        if (project == null) {
            GithubRebaseAction.$$$reportNull$$$0(1);
        }
        if (gitRepository == null) {
            GithubRebaseAction.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            GithubRebaseAction.$$$reportNull$$$0(3);
        }
        if ((repositoryInfo = GithubRebaseAction.loadRepositoryInfo(project, gitRepository, indicator)) == null) {
            return null;
        }
        if (!repositoryInfo.isFork() || repositoryInfo.getParent() == null) {
            GithubNotifications.showWarningURL(project, CANNOT_PERFORM_GITHUB_REBASE, "GitHub repository ", "'" + repositoryInfo.getName() + "'", " is not a fork", repositoryInfo.getHtmlUrl());
            return null;
        }
        String parentRepoUrl = GithubUrlUtil.getCloneUrl(repositoryInfo.getParent().getFullPath());
        LOG.info("Adding GitHub parent as a remote host");
        indicator.setText("Adding GitHub parent as a remote host...");
        if (GithubUtil.addGithubRemote(project, gitRepository, "upstream", parentRepoUrl)) {
            return parentRepoUrl;
        }
        return null;
    }

    @Nullable
    private static GithubRepoDetailed loadRepositoryInfo(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull ProgressIndicator indicator) {
        String remoteUrl;
        if (project == null) {
            GithubRebaseAction.$$$reportNull$$$0(4);
        }
        if (gitRepository == null) {
            GithubRebaseAction.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            GithubRebaseAction.$$$reportNull$$$0(6);
        }
        if ((remoteUrl = GithubUtil.findGithubRemoteUrl(gitRepository)) == null) {
            GithubNotifications.showError(project, CANNOT_PERFORM_GITHUB_REBASE, "Can't find GitHub remote");
            return null;
        }
        GithubFullPath userAndRepo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
        if (userAndRepo == null) {
            GithubNotifications.showError(project, CANNOT_PERFORM_GITHUB_REBASE, "Can't process remote: " + remoteUrl);
            return null;
        }
        try {
            return (GithubRepoDetailed)GithubUtil.runTask(project, GithubAuthDataHolder.createFromSettings(), indicator, connection -> GithubApiUtil.getDetailedRepoInfo(connection, userAndRepo.getUser(), userAndRepo.getRepository()));
        }
        catch (IOException e) {
            GithubNotifications.showError(project, "Can't load repository info", e);
            return null;
        }
    }

    private static boolean fetchParent(@NotNull Project project, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator) {
        GitFetchResult result;
        if (project == null) {
            GithubRebaseAction.$$$reportNull$$$0(7);
        }
        if (repository == null) {
            GithubRebaseAction.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            GithubRebaseAction.$$$reportNull$$$0(9);
        }
        if (!(result = new GitFetcher(project, indicator, false).fetch(repository.getRoot(), "upstream", null)).isSuccess()) {
            GitFetcher.displayFetchResult((Project)project, (GitFetchResult)result, null, (Collection)result.getErrors());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rebaseCurrentBranch(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GithubRebaseAction.$$$reportNull$$$0(10);
        }
        if (gitRepository == null) {
            GithubRebaseAction.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            GithubRebaseAction.$$$reportNull$$$0(12);
        }
        Git git = (Git)ServiceManager.getService((Project)project, Git.class);
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)project);
        try {
            List<VirtualFile> rootsToSave = Collections.singletonList(gitRepository.getRoot());
            GitPreservingProcess process = new GitPreservingProcess(project, git, rootsToSave, "Rebasing", "upstream/master", GitVcsSettings.UpdateChangesPolicy.STASH, indicator, () -> {
                if (project == null) {
                    GithubRebaseAction.$$$reportNull$$$0(16);
                }
                if (gitRepository == null) {
                    GithubRebaseAction.$$$reportNull$$$0(17);
                }
                if (indicator == null) {
                    GithubRebaseAction.$$$reportNull$$$0(18);
                }
                GithubRebaseAction.doRebaseCurrentBranch(project, gitRepository.getRoot(), indicator);
            });
            process.execute();
        }
        finally {
            token.finish();
        }
    }

    private static void doRebaseCurrentBranch(@NotNull Project project, @NotNull VirtualFile root, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GithubRebaseAction.$$$reportNull$$$0(13);
        }
        if (root == null) {
            GithubRebaseAction.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            GithubRebaseAction.$$$reportNull$$$0(15);
        }
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager((Project)project);
        Git git = (Git)ServiceManager.getService(Git.class);
        GitRebaser rebaser = new GitRebaser(project, git, indicator);
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE);
        handler.setStdoutSuppressed(false);
        handler.addParameters(new String[]{"upstream/master"});
        GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
        handler.addLineListener((GitLineHandlerListener)rebaseConflictDetector);
        GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
        GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT);
        handler.addLineListener((GitLineHandlerListener)untrackedFilesDetector);
        handler.addLineListener((GitLineHandlerListener)localChangesDetector);
        handler.addLineListener(GitStandardProgressAnalyzer.createListener((ProgressIndicator)indicator));
        String oldText = indicator.getText();
        indicator.setText("Rebasing from upstream/master...");
        GitCommandResult rebaseResult = git.runCommand(handler);
        indicator.setText(oldText);
        repositoryManager.updateRepository(root);
        if (rebaseResult.success()) {
            root.refresh(false, true);
            GithubNotifications.showInfo(project, "Success", "Successfully rebased GitHub fork");
        } else {
            GitUpdateResult result = rebaser.handleRebaseFailure(handler, root, rebaseResult, rebaseConflictDetector, (GitMessageWithFilesDetector)untrackedFilesDetector, localChangesDetector);
            if (result == GitUpdateResult.NOTHING_TO_UPDATE || result == GitUpdateResult.SUCCESS || result == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) {
                GithubNotifications.showInfo(project, "Success", "Successfully rebased GitHub fork");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRepository";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/github/GithubRebaseAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "rebaseMyGithubFork";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "configureUpstreamRemote";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "loadRepositoryInfo";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchParent";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "rebaseCurrentBranch";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "doRebaseCurrentBranch";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$rebaseCurrentBranch$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

