/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.NullCheckingFactory;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.data.GithubAuthorization;
import org.jetbrains.plugins.github.api.data.GithubBranch;
import org.jetbrains.plugins.github.api.data.GithubCommit;
import org.jetbrains.plugins.github.api.data.GithubCommitComment;
import org.jetbrains.plugins.github.api.data.GithubCommitDetailed;
import org.jetbrains.plugins.github.api.data.GithubFile;
import org.jetbrains.plugins.github.api.data.GithubGist;
import org.jetbrains.plugins.github.api.data.GithubIssue;
import org.jetbrains.plugins.github.api.data.GithubIssueComment;
import org.jetbrains.plugins.github.api.data.GithubIssuesSearchResult;
import org.jetbrains.plugins.github.api.data.GithubPullRequest;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.data.GithubUserDetailed;
import org.jetbrains.plugins.github.api.requests.GithubAuthorizationCreateRequest;
import org.jetbrains.plugins.github.api.requests.GithubAuthorizationUpdateRequest;
import org.jetbrains.plugins.github.api.requests.GithubChangeIssueStateRequest;
import org.jetbrains.plugins.github.api.requests.GithubGistRequest;
import org.jetbrains.plugins.github.api.requests.GithubPullRequestRequest;
import org.jetbrains.plugins.github.api.requests.GithubRepoRequest;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubApiUtil {
    private static final Logger LOG = GithubUtil.LOG;
    public static final String DEFAULT_GITHUB_HOST = "github.com";
    private static final String PER_PAGE = "per_page=100";
    private static final Header ACCEPT_V3_JSON_HTML_MARKUP = new BasicHeader("Accept", "application/vnd.github.v3.html+json");
    private static final Header ACCEPT_V3_JSON = new BasicHeader("Accept", "application/vnd.github.v3+json");
    @NotNull
    private static final Gson gson = GithubApiUtil.initGson();

    private static Gson initGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)NullCheckingFactory.INSTANCE);
        return builder.create();
    }

    @NotNull
    public static <T> T fromJson(@Nullable JsonElement json, @NotNull Class<T> classT) throws IOException {
        Object object;
        if (classT == null) {
            GithubApiUtil.$$$reportNull$$$0(0);
        }
        if (json == null) {
            throw new GithubJsonException("Unexpected empty response");
        }
        try {
            Object res = gson.fromJson(json, classT);
            if (res == null) {
                throw new GithubJsonException("Empty Json response");
            }
            object = res;
        }
        catch (JsonParseException | ClassCastException e) {
            throw new GithubJsonException("Parse exception while converting JSON to object " + classT.toString(), e);
        }
        if (object == null) {
            GithubApiUtil.$$$reportNull$$$0(1);
        }
        return (T)object;
    }

    @NotNull
    private static <T> List<T> loadAll(@NotNull GithubConnection connection, @NotNull String path, @NotNull Class<? extends T[]> type, Header ... headers) throws IOException {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(2);
        }
        if (path == null) {
            GithubApiUtil.$$$reportNull$$$0(3);
        }
        if (type == null) {
            GithubApiUtil.$$$reportNull$$$0(4);
        }
        if (headers == null) {
            GithubApiUtil.$$$reportNull$$$0(5);
        }
        GithubConnection.ArrayPagedRequest request = new GithubConnection.ArrayPagedRequest(path, type, headers);
        List list = request.getAll(connection);
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static <T> T load(@NotNull GithubConnection connection, @NotNull String path, @NotNull Class<? extends T> type, Header ... headers) throws IOException {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(7);
        }
        if (path == null) {
            GithubApiUtil.$$$reportNull$$$0(8);
        }
        if (type == null) {
            GithubApiUtil.$$$reportNull$$$0(9);
        }
        if (headers == null) {
            GithubApiUtil.$$$reportNull$$$0(10);
        }
        JsonElement result = connection.getRequest(path, headers);
        T t = GithubApiUtil.fromJson(result, type);
        if (t == null) {
            GithubApiUtil.$$$reportNull$$$0(11);
        }
        return t;
    }

    @NotNull
    private static <T> T post(@NotNull GithubConnection connection, @NotNull String path, @NotNull Object request, @NotNull Class<? extends T> type, Header ... headers) throws IOException {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(12);
        }
        if (path == null) {
            GithubApiUtil.$$$reportNull$$$0(13);
        }
        if (request == null) {
            GithubApiUtil.$$$reportNull$$$0(14);
        }
        if (type == null) {
            GithubApiUtil.$$$reportNull$$$0(15);
        }
        if (headers == null) {
            GithubApiUtil.$$$reportNull$$$0(16);
        }
        JsonElement result = connection.postRequest(path, gson.toJson(request), headers);
        T t = GithubApiUtil.fromJson(result, type);
        if (t == null) {
            GithubApiUtil.$$$reportNull$$$0(17);
        }
        return t;
    }

    public static void askForTwoFactorCodeSMS(@NotNull GithubConnection connection) {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(18);
        }
        try {
            connection.postRequest("/authorizations", null, ACCEPT_V3_JSON);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    public static Collection<String> getTokenScopes(@NotNull GithubConnection connection) throws IOException {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(19);
        }
        Header[] headers = connection.headRequest("/user", ACCEPT_V3_JSON);
        Header scopesHeader = null;
        for (Header header : headers) {
            if (!header.getName().equals("X-OAuth-Scopes")) continue;
            scopesHeader = header;
            break;
        }
        if (scopesHeader == null) {
            throw new GithubConfusingException("No scopes header");
        }
        ArrayList<String> scopes = new ArrayList<String>();
        for (HeaderElement elem : scopesHeader.getElements()) {
            scopes.add(elem.getName());
        }
        ArrayList<String> arrayList = scopes;
        if (arrayList == null) {
            GithubApiUtil.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    public static String getScopedToken(@NotNull GithubConnection connection, @NotNull Collection<String> scopes, @NotNull String note) throws IOException {
        String string;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(21);
        }
        if (scopes == null) {
            GithubApiUtil.$$$reportNull$$$0(22);
        }
        if (note == null) {
            GithubApiUtil.$$$reportNull$$$0(23);
        }
        try {
            string = GithubApiUtil.getNewScopedToken(connection, scopes, note).getToken();
        }
        catch (GithubStatusCodeException e) {
            if (e.getError() != null && e.getError().containsErrorCode("already_exists")) {
                List<GithubAuthorization> tokens = GithubApiUtil.getAllTokens(connection);
                for (int i = 1; i < 100; ++i) {
                    String newNote = note + "_" + i;
                    if (ContainerUtil.exists(tokens, authorization -> newNote.equals(authorization.getNote()))) continue;
                    String string2 = GithubApiUtil.getNewScopedToken(connection, scopes, newNote).getToken();
                    if (string2 == null) {
                        GithubApiUtil.$$$reportNull$$$0(25);
                    }
                    return string2;
                }
            }
            throw e;
        }
        if (string == null) {
            GithubApiUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static GithubAuthorization updateTokenScopes(@NotNull GithubConnection connection, @NotNull GithubAuthorization token, @NotNull Collection<String> scopes) throws IOException {
        GithubAuthorization githubAuthorization;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(26);
        }
        if (token == null) {
            GithubApiUtil.$$$reportNull$$$0(27);
        }
        if (scopes == null) {
            GithubApiUtil.$$$reportNull$$$0(28);
        }
        try {
            String path = "/authorizations/" + token.getId();
            GithubAuthorizationUpdateRequest request = new GithubAuthorizationUpdateRequest(new ArrayList<String>(scopes));
            githubAuthorization = GithubApiUtil.fromJson(connection.patchRequest(path, gson.toJson((Object)request), ACCEPT_V3_JSON), GithubAuthorization.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't update token: scopes - " + scopes);
            throw e;
        }
        if (githubAuthorization == null) {
            GithubApiUtil.$$$reportNull$$$0(29);
        }
        return githubAuthorization;
    }

    @NotNull
    private static GithubAuthorization getNewScopedToken(@NotNull GithubConnection connection, @NotNull Collection<String> scopes, @NotNull String note) throws IOException {
        GithubAuthorization githubAuthorization;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(30);
        }
        if (scopes == null) {
            GithubApiUtil.$$$reportNull$$$0(31);
        }
        if (note == null) {
            GithubApiUtil.$$$reportNull$$$0(32);
        }
        try {
            String path = "/authorizations";
            GithubAuthorizationCreateRequest request = new GithubAuthorizationCreateRequest(new ArrayList<String>(scopes), note, null);
            githubAuthorization = GithubApiUtil.post(connection, path, request, GithubAuthorization.class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't create token: scopes - " + scopes + " - note " + note);
            throw e;
        }
        if (githubAuthorization == null) {
            GithubApiUtil.$$$reportNull$$$0(33);
        }
        return githubAuthorization;
    }

    @NotNull
    private static List<GithubAuthorization> getAllTokens(@NotNull GithubConnection connection) throws IOException {
        List<GithubAuthorization> list;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(34);
        }
        try {
            String path = "/authorizations";
            list = GithubApiUtil.loadAll(connection, path, GithubAuthorization[].class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get available tokens");
            throw e;
        }
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public static String getMasterToken(@NotNull GithubConnection connection, @NotNull String note) throws IOException {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(36);
        }
        if (note == null) {
            GithubApiUtil.$$$reportNull$$$0(37);
        }
        List<String> scopes = Arrays.asList("repo", "gist");
        String string = GithubApiUtil.getScopedToken(connection, scopes, note);
        if (string == null) {
            GithubApiUtil.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    public static String getTasksToken(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String note) throws IOException {
        GithubRepoDetailed repository;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(39);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(40);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(41);
        }
        if (note == null) {
            GithubApiUtil.$$$reportNull$$$0(42);
        }
        List<String> scopes = (repository = GithubApiUtil.getDetailedRepoInfo(connection, user, repo)).isPrivate() ? Collections.singletonList("repo") : Collections.singletonList("public_repo");
        String string = GithubApiUtil.getScopedToken(connection, scopes, note);
        if (string == null) {
            GithubApiUtil.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    public static GithubUserDetailed getCurrentUser(@NotNull GithubConnection connection) throws IOException {
        GithubUserDetailed githubUserDetailed;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(44);
        }
        try {
            githubUserDetailed = GithubApiUtil.load(connection, "/user", GithubUserDetailed.class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get user info");
            throw e;
        }
        if (githubUserDetailed == null) {
            GithubApiUtil.$$$reportNull$$$0(45);
        }
        return githubUserDetailed;
    }

    @NotNull
    public static List<GithubRepo> getUserRepos(@NotNull GithubConnection connection) throws IOException {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(46);
        }
        List<GithubRepo> list = GithubApiUtil.getUserRepos(connection, false);
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(47);
        }
        return list;
    }

    @NotNull
    public static List<GithubRepo> getUserRepos(@NotNull GithubConnection connection, boolean allAssociated) throws IOException {
        List<GithubRepo> list;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(48);
        }
        try {
            String type = allAssociated ? "" : "type=owner&";
            String path = "/user/repos?" + type + PER_PAGE;
            list = GithubApiUtil.loadAll(connection, path, GithubRepo[].class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get user repositories");
            throw e;
        }
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(49);
        }
        return list;
    }

    @NotNull
    public static List<GithubRepo> getUserRepos(@NotNull GithubConnection connection, @NotNull String user) throws IOException {
        List<GithubRepo> list;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(50);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(51);
        }
        try {
            String path = "/users/" + user + "/repos?type=owner&" + PER_PAGE;
            list = GithubApiUtil.loadAll(connection, path, GithubRepo[].class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get user repositories: " + user);
            throw e;
        }
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(52);
        }
        return list;
    }

    @NotNull
    public static List<GithubRepo> getAvailableRepos(@NotNull GithubConnection connection) throws IOException {
        ArrayList<GithubRepo> arrayList;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(53);
        }
        try {
            ArrayList<GithubRepo> repos = new ArrayList<GithubRepo>(GithubApiUtil.getUserRepos(connection, true));
            try {
                repos.addAll(GithubApiUtil.getWatchedRepos(connection));
            }
            catch (GithubAuthenticationException | GithubStatusCodeException iOException) {
                // empty catch block
            }
            arrayList = repos;
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get available repositories");
            throw e;
        }
        if (arrayList == null) {
            GithubApiUtil.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    @NotNull
    private static List<GithubRepo> getWatchedRepos(@NotNull GithubConnection connection) throws IOException {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(55);
        }
        String pathWatched = "/user/subscriptions?per_page=100";
        List<GithubRepo> list = GithubApiUtil.loadAll(connection, pathWatched, GithubRepo[].class, ACCEPT_V3_JSON);
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(56);
        }
        return list;
    }

    @NotNull
    public static GithubRepoDetailed getDetailedRepoInfo(@NotNull GithubConnection connection, @NotNull String owner, @NotNull String name) throws IOException {
        GithubRepoDetailed githubRepoDetailed;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(57);
        }
        if (owner == null) {
            GithubApiUtil.$$$reportNull$$$0(58);
        }
        if (name == null) {
            GithubApiUtil.$$$reportNull$$$0(59);
        }
        try {
            String request = "/repos/" + owner + "/" + name;
            githubRepoDetailed = GithubApiUtil.load(connection, request, GithubRepoDetailed.class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get repository info: " + owner + "/" + name);
            throw e;
        }
        if (githubRepoDetailed == null) {
            GithubApiUtil.$$$reportNull$$$0(60);
        }
        return githubRepoDetailed;
    }

    public static void deleteGithubRepository(@NotNull GithubConnection connection, @NotNull String username, @NotNull String repo) throws IOException {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(61);
        }
        if (username == null) {
            GithubApiUtil.$$$reportNull$$$0(62);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(63);
        }
        try {
            String path = "/repos/" + username + "/" + repo;
            connection.deleteRequest(path, new Header[0]);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't delete repository: " + username + "/" + repo);
            throw e;
        }
    }

    public static void deleteGist(@NotNull GithubConnection connection, @NotNull String id) throws IOException {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(64);
        }
        if (id == null) {
            GithubApiUtil.$$$reportNull$$$0(65);
        }
        try {
            String path = "/gists/" + id;
            connection.deleteRequest(path, new Header[0]);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't delete gist: id - " + id);
            throw e;
        }
    }

    @NotNull
    public static GithubGist getGist(@NotNull GithubConnection connection, @NotNull String id) throws IOException {
        GithubGist githubGist;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(66);
        }
        if (id == null) {
            GithubApiUtil.$$$reportNull$$$0(67);
        }
        try {
            String path = "/gists/" + id;
            githubGist = GithubApiUtil.load(connection, path, GithubGist.class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get gist info: id " + id);
            throw e;
        }
        if (githubGist == null) {
            GithubApiUtil.$$$reportNull$$$0(68);
        }
        return githubGist;
    }

    @NotNull
    public static GithubGist createGist(@NotNull GithubConnection connection, @NotNull List<GithubGistRequest.FileContent> contents, @NotNull String description, boolean isPublic) throws IOException {
        GithubGist githubGist;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(69);
        }
        if (contents == null) {
            GithubApiUtil.$$$reportNull$$$0(70);
        }
        if (description == null) {
            GithubApiUtil.$$$reportNull$$$0(71);
        }
        try {
            GithubGistRequest request = new GithubGistRequest(contents, description, isPublic);
            githubGist = GithubApiUtil.post(connection, "/gists", request, GithubGist.class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't create gist");
            throw e;
        }
        if (githubGist == null) {
            GithubApiUtil.$$$reportNull$$$0(72);
        }
        return githubGist;
    }

    @NotNull
    public static List<GithubRepo> getForks(@NotNull GithubConnection connection, @NotNull String owner, @NotNull String name) throws IOException {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(73);
        }
        if (owner == null) {
            GithubApiUtil.$$$reportNull$$$0(74);
        }
        if (name == null) {
            GithubApiUtil.$$$reportNull$$$0(75);
        }
        String path = "/repos/" + owner + "/" + name + "/forks?" + PER_PAGE;
        List<GithubRepo> list = GithubApiUtil.loadAll(connection, path, GithubRepo[].class, ACCEPT_V3_JSON);
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(76);
        }
        return list;
    }

    @NotNull
    public static GithubPullRequest createPullRequest(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String title, @NotNull String description, @NotNull String head, @NotNull String base) throws IOException {
        GithubPullRequest githubPullRequest;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(77);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(78);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(79);
        }
        if (title == null) {
            GithubApiUtil.$$$reportNull$$$0(80);
        }
        if (description == null) {
            GithubApiUtil.$$$reportNull$$$0(81);
        }
        if (head == null) {
            GithubApiUtil.$$$reportNull$$$0(82);
        }
        if (base == null) {
            GithubApiUtil.$$$reportNull$$$0(83);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls";
            GithubPullRequestRequest request = new GithubPullRequestRequest(title, description, head, base);
            githubPullRequest = GithubApiUtil.post(connection, path, request, GithubPullRequest.class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't create pull request");
            throw e;
        }
        if (githubPullRequest == null) {
            GithubApiUtil.$$$reportNull$$$0(84);
        }
        return githubPullRequest;
    }

    @NotNull
    public static GithubRepo createRepo(@NotNull GithubConnection connection, @NotNull String name, @NotNull String description, boolean isPrivate) throws IOException {
        GithubRepo githubRepo;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(85);
        }
        if (name == null) {
            GithubApiUtil.$$$reportNull$$$0(86);
        }
        if (description == null) {
            GithubApiUtil.$$$reportNull$$$0(87);
        }
        try {
            String path = "/user/repos";
            GithubRepoRequest request = new GithubRepoRequest(name, description, isPrivate);
            githubRepo = GithubApiUtil.post(connection, path, request, GithubRepo.class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't create repository: " + name);
            throw e;
        }
        if (githubRepo == null) {
            GithubApiUtil.$$$reportNull$$$0(88);
        }
        return githubRepo;
    }

    @NotNull
    public static List<GithubIssue> getIssuesAssigned(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @Nullable String assigned, int max, boolean withClosed) throws IOException {
        ArrayList<GithubIssue> arrayList;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(89);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(90);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(91);
        }
        try {
            String state = "state=" + (withClosed ? "all" : "open");
            String path = StringUtil.isEmptyOrSpaces((String)assigned) ? "/repos/" + user + "/" + repo + "/issues?" + PER_PAGE + "&" + state : "/repos/" + user + "/" + repo + "/issues?assignee=" + assigned + "&" + PER_PAGE + "&" + state;
            GithubConnection.ArrayPagedRequest request = new GithubConnection.ArrayPagedRequest(path, GithubIssue[].class, ACCEPT_V3_JSON);
            ArrayList<GithubIssue> result = new ArrayList<GithubIssue>();
            while (request.hasNext() && max > result.size()) {
                result.addAll(request.next(connection));
            }
            arrayList = result;
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get assigned issues: " + user + "/" + repo + " - " + assigned);
            throw e;
        }
        if (arrayList == null) {
            GithubApiUtil.$$$reportNull$$$0(92);
        }
        return arrayList;
    }

    @NotNull
    public static List<GithubIssue> getIssuesQueried(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @Nullable String assignedUser, @Nullable String query, boolean withClosed) throws IOException {
        List<GithubIssue> list;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(93);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(94);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(95);
        }
        try {
            String state = withClosed ? "" : " state:open";
            String assignee = StringUtil.isEmptyOrSpaces((String)assignedUser) ? "" : " assignee:" + assignedUser;
            query = URLEncoder.encode("repo:" + user + "/" + repo + state + assignee + " " + query, "UTF-8");
            String path = "/search/issues?q=" + query;
            list = GithubApiUtil.load(connection, path, GithubIssuesSearchResult.class, ACCEPT_V3_JSON).getIssues();
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get queried issues: " + user + "/" + repo + " - " + query);
            throw e;
        }
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(96);
        }
        return list;
    }

    @NotNull
    public static GithubIssue getIssue(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String id) throws IOException {
        GithubIssue githubIssue;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(97);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(98);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(99);
        }
        if (id == null) {
            GithubApiUtil.$$$reportNull$$$0(100);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/issues/" + id;
            githubIssue = GithubApiUtil.load(connection, path, GithubIssue.class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get issue info: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (githubIssue == null) {
            GithubApiUtil.$$$reportNull$$$0(101);
        }
        return githubIssue;
    }

    @NotNull
    public static List<GithubIssueComment> getIssueComments(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, long id) throws IOException {
        List<GithubIssueComment> list;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(102);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(103);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(104);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/issues/" + id + "/comments?" + PER_PAGE;
            list = GithubApiUtil.loadAll(connection, path, GithubIssueComment[].class, ACCEPT_V3_JSON_HTML_MARKUP);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get issue comments: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(105);
        }
        return list;
    }

    public static void setIssueState(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String id, boolean open) throws IOException {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(106);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(107);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(108);
        }
        if (id == null) {
            GithubApiUtil.$$$reportNull$$$0(109);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/issues/" + id;
            GithubChangeIssueStateRequest request = new GithubChangeIssueStateRequest(open ? "open" : "closed");
            JsonElement result = connection.patchRequest(path, gson.toJson((Object)request), ACCEPT_V3_JSON);
            GithubApiUtil.fromJson(result, GithubIssue.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't set issue state: " + user + "/" + repo + " - " + id + "@" + (open ? "open" : "closed"));
            throw e;
        }
    }

    @NotNull
    public static GithubCommitDetailed getCommit(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String sha) throws IOException {
        GithubCommitDetailed githubCommitDetailed;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(110);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(111);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(112);
        }
        if (sha == null) {
            GithubApiUtil.$$$reportNull$$$0(113);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/commits/" + sha;
            githubCommitDetailed = GithubApiUtil.load(connection, path, GithubCommitDetailed.class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get commit info: " + user + "/" + repo + " - " + sha);
            throw e;
        }
        if (githubCommitDetailed == null) {
            GithubApiUtil.$$$reportNull$$$0(114);
        }
        return githubCommitDetailed;
    }

    @NotNull
    public static List<GithubCommitComment> getCommitComments(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String sha) throws IOException {
        List<GithubCommitComment> list;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(115);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(116);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(117);
        }
        if (sha == null) {
            GithubApiUtil.$$$reportNull$$$0(118);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/commits/" + sha + "/comments";
            list = GithubApiUtil.loadAll(connection, path, GithubCommitComment[].class, ACCEPT_V3_JSON_HTML_MARKUP);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get commit comments: " + user + "/" + repo + " - " + sha);
            throw e;
        }
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(119);
        }
        return list;
    }

    @NotNull
    public static List<GithubCommitComment> getPullRequestComments(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, long id) throws IOException {
        List<GithubCommitComment> list;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(120);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(121);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(122);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls/" + id + "/comments";
            list = GithubApiUtil.loadAll(connection, path, GithubCommitComment[].class, ACCEPT_V3_JSON_HTML_MARKUP);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull request comments: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(123);
        }
        return list;
    }

    @NotNull
    public static GithubPullRequest getPullRequest(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, int id) throws IOException {
        GithubPullRequest githubPullRequest;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(124);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(125);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(126);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls/" + id;
            githubPullRequest = GithubApiUtil.load(connection, path, GithubPullRequest.class, ACCEPT_V3_JSON_HTML_MARKUP);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull request info: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (githubPullRequest == null) {
            GithubApiUtil.$$$reportNull$$$0(127);
        }
        return githubPullRequest;
    }

    @NotNull
    public static List<GithubPullRequest> getPullRequests(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo) throws IOException {
        List<GithubPullRequest> list;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(128);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(129);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(130);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls?" + PER_PAGE;
            list = GithubApiUtil.loadAll(connection, path, GithubPullRequest[].class, ACCEPT_V3_JSON_HTML_MARKUP);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull requests" + user + "/" + repo);
            throw e;
        }
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(131);
        }
        return list;
    }

    @NotNull
    public static GithubConnection.PagedRequest<GithubPullRequest> getPullRequests(@NotNull String user, @NotNull String repo) {
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(132);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(133);
        }
        String path = "/repos/" + user + "/" + repo + "/pulls?state=all&" + PER_PAGE;
        GithubConnection.ArrayPagedRequest<GithubPullRequest> arrayPagedRequest = new GithubConnection.ArrayPagedRequest<GithubPullRequest>(path, GithubPullRequest[].class, ACCEPT_V3_JSON_HTML_MARKUP);
        if (arrayPagedRequest == null) {
            GithubApiUtil.$$$reportNull$$$0(134);
        }
        return arrayPagedRequest;
    }

    @NotNull
    public static List<GithubCommit> getPullRequestCommits(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, long id) throws IOException {
        List<GithubCommit> list;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(135);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(136);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(137);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls/" + id + "/commits?" + PER_PAGE;
            list = GithubApiUtil.loadAll(connection, path, GithubCommit[].class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull request commits: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(138);
        }
        return list;
    }

    @NotNull
    public static List<GithubFile> getPullRequestFiles(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, long id) throws IOException {
        List<GithubFile> list;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(139);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(140);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(141);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls/" + id + "/files?" + PER_PAGE;
            list = GithubApiUtil.loadAll(connection, path, GithubFile[].class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull request files: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(142);
        }
        return list;
    }

    @NotNull
    public static List<GithubBranch> getRepoBranches(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo) throws IOException {
        List<GithubBranch> list;
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(143);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(144);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(145);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/branches?" + PER_PAGE;
            list = GithubApiUtil.loadAll(connection, path, GithubBranch[].class, ACCEPT_V3_JSON);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get repository branches: " + user + "/" + repo);
            throw e;
        }
        if (list == null) {
            GithubApiUtil.$$$reportNull$$$0(146);
        }
        return list;
    }

    @Nullable
    public static GithubRepo findForkByUser(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String forkUser) throws IOException {
        if (connection == null) {
            GithubApiUtil.$$$reportNull$$$0(147);
        }
        if (user == null) {
            GithubApiUtil.$$$reportNull$$$0(148);
        }
        if (repo == null) {
            GithubApiUtil.$$$reportNull$$$0(149);
        }
        if (forkUser == null) {
            GithubApiUtil.$$$reportNull$$$0(150);
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/forks?" + PER_PAGE;
            GithubConnection.ArrayPagedRequest request = new GithubConnection.ArrayPagedRequest(path, GithubRepo[].class, ACCEPT_V3_JSON);
            while (request.hasNext()) {
                for (GithubRepo fork : request.next(connection)) {
                    if (!StringUtil.equalsIgnoreCase((CharSequence)fork.getUserName(), (CharSequence)forkUser)) continue;
                    return fork;
                }
            }
            return null;
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't find fork by user: " + user + "/" + repo + " - " + forkUser);
            throw e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 29: 
            case 33: 
            case 35: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 54: 
            case 56: 
            case 60: 
            case 68: 
            case 72: 
            case 76: 
            case 84: 
            case 88: 
            case 92: 
            case 96: 
            case 101: 
            case 105: 
            case 114: 
            case 119: 
            case 123: 
            case 127: 
            case 131: 
            case 134: 
            case 138: 
            case 142: 
            case 146: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 29: 
            case 33: 
            case 35: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 54: 
            case 56: 
            case 60: 
            case 68: 
            case 72: 
            case 76: 
            case 84: 
            case 88: 
            case 92: 
            case 96: 
            case 101: 
            case 105: 
            case 114: 
            case 119: 
            case 123: 
            case 127: 
            case 131: 
            case 134: 
            case 138: 
            case 142: 
            case 146: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classT";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 29: 
            case 33: 
            case 35: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 54: 
            case 56: 
            case 60: 
            case 68: 
            case 72: 
            case 76: 
            case 84: 
            case 88: 
            case 92: 
            case 96: 
            case 101: 
            case 105: 
            case 114: 
            case 119: 
            case 123: 
            case 127: 
            case 131: 
            case 134: 
            case 138: 
            case 142: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/api/GithubApiUtil";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 18: 
            case 19: 
            case 21: 
            case 26: 
            case 30: 
            case 34: 
            case 36: 
            case 39: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 55: 
            case 57: 
            case 61: 
            case 64: 
            case 66: 
            case 69: 
            case 73: 
            case 77: 
            case 85: 
            case 89: 
            case 93: 
            case 97: 
            case 102: 
            case 106: 
            case 110: 
            case 115: 
            case 120: 
            case 124: 
            case 128: 
            case 135: 
            case 139: 
            case 143: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 22: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 23: 
            case 32: 
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "note";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 40: 
            case 51: 
            case 78: 
            case 90: 
            case 94: 
            case 98: 
            case 103: 
            case 107: 
            case 111: 
            case 116: 
            case 121: 
            case 125: 
            case 129: 
            case 132: 
            case 136: 
            case 140: 
            case 144: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 41: 
            case 63: 
            case 79: 
            case 91: 
            case 95: 
            case 99: 
            case 104: 
            case 108: 
            case 112: 
            case 117: 
            case 122: 
            case 126: 
            case 130: 
            case 133: 
            case 137: 
            case 141: 
            case 145: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 58: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 59: 
            case 75: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 65: 
            case 67: 
            case 100: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 71: 
            case 81: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "head";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 113: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sha";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forkUser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/api/GithubApiUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromJson";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAll";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "post";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenScopes";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopedToken";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "updateTokenScopes";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewScopedToken";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTokens";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getMasterToken";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksToken";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentUser";
                break;
            }
            case 47: 
            case 49: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserRepos";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableRepos";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchedRepos";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetailedRepoInfo";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getGist";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "createGist";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getForks";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "createPullRequest";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "createRepo";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssuesAssigned";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssuesQueried";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssue";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueComments";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommit";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitComments";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "getPullRequestComments";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getPullRequest";
                break;
            }
            case 131: 
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "getPullRequests";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "getPullRequestCommits";
                break;
            }
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "getPullRequestFiles";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromJson";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 29: 
            case 33: 
            case 35: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 54: 
            case 56: 
            case 60: 
            case 68: 
            case 72: 
            case 76: 
            case 84: 
            case 88: 
            case 92: 
            case 96: 
            case 101: 
            case 105: 
            case 114: 
            case 119: 
            case 123: 
            case 127: 
            case 131: 
            case 134: 
            case 138: 
            case 142: 
            case 146: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadAll";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "post";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "askForTwoFactorCodeSMS";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTokenScopes";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getScopedToken";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateTokenScopes";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getNewScopedToken";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAllTokens";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getMasterToken";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getTasksToken";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentUser";
                break;
            }
            case 46: 
            case 48: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getUserRepos";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableRepos";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getWatchedRepos";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getDetailedRepoInfo";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "deleteGithubRepository";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "deleteGist";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getGist";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createGist";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getForks";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "createPullRequest";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "createRepo";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getIssuesAssigned";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getIssuesQueried";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getIssue";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getIssueComments";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "setIssueState";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getCommit";
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "getCommitComments";
                break;
            }
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getPullRequestComments";
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getPullRequest";
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getPullRequests";
                break;
            }
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getPullRequestCommits";
                break;
            }
            case 139: 
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "getPullRequestFiles";
                break;
            }
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getRepoBranches";
                break;
            }
            case 147: 
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "findForkByUser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 29: 
            case 33: 
            case 35: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 54: 
            case 56: 
            case 60: 
            case 68: 
            case 72: 
            case 76: 
            case 84: 
            case 88: 
            case 92: 
            case 96: 
            case 101: 
            case 105: 
            case 114: 
            case 119: 
            case 123: 
            case 127: 
            case 131: 
            case 134: 
            case 138: 
            case 142: 
            case 146: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

