/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableMotionPointValue
extends AnimatableValue {
    protected float x;
    protected float y;
    protected float angle;

    protected AnimatableMotionPointValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableMotionPointValue(AnimationTarget animationTarget, float f, float f2, float f3) {
        super(animationTarget);
        this.x = f;
        this.y = f2;
        this.angle = f3;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f, AnimatableValue animatableValue3, int n) {
        AnimatableMotionPointValue animatableMotionPointValue;
        AnimatableMotionPointValue animatableMotionPointValue2 = animatableValue == null ? new AnimatableMotionPointValue(this.target) : (AnimatableMotionPointValue)animatableValue;
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.angle;
        int n2 = 1;
        if (animatableValue2 != null) {
            animatableMotionPointValue = (AnimatableMotionPointValue)animatableValue2;
            f2 += f * (animatableMotionPointValue.x - this.x);
            f3 += f * (animatableMotionPointValue.y - this.y);
            f4 += animatableMotionPointValue.angle;
            ++n2;
        }
        if (animatableValue3 != null && n != 0) {
            animatableMotionPointValue = (AnimatableMotionPointValue)animatableValue3;
            f2 += (float)n * animatableMotionPointValue.x;
            f3 += (float)n * animatableMotionPointValue.y;
            f4 += animatableMotionPointValue.angle;
            ++n2;
        }
        if (animatableMotionPointValue2.x != f2 || animatableMotionPointValue2.y != f3 || animatableMotionPointValue2.angle != (f4 /= (float)n2)) {
            animatableMotionPointValue2.x = f2;
            animatableMotionPointValue2.y = f3;
            animatableMotionPointValue2.angle = f4;
            animatableMotionPointValue2.hasChanged = true;
        }
        return animatableMotionPointValue2;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getAngle() {
        return this.angle;
    }

    @Override
    public boolean canPace() {
        return true;
    }

    @Override
    public float distanceTo(AnimatableValue animatableValue) {
        AnimatableMotionPointValue animatableMotionPointValue = (AnimatableMotionPointValue)animatableValue;
        float f = this.x - animatableMotionPointValue.x;
        float f2 = this.y - animatableMotionPointValue.y;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableMotionPointValue(this.target, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public String toStringRep() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AnimatableMotionPointValue.formatNumber(this.x));
        stringBuffer.append(',');
        stringBuffer.append(AnimatableMotionPointValue.formatNumber(this.y));
        stringBuffer.append(',');
        stringBuffer.append(AnimatableMotionPointValue.formatNumber(this.angle));
        stringBuffer.append("rad");
        return stringBuffer.toString();
    }
}

