/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.script.ScriptEventWrapper;
import org.apache.batik.script.rhino.RhinoInterpreter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

class EventTargetWrapper
extends NativeJavaObject {
    protected static WeakHashMap mapOfListenerMap;
    public static final String ADD_NAME = "addEventListener";
    public static final String ADDNS_NAME = "addEventListenerNS";
    public static final String REMOVE_NAME = "removeEventListener";
    public static final String REMOVENS_NAME = "removeEventListenerNS";
    protected RhinoInterpreter interpreter;

    EventTargetWrapper(Scriptable scriptable, EventTarget eventTarget, RhinoInterpreter rhinoInterpreter) {
        super(scriptable, (Object)eventTarget, null);
        this.interpreter = rhinoInterpreter;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = super.get(string, scriptable);
        if (string.equals(ADD_NAME)) {
            object = new FunctionAddProxy(this.interpreter, (Function)object, this.initMap());
        } else if (string.equals(REMOVE_NAME)) {
            object = new FunctionRemoveProxy((Function)object, this.initMap());
        } else if (string.equals(ADDNS_NAME)) {
            object = new FunctionAddNSProxy(this.interpreter, (Function)object, this.initMap());
        } else if (string.equals(REMOVENS_NAME)) {
            object = new FunctionRemoveNSProxy((Function)object, this.initMap());
        }
        return object;
    }

    public Map initMap() {
        WeakHashMap weakHashMap = null;
        if (mapOfListenerMap == null) {
            mapOfListenerMap = new WeakHashMap(10);
        }
        if ((weakHashMap = (WeakHashMap)mapOfListenerMap.get(this.unwrap())) == null) {
            weakHashMap = new WeakHashMap(2);
            mapOfListenerMap.put(this.unwrap(), weakHashMap);
        }
        return weakHashMap;
    }

    static class FunctionRemoveNSProxy
    extends FunctionProxy {
        protected Map listenerMap;

        FunctionRemoveNSProxy(Function function, Map map) {
            super(function);
            this.listenerMap = map;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[2] instanceof Function) {
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[2]);
                if (softReference == null) {
                    return Undefined.instance;
                }
                EventListener eventListener = (EventListener)softReference.get();
                if (eventListener == null) {
                    return Undefined.instance;
                }
                Class[] classArray = new Class[]{String.class, String.class, Function.class, Boolean.TYPE};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                AbstractNode abstractNode = (AbstractNode)nativeJavaObject.unwrap();
                abstractNode.removeEventListenerNS((String)objectArray[0], (String)objectArray[1], eventListener, (Boolean)objectArray[3]);
                return Undefined.instance;
            }
            if (objectArray[2] instanceof NativeObject) {
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[2]);
                if (softReference == null) {
                    return Undefined.instance;
                }
                EventListener eventListener = (EventListener)softReference.get();
                if (eventListener == null) {
                    return Undefined.instance;
                }
                Class[] classArray = new Class[]{String.class, String.class, Scriptable.class, Boolean.TYPE};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                AbstractNode abstractNode = (AbstractNode)nativeJavaObject.unwrap();
                abstractNode.removeEventListenerNS((String)objectArray[0], (String)objectArray[1], eventListener, (Boolean)objectArray[3]);
                return Undefined.instance;
            }
            return this.delegate.call(context, scriptable, scriptable2, objectArray);
        }
    }

    static class FunctionAddNSProxy
    extends FunctionProxy {
        protected Map listenerMap;
        protected RhinoInterpreter interpreter;

        FunctionAddNSProxy(RhinoInterpreter rhinoInterpreter, Function function, Map map) {
            super(function);
            this.listenerMap = map;
            this.interpreter = rhinoInterpreter;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[2] instanceof Function) {
                FunctionEventListener functionEventListener = new FunctionEventListener((Function)objectArray[2], this.interpreter);
                this.listenerMap.put(objectArray[2], new SoftReference<FunctionEventListener>(functionEventListener));
                Class[] classArray = new Class[]{String.class, String.class, Function.class, Boolean.TYPE, Object.class};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                AbstractNode abstractNode = (AbstractNode)nativeJavaObject.unwrap();
                abstractNode.addEventListenerNS((String)objectArray[0], (String)objectArray[1], functionEventListener, (Boolean)objectArray[3], objectArray[4]);
                return Undefined.instance;
            }
            if (objectArray[2] instanceof NativeObject) {
                HandleEventListener handleEventListener = new HandleEventListener((Scriptable)objectArray[2], this.interpreter);
                this.listenerMap.put(objectArray[2], new SoftReference<HandleEventListener>(handleEventListener));
                Class[] classArray = new Class[]{String.class, String.class, Scriptable.class, Boolean.TYPE, Object.class};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                AbstractNode abstractNode = (AbstractNode)nativeJavaObject.unwrap();
                abstractNode.addEventListenerNS((String)objectArray[0], (String)objectArray[1], handleEventListener, (Boolean)objectArray[3], objectArray[4]);
                return Undefined.instance;
            }
            return this.delegate.call(context, scriptable, scriptable2, objectArray);
        }
    }

    static class FunctionRemoveProxy
    extends FunctionProxy {
        public Map listenerMap;

        FunctionRemoveProxy(Function function, Map map) {
            super(function);
            this.listenerMap = map;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[1] instanceof Function) {
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[1]);
                if (softReference == null) {
                    return Undefined.instance;
                }
                EventListener eventListener = (EventListener)softReference.get();
                if (eventListener == null) {
                    return Undefined.instance;
                }
                Class[] classArray = new Class[]{String.class, Function.class, Boolean.TYPE};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                ((EventTarget)nativeJavaObject.unwrap()).removeEventListener((String)objectArray[0], eventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            if (objectArray[1] instanceof NativeObject) {
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[1]);
                if (softReference == null) {
                    return Undefined.instance;
                }
                EventListener eventListener = (EventListener)softReference.get();
                if (eventListener == null) {
                    return Undefined.instance;
                }
                Class[] classArray = new Class[]{String.class, Scriptable.class, Boolean.TYPE};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                ((EventTarget)nativeJavaObject.unwrap()).removeEventListener((String)objectArray[0], eventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            return this.delegate.call(context, scriptable, scriptable2, objectArray);
        }
    }

    static class FunctionAddProxy
    extends FunctionProxy {
        protected Map listenerMap;
        protected RhinoInterpreter interpreter;

        FunctionAddProxy(RhinoInterpreter rhinoInterpreter, Function function, Map map) {
            super(function);
            this.listenerMap = map;
            this.interpreter = rhinoInterpreter;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[1] instanceof Function) {
                EventListener eventListener = null;
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[1]);
                if (softReference != null) {
                    eventListener = (EventListener)softReference.get();
                }
                if (eventListener == null) {
                    eventListener = new FunctionEventListener((Function)objectArray[1], this.interpreter);
                    this.listenerMap.put(objectArray[1], new SoftReference<EventListener>(eventListener));
                }
                Class[] classArray = new Class[]{String.class, Function.class, Boolean.TYPE};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                ((EventTarget)nativeJavaObject.unwrap()).addEventListener((String)objectArray[0], eventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            if (objectArray[1] instanceof NativeObject) {
                EventListener eventListener = null;
                SoftReference softReference = (SoftReference)this.listenerMap.get(objectArray[1]);
                if (softReference != null) {
                    eventListener = (EventListener)softReference.get();
                }
                if (eventListener == null) {
                    eventListener = new HandleEventListener((Scriptable)objectArray[1], this.interpreter);
                    this.listenerMap.put(objectArray[1], new SoftReference<EventListener>(eventListener));
                }
                Class[] classArray = new Class[]{String.class, Scriptable.class, Boolean.TYPE};
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Context.jsToJava((Object)objectArray[i], (Class)classArray[i]);
                }
                ((EventTarget)nativeJavaObject.unwrap()).addEventListener((String)objectArray[0], eventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            return this.delegate.call(context, scriptable, scriptable2, objectArray);
        }
    }

    static abstract class FunctionProxy
    implements Function {
        protected Function delegate;

        public FunctionProxy(Function function) {
            this.delegate = function;
        }

        public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
            return this.delegate.construct(context, scriptable, objectArray);
        }

        public String getClassName() {
            return this.delegate.getClassName();
        }

        public Object get(String string, Scriptable scriptable) {
            return this.delegate.get(string, scriptable);
        }

        public Object get(int n, Scriptable scriptable) {
            return this.delegate.get(n, scriptable);
        }

        public boolean has(String string, Scriptable scriptable) {
            return this.delegate.has(string, scriptable);
        }

        public boolean has(int n, Scriptable scriptable) {
            return this.delegate.has(n, scriptable);
        }

        public void put(String string, Scriptable scriptable, Object object) {
            this.delegate.put(string, scriptable, object);
        }

        public void put(int n, Scriptable scriptable, Object object) {
            this.delegate.put(n, scriptable, object);
        }

        public void delete(String string) {
            this.delegate.delete(string);
        }

        public void delete(int n) {
            this.delegate.delete(n);
        }

        public Scriptable getPrototype() {
            return this.delegate.getPrototype();
        }

        public void setPrototype(Scriptable scriptable) {
            this.delegate.setPrototype(scriptable);
        }

        public Scriptable getParentScope() {
            return this.delegate.getParentScope();
        }

        public void setParentScope(Scriptable scriptable) {
            this.delegate.setParentScope(scriptable);
        }

        public Object[] getIds() {
            return this.delegate.getIds();
        }

        public Object getDefaultValue(Class clazz) {
            return this.delegate.getDefaultValue(clazz);
        }

        public boolean hasInstance(Scriptable scriptable) {
            return this.delegate.hasInstance(scriptable);
        }
    }

    static class HandleEventListener
    implements EventListener {
        public static final String HANDLE_EVENT = "handleEvent";
        public Scriptable scriptable;
        public Object[] array = new Object[1];
        public RhinoInterpreter interpreter;

        HandleEventListener(Scriptable scriptable, RhinoInterpreter rhinoInterpreter) {
            this.scriptable = scriptable;
            this.interpreter = rhinoInterpreter;
        }

        @Override
        public void handleEvent(Event event) {
            this.array[0] = event instanceof ScriptEventWrapper ? ((ScriptEventWrapper)((Object)event)).getEventObject() : event;
            ContextAction contextAction = new ContextAction(){

                public Object run(Context context) {
                    ScriptableObject.callMethod((Scriptable)HandleEventListener.this.scriptable, (String)HandleEventListener.HANDLE_EVENT, (Object[])HandleEventListener.this.array);
                    return null;
                }
            };
            this.interpreter.call(contextAction);
        }
    }

    static class FunctionEventListener
    implements EventListener {
        protected Function function;
        protected RhinoInterpreter interpreter;

        FunctionEventListener(Function function, RhinoInterpreter rhinoInterpreter) {
            this.function = function;
            this.interpreter = rhinoInterpreter;
        }

        @Override
        public void handleEvent(Event event) {
            Object object = event instanceof ScriptEventWrapper ? ((ScriptEventWrapper)((Object)event)).getEventObject() : event;
            this.interpreter.callHandler(this.function, object);
        }
    }
}

