/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels.code;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.reference.SoftReference;
import com.intellij.ui.Gray;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbMergeCellAboveAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbMergeCellBelowAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbRunCellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbRunCellBaseAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbRunCellInplaceAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbSplitCellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbToggleLineNumbersAction;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditorPanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodePanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;

public class IpnbCodeSourcePanel
extends IpnbPanel<JComponent, IpnbCodeCell>
implements IpnbEditorPanel {
    private Editor myEditor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final SoftReference<IpnbCodePanel> myParent;

    public IpnbCodeSourcePanel(@NotNull Project project, @NotNull IpnbCodePanel parent, @NotNull IpnbCodeCell cell) {
        if (project == null) {
            IpnbCodeSourcePanel.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            IpnbCodeSourcePanel.$$$reportNull$$$0(1);
        }
        if (cell == null) {
            IpnbCodeSourcePanel.$$$reportNull$$$0(2);
        }
        super(cell, (LayoutManager)new HorizontalLayout(5));
        this.myProject = project;
        this.myParent = new SoftReference((Object)parent);
        JComponent panel = this.createViewPanel();
        this.add(panel);
        this.addRightClickMenu();
    }

    public void addMouseListener(@NotNull EditorMouseListener listener) {
        if (listener == null) {
            IpnbCodeSourcePanel.$$$reportNull$$$0(3);
        }
        this.myEditor.addEditorMouseListener(listener);
    }

    @NotNull
    public IpnbCodePanel getIpnbCodePanel() {
        IpnbCodePanel ipnbCodePanel = (IpnbCodePanel)SoftReference.dereference(this.myParent);
        if (ipnbCodePanel == null) {
            IpnbCodeSourcePanel.$$$reportNull$$$0(4);
        }
        return ipnbCodePanel;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            IpnbCodeSourcePanel.$$$reportNull$$$0(5);
        }
        return editor;
    }

    public void dispose() {
        this.removeAll();
        EditorFactory.getInstance().releaseEditor(this.myEditor);
        this.myEditor = null;
    }

    @Override
    protected JComponent createViewPanel() {
        final JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(UIUtil.isUnderDarcula() ? IpnbEditorUtil.getBackground() : Gray._247);
        this.myEditor = IpnbEditorUtil.createPythonCodeEditor(this.myProject, this);
        final IpnbCodePanel codePanel = this.getIpnbCodePanel();
        JComponent component = this.myEditor.getComponent();
        final JComponent contentComponent = this.myEditor.getContentComponent();
        new IpnbRunCellAction(codePanel.getFileEditor()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("shift ENTER")), contentComponent);
        new IpnbRunCellInplaceAction(codePanel.getFileEditor()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl ENTER")), contentComponent);
        contentComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                Container parent = codePanel.getParent();
                if (keyCode == 27 && parent instanceof IpnbFilePanel) {
                    IpnbCodeSourcePanel.this.getIpnbCodePanel().setEditing(false);
                    IdeFocusManager.getGlobalInstance().requestFocus((Component)IpnbCodeSourcePanel.this.getIpnbCodePanel().getFileEditor().getIpnbFilePanel(), true);
                }
            }

            private void updateVisibleArea(boolean up) {
                IpnbFileEditor fileEditor = codePanel.getFileEditor();
                IpnbFilePanel ipnbPanel = fileEditor.getIpnbFilePanel();
                Rectangle rect = ipnbPanel.getVisibleRect();
                Rectangle cellBounds = IpnbCodeSourcePanel.this.getIpnbCodePanel().getBounds();
                JScrollPane scrollPane = fileEditor.getScrollPane();
                int y = cellBounds.y + ((IpnbCodeSourcePanel)IpnbCodeSourcePanel.this).myEditor.visualPositionToXY((VisualPosition)((IpnbCodeSourcePanel)IpnbCodeSourcePanel.this).myEditor.getCaretModel().getVisualPosition()).y;
                int delta = IpnbCodeSourcePanel.this.myEditor.getLineHeight() * 2;
                if ((double)y <= rect.getY() && up) {
                    scrollPane.getVerticalScrollBar().setValue(y);
                }
                if ((double)(y + delta) > rect.getY() + rect.getHeight() && !up) {
                    scrollPane.getVerticalScrollBar().setValue(y - rect.height + delta);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int keyCode = e.getKeyCode();
                Container parent = codePanel.getParent();
                int height = IpnbCodeSourcePanel.this.myEditor.getLineHeight() * Math.max(IpnbCodeSourcePanel.this.myEditor.getDocument().getLineCount(), 1) + 10;
                contentComponent.setPreferredSize(new Dimension(parent.getWidth() - 300, height));
                panel.setPreferredSize(new Dimension(parent.getWidth() - 300, height));
                if (parent instanceof IpnbFilePanel) {
                    IpnbFilePanel ipnbFilePanel = (IpnbFilePanel)parent;
                    if (keyCode == 10 && 2 == e.getModifiers()) {
                        IpnbRunCellBaseAction.runCell(ipnbFilePanel, false);
                    } else if (keyCode == 10 && 64 == e.getModifiersEx()) {
                        IpnbRunCellBaseAction.runCell(ipnbFilePanel, true);
                    } else if (keyCode == 38 || keyCode == 40 || keyCode == 34 || keyCode == 33) {
                        this.updateVisibleArea(keyCode == 38 || keyCode == 33);
                    }
                }
            }
        });
        contentComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (128 == e.getModifiersEx()) {
                    return;
                }
                Container ipnbFilePanel = codePanel.getParent();
                if (ipnbFilePanel instanceof IpnbFilePanel) {
                    ((IpnbFilePanel)ipnbFilePanel).setSelectedCell(codePanel, true);
                    codePanel.switchToEditing();
                }
                UIUtil.requestFocus((JComponent)contentComponent);
            }
        });
        panel.add(component);
        contentComponent.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Container parent = codePanel.getParent();
                if (parent != null && IpnbCodeSourcePanel.this.myEditor != null) {
                    int height = IpnbCodeSourcePanel.this.myEditor.getLineHeight() * Math.max(IpnbCodeSourcePanel.this.myEditor.getDocument().getLineCount(), 1) + 10;
                    contentComponent.setPreferredSize(new Dimension(parent.getWidth() - 300, height));
                    panel.setPreferredSize(new Dimension(parent.getWidth() - 300, height));
                }
            }
        });
        contentComponent.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent e) {
                Container parent = codePanel.getParent();
                Component component = e.getChanged();
                if (parent != null && component instanceof IpnbFilePanel && IpnbCodeSourcePanel.this.myEditor != null) {
                    int height = IpnbCodeSourcePanel.this.myEditor.getLineHeight() * Math.max(IpnbCodeSourcePanel.this.myEditor.getDocument().getLineCount(), 1) + 10;
                    contentComponent.setPreferredSize(new Dimension(parent.getWidth() - 300, height));
                    panel.setPreferredSize(new Dimension(parent.getWidth() - 300, height));
                    panel.revalidate();
                    panel.repaint();
                }
            }
        });
        return panel;
    }

    @Override
    protected void addRightClickMenu() {
        this.addMouseListener((EditorMouseListener)new EditorMouseAdapter(){

            public void mousePressed(EditorMouseEvent e) {
                MouseEvent mouseEvent = e.getMouseEvent();
                if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    ListPopup menu = IpnbCodeSourcePanel.this.createPopupMenu(new DefaultActionGroup(new AnAction[]{new IpnbMergeCellAboveAction(), new IpnbMergeCellBelowAction(), new IpnbSplitCellAction(), new IpnbToggleLineNumbersAction((IpnbCodePanel)IpnbCodeSourcePanel.this.myParent.get())}));
                    menu.show(RelativePoint.fromScreen((Point)e.getMouseEvent().getLocationOnScreen()));
                }
            }
        });
    }

    @Override
    public ListPopup createPopupMenu(@NotNull DefaultActionGroup group) {
        if (group == null) {
            IpnbCodeSourcePanel.$$$reportNull$$$0(6);
        }
        DataContext context = DataManager.getInstance().getDataContext((Component)this);
        return JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.MNEMONICS, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodeSourcePanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodeSourcePanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIpnbCodePanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addMouseListener";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPopupMenu";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

