/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.run;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.DebugAwareConfiguration;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.run.IpnbCommandLineState;
import org.jetbrains.plugins.ipnb.run.IpnbConfigurationEditor;

public class IpnbRunConfiguration
extends AbstractPythonRunConfiguration<IpnbRunConfiguration>
implements DebugAwareConfiguration {
    @NonNls
    private static final String ATTR_ADDITIONAL_OPTIONS = "additionalOptions";
    @NonNls
    private static final String ATTR_HOST = "ipnbHost";
    @NonNls
    private static final String ATTR_PORT = "ipnbPort";
    private String myAdditionalOptions = "";
    private String myHost = null;
    private String myPort = null;
    private String myToken;

    public IpnbRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
        this.setUnbufferedEnv();
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Module module;
        if (executor == null) {
            IpnbRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            IpnbRunConfiguration.$$$reportNull$$$0(1);
        }
        if ((module = this.getConfigurationModule().getModule()) == null) {
            throw new ExecutionException("Please select Python module");
        }
        return new IpnbCommandLineState(this, env);
    }

    protected SettingsEditor<IpnbRunConfiguration> createConfigurationEditor() {
        return new IpnbConfigurationEditor(this);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            IpnbRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        this.myAdditionalOptions = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_ADDITIONAL_OPTIONS);
        String host = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_HOST);
        this.myHost = host != null && host.length() > 0 ? host : null;
        String port = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_PORT);
        this.myPort = port != null && port.length() > 0 ? port : null;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            IpnbRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_ADDITIONAL_OPTIONS, (String)this.myAdditionalOptions);
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_HOST, (String)this.myHost);
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_PORT, (String)this.myPort);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        PyPackage jupyterPackage;
        super.checkConfiguration();
        Module module = this.getConfigurationModule().getModule();
        if (module == null) {
            throw new RuntimeConfigurationError("Please select Python module");
        }
        if (StringUtil.isEmptyOrSpaces((String)this.getHost())) {
            throw new RuntimeConfigurationError("Please select valid host");
        }
        if (StringUtil.isEmptyOrSpaces((String)this.getPort())) {
            throw new RuntimeConfigurationError("Please select valid port");
        }
        final Sdk sdk = this.getSdk();
        if (sdk == null) {
            return;
        }
        if (RemoteSdkCredentialsHolder.isRemoteSdk((String)sdk.getHomePath())) {
            throw new RuntimeConfigurationError("Please select local python interpreter");
        }
        List packages = PyPackageManager.getInstance((Sdk)sdk).getPackages();
        PyPackage ipythonPackage = packages != null ? PyPackageUtil.findPackage((List)packages, (String)"ipython") : null;
        PyPackage pyPackage = jupyterPackage = packages != null ? PyPackageUtil.findPackage((List)packages, (String)"jupyter") : null;
        if (ipythonPackage == null && jupyterPackage == null) {
            throw new RuntimeConfigurationError("Install Jupyter Notebook to the interpreter of the current project.", () -> ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.getProject(), "Installing Jupyter", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        String version = sdk.getVersionString();
                        if (version != null) {
                            LanguageLevel level = LanguageLevel.fromPythonVersion((String)version);
                            if (level.isAtLeast(LanguageLevel.PYTHON33)) {
                                PyPackageManager.getInstance((Sdk)sdk).install("jupyter");
                            } else {
                                PyPackageManager.getInstance((Sdk)sdk).install((List)Lists.newArrayList((Object[])new PyRequirement[]{PyRequirement.fromLine((String)"ipython==5"), PyRequirement.fromLine((String)"jupyter")}), (List)Lists.newArrayList());
                            }
                        }
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ipnb/run/IpnbRunConfiguration$1", "run"));
                }
            }));
        }
    }

    public String getAdditionalOptions() {
        return this.myAdditionalOptions;
    }

    public void setAdditionalOptions(String additionalOptions) {
        this.myAdditionalOptions = additionalOptions;
    }

    public String getUrl() {
        return "http://" + this.myHost + ":" + this.myPort;
    }

    public String getHost() {
        return this.myHost;
    }

    public String getPort() {
        return this.myPort;
    }

    public void setHost(@Nullable String host) {
        this.myHost = host;
    }

    public void setPort(@Nullable String port) {
        this.myPort = port;
    }

    public void setToken(String token) {
        this.myToken = token;
    }

    public String getToken() {
        return this.myToken;
    }

    public boolean canRunUnderDebug() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ipnb/run/IpnbRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

