/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisScopeUtil;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.HashSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAnalysisAction
extends AnAction {
    private static final String DIMENSION_KEY_PREFIX = "ANALYSIS_DLG_";
    private final String myTitle;
    private final String myAnalysisNoon;

    protected BaseAnalysisAction(String title, String analysisNoon) {
        this.myTitle = title;
        this.myAnalysisNoon = analysisNoon;
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && !DumbService.isDumb((Project)project) && this.getInspectionScope(e.getDataContext(), project) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        PsiElement element;
        AnalysisUIOptions uiOptions;
        boolean rememberScope;
        Module module2;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DataContext dataContext = e.getDataContext();
        AnalysisScope scope = this.getInspectionScope(dataContext, project);
        if (scope == null) {
            return;
        }
        String title = AnalysisScopeBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{this.myTitle});
        String noon = AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{this.myAnalysisNoon});
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(title, noon, project, scope, module2 = BaseAnalysisAction.getModuleFromContext(dataContext), rememberScope = ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()), uiOptions = AnalysisUIOptions.getInstance(project), element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)){

            protected String getDimensionServiceKey() {
                return BaseAnalysisAction.DIMENSION_KEY_PREFIX + ((Object)((Object)this)).getClass().getName();
            }

            @Override
            protected JComponent getAdditionalActionSettings(Project project) {
                return BaseAnalysisAction.this.getAdditionalActionSettings(project, this);
            }

            protected String getHelpId() {
                return BaseAnalysisAction.this.getHelpTopic();
            }
        };
        if (!dlg.showAndGet()) {
            this.canceled();
            return;
        }
        int oldScopeType = uiOptions.SCOPE_TYPE;
        scope = dlg.getScope(uiOptions, scope, project, module2);
        if (!rememberScope) {
            uiOptions.SCOPE_TYPE = oldScopeType;
        }
        uiOptions.ANALYZE_TEST_SOURCES = dlg.isInspectTestSources();
        FileDocumentManager.getInstance().saveAllDocuments();
        this.analyze(project, scope);
    }

    protected String getHelpTopic() {
        return "reference.dialogs.analyzeDependencies.scope";
    }

    protected void canceled() {
    }

    protected abstract void analyze(@NotNull Project var1, @NotNull AnalysisScope var2);

    @Nullable
    private AnalysisScope getInspectionScope(@NotNull DataContext dataContext, @NotNull Project project) {
        AnalysisScope scope;
        if (dataContext == null) {
            BaseAnalysisAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BaseAnalysisAction.$$$reportNull$$$0(1);
        }
        if ((scope = BaseAnalysisAction.getFileScopeFromInspectionView(dataContext)) != null) {
            return scope;
        }
        scope = this.getInspectionScopeImpl(dataContext, project);
        return scope.getScopeType() != 6 ? scope : null;
    }

    @NotNull
    private AnalysisScope getInspectionScopeImpl(@NotNull DataContext dataContext, @NotNull Project project) {
        Project projectContext;
        if (dataContext == null) {
            BaseAnalysisAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            BaseAnalysisAction.$$$reportNull$$$0(3);
        }
        if ((projectContext = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext)) != null) {
            AnalysisScope analysisScope = new AnalysisScope(projectContext);
            if (analysisScope == null) {
                BaseAnalysisAction.$$$reportNull$$$0(4);
            }
            return analysisScope;
        }
        AnalysisScope analysisScope = (AnalysisScope)AnalysisScopeUtil.KEY.getData(dataContext);
        if (analysisScope != null) {
            AnalysisScope analysisScope2 = analysisScope;
            if (analysisScope2 == null) {
                BaseAnalysisAction.$$$reportNull$$$0(5);
            }
            return analysisScope2;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile != null && psiFile.getManager().isInProject((PsiElement)psiFile)) {
            PsiDirectory psiDirectory;
            VirtualFile jarRoot;
            VirtualFile file2 = psiFile.getVirtualFile();
            if (file2 != null && file2.isValid() && file2.getFileType() instanceof ArchiveFileType && this.acceptNonProjectDirectories() && (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(file2)) != null && (psiDirectory = psiFile.getManager().findDirectory(jarRoot)) != null) {
                AnalysisScope analysisScope3 = new AnalysisScope(psiDirectory);
                if (analysisScope3 == null) {
                    BaseAnalysisAction.$$$reportNull$$$0(6);
                }
                return analysisScope3;
            }
            AnalysisScope analysisScope4 = new AnalysisScope(psiFile);
            if (analysisScope4 == null) {
                BaseAnalysisAction.$$$reportNull$$$0(7);
            }
            return analysisScope4;
        }
        VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (virtualFiles != null) {
            PsiDirectory psiDirectory;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            if (virtualFiles.length == 1 && (psiDirectory = PsiManager.getInstance((Project)project).findDirectory(virtualFiles[0])) != null && (this.acceptNonProjectDirectories() || psiDirectory.getManager().isInProject((PsiElement)psiDirectory))) {
                AnalysisScope analysisScope5 = new AnalysisScope(psiDirectory);
                if (analysisScope5 == null) {
                    BaseAnalysisAction.$$$reportNull$$$0(8);
                }
                return analysisScope5;
            }
            HashSet<VirtualFile> files = new HashSet<VirtualFile>();
            for (VirtualFile vFile : virtualFiles) {
                if (!fileIndex.isInContent(vFile)) continue;
                files.add(vFile);
            }
            AnalysisScope analysisScope6 = new AnalysisScope(project, files);
            if (analysisScope6 == null) {
                BaseAnalysisAction.$$$reportNull$$$0(9);
            }
            return analysisScope6;
        }
        Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (moduleContext != null) {
            AnalysisScope analysisScope7 = new AnalysisScope(moduleContext);
            if (analysisScope7 == null) {
                BaseAnalysisAction.$$$reportNull$$$0(10);
            }
            return analysisScope7;
        }
        Module[] modulesArray = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modulesArray != null) {
            AnalysisScope analysisScope8 = new AnalysisScope(modulesArray);
            if (analysisScope8 == null) {
                BaseAnalysisAction.$$$reportNull$$$0(11);
            }
            return analysisScope8;
        }
        AnalysisScope analysisScope9 = new AnalysisScope(project);
        if (analysisScope9 == null) {
            BaseAnalysisAction.$$$reportNull$$$0(12);
        }
        return analysisScope9;
    }

    protected boolean acceptNonProjectDirectories() {
        return false;
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog2) {
        return null;
    }

    private static AnalysisScope getFileScopeFromInspectionView(DataContext dataContext) {
        AnalysisScope scope;
        int type;
        InspectionResultsView inspectionView = (InspectionResultsView)dataContext.getData(InspectionResultsView.DATA_KEY);
        if (inspectionView != null && (type = (scope = inspectionView.getScope()).getScopeType()) != 4 && type != 1 && scope.isValid()) {
            return scope;
        }
        return null;
    }

    @Nullable
    private static Module getModuleFromContext(@NotNull DataContext dataContext) {
        AnalysisScope scope;
        InspectionResultsView inspectionView;
        if (dataContext == null) {
            BaseAnalysisAction.$$$reportNull$$$0(13);
        }
        if ((inspectionView = (InspectionResultsView)dataContext.getData(InspectionResultsView.DATA_KEY)) != null && (scope = inspectionView.getScope()).getScopeType() == 4 && scope.isValid()) {
            return scope.getModule();
        }
        return (Module)dataContext.getData(LangDataKeys.MODULE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/BaseAnalysisAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/BaseAnalysisAction";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionScopeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionScopeImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getModuleFromContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

