/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.BasePainter;
import com.intellij.codeEditor.printing.PrintManager;
import com.intellij.codeEditor.printing.TextPainter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiFile;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.List;

class MultiFilePainter
extends BasePainter {
    private final List<PsiFile> myFilesList;
    private final boolean myEvenNumberOfPagesPerFile;
    private int myFileIndex = 0;
    private int myStartPageIndex = 0;
    private TextPainter myTextPainter = null;
    private int myLargestPrintedPage = -1;

    public MultiFilePainter(List<PsiFile> filesList, boolean evenNumberOfPagesPerFile) {
        this.myFilesList = filesList;
        this.myEvenNumberOfPagesPerFile = evenNumberOfPagesPerFile;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.myProgress.isCanceled()) {
            return 1;
        }
        while (this.myFileIndex < this.myFilesList.size()) {
            if (this.myTextPainter == null) {
                PsiFile psiFile = this.myFilesList.get(this.myFileIndex);
                this.myTextPainter = PrintManager.initTextPainter(psiFile);
            }
            if (this.myTextPainter != null) {
                this.myTextPainter.setProgress(this.myProgress);
                int ret = 0;
                try {
                    ret = this.myTextPainter.print(g, pageFormat, pageIndex - this.myStartPageIndex);
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
                if (this.myProgress.isCanceled()) {
                    return 1;
                }
                if (ret == 0) {
                    this.myLargestPrintedPage = pageIndex;
                    return 0;
                }
                if (this.myEvenNumberOfPagesPerFile && pageIndex == this.myLargestPrintedPage + 1 && pageIndex % 2 == 1 && this.myFileIndex < this.myFilesList.size() - 1) {
                    return 0;
                }
                this.myTextPainter.dispose();
                this.myTextPainter = null;
                this.myStartPageIndex = pageIndex;
            }
            ++this.myFileIndex;
            this.myLargestPrintedPage = -1;
        }
        return 1;
    }

    @Override
    void dispose() {
        if (this.myTextPainter != null) {
            this.myTextPainter.dispose();
            this.myTextPainter = null;
        }
    }
}

