/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlSlashTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile editedFile, FileType fileType) {
        if (c == '/' && XmlGtTypedHandler.fileContainsXmlLanguage(editedFile)) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            int offset = editor.getCaretModel().getOffset();
            if (file2 == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            FileViewProvider provider = file2.getViewProvider();
            PsiElement element = provider.findElementAt(offset, XMLLanguage.class);
            if (element instanceof XmlToken) {
                ASTNode parentNode;
                ASTNode child;
                IElementType tokenType = ((XmlToken)element).getTokenType();
                if (tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END && offset == element.getTextOffset()) {
                    editor.getCaretModel().moveToOffset(offset + 1);
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    return TypedHandlerDelegate.Result.STOP;
                }
                if (tokenType == XmlTokenType.XML_TAG_END && offset == element.getTextOffset() && (child = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(parentNode = element.getParent().getNode())) != null && offset + 1 == child.getTextRange().getStartOffset()) {
                    editor.getDocument().replaceString(offset + 1, parentNode.getTextRange().getEndOffset(), (CharSequence)"");
                }
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile editedFile) {
        if (editor == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(0);
        }
        if (editedFile == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(1);
        }
        if (!WebEditorOptions.getInstance().isAutoCloseTag()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c == '/' && XmlGtTypedHandler.fileContainsXmlLanguage(editedFile)) {
            PsiElement element2;
            XmlTag tag;
            int offset;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            FileViewProvider provider = file2.getViewProvider();
            PsiElement element = provider.findElementAt((offset = editor.getCaretModel().getOffset()) - 1, XMLLanguage.class);
            if (element == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (!(element.getLanguage() instanceof XMLLanguage)) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            ASTNode prevLeaf = element.getNode();
            if (prevLeaf == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            String prevLeafText = prevLeaf.getText();
            if ("</".equals(prevLeafText) && prevLeaf.getElementType() == XmlTokenType.XML_END_TAG_START && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class)) != null && StringUtil.isNotEmpty((String)tag.getName()) && TreeUtil.findSibling(prevLeaf, XmlTokenType.XML_NAME) == null) {
                PsiElement element1;
                if (provider instanceof MultiplePsiFilesPerDocumentFileViewProvider && (element1 = SingleRootFileViewProvider.findElementAt((PsiElement)file2, offset - 1)) != null) {
                    XmlTag tag1 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element1, XmlTag.class);
                    if (XmlSlashTypedHandler.shouldReplace(tag, tag1, offset)) {
                        tag = tag1;
                    } else {
                        tag1 = (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element1.getParent(), XmlTag.class);
                        if (XmlSlashTypedHandler.shouldReplace(tag, tag1, offset)) {
                            tag = tag1;
                        }
                    }
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(tag.getName() + ">"), (boolean)false);
                XmlSlashTypedHandler.autoIndent(editor);
                return TypedHandlerDelegate.Result.STOP;
            }
            if (!"/".equals(prevLeafText.trim())) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            while ((prevLeaf = TreeUtil.prevLeaf(prevLeaf)) != null && prevLeaf.getElementType() == XmlTokenType.XML_WHITE_SPACE) {
            }
            if (prevLeaf instanceof OuterLanguageElement) {
                element = file2.getViewProvider().findElementAt(offset - 1, file2.getLanguage());
                ASTNode aSTNode = prevLeaf = element != null ? element.getNode() : null;
                while ((prevLeaf = TreeUtil.prevLeaf(prevLeaf)) != null && prevLeaf.getElementType() == XmlTokenType.XML_WHITE_SPACE) {
                }
            }
            if (prevLeaf == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)prevLeaf.getPsi(), XmlTag.class);
            if (tag == null && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(element2 = provider.findElementAt(prevLeaf.getStartOffset(), XMLLanguage.class)), XmlTag.class)) == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            XmlToken startToken = XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_START_TAG_START);
            if (startToken == null || !startToken.getText().equals("<")) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_TAG_END) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_EMPTY_ELEMENT_END) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)">", (boolean)false);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean shouldReplace(XmlTag tag, XmlTag tag1, int offset) {
        if (tag1 == null || tag1 == tag || tag1.getTextOffset() <= tag.getTextOffset()) {
            return false;
        }
        if (XmlSlashTypedHandler.hasUnclosedParent(tag1)) {
            return true;
        }
        if (XmlUtil.getTokenOfType((PsiElement)tag1, XmlTokenType.XML_EMPTY_ELEMENT_END) != null) {
            return false;
        }
        XmlToken element = XmlTagUtil.getEndTagNameElement((XmlTag)tag1);
        return element != null && element.getTextOffset() > offset;
    }

    private static boolean hasUnclosedParent(XmlTag tag) {
        String name = tag.getName();
        while (tag != null) {
            if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_EMPTY_ELEMENT_END) == null && XmlTagUtil.getEndTagNameElement((XmlTag)tag) == null && name.equals(tag.getName())) {
                return true;
            }
            tag = tag.getParentTag();
        }
        return false;
    }

    private static void autoIndent(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(2);
        }
        if ((project = editor.getProject()) != null) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = editor.getDocument();
            documentManager.commitDocument(document);
            int lineOffset = document.getLineStartOffset(document.getLineNumber(editor.getCaretModel().getOffset()));
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, lineOffset);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editedFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlSlashTypedHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "charTyped";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "autoIndent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

