/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.longLine;

import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.longLine.LongLineInspectionPolicy;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.HyperlinkLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongLineInspection
extends LocalInspectionTool {
    @Nullable
    public JComponent createOptionsPanel() {
        HyperlinkLabel codeStyleHyperlink = new HyperlinkLabel("Edit Code Style settings");
        codeStyleHyperlink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataManager.getInstance().getDataContextFromFocus().doWhenDone(context -> {
                    if (context != null) {
                        Settings settings = (Settings)Settings.KEY.getData(context);
                        if (settings != null) {
                            settings.select((Configurable)settings.find(CodeStyleSchemesConfigurable.class));
                        } else {
                            ShowSettingsUtil.getInstance().showSettingsDialog((Project)CommonDataKeys.PROJECT.getData(context), CodeStyleSchemesConfigurable.class);
                        }
                    }
                });
            }
        });
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)codeStyleHyperlink, "North");
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LongLineInspection.$$$reportNull$$$0(0);
        }
        PsiFile file2 = holder.getFile();
        final int codeStyleRightMargin = CodeStyleSettingsManager.getSettings((Project)holder.getProject()).getRightMargin(file2.getLanguage());
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile instanceof VirtualFileWindow) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                LongLineInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        final Document document = FileDocumentManager.getInstance().getDocument(vFile);
        if (document == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                LongLineInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                int length = element.getTextLength();
                if (element.getTextLength() != 0 && element.getFirstChild() == null && !LongLineInspection.ignoreFor(element)) {
                    int offset = element.getTextOffset();
                    int endOffset = offset + length;
                    int startLine = document.getLineNumber(offset);
                    if (offset > document.getLineStartOffset(startLine) + codeStyleRightMargin) {
                        ++startLine;
                    }
                    int endLine = document.getLineNumber(endOffset - 1);
                    for (int l = startLine; l <= endLine; ++l) {
                        int highlightingEndOffset;
                        int highlightingStartOffset;
                        int lineMarginOffset;
                        int lineEndOffset = document.getLineEndOffset(l);
                        if (lineEndOffset <= (lineMarginOffset = document.getLineStartOffset(l) + codeStyleRightMargin) || (highlightingStartOffset = lineMarginOffset - offset) >= (highlightingEndOffset = Math.min(endOffset, lineEndOffset) - offset)) continue;
                        TextRange exceedingRange = new TextRange(highlightingStartOffset, highlightingEndOffset);
                        holder.registerProblem(element, exceedingRange, String.format("Line is longer than allowed by code style (> %s columns)", codeStyleRightMargin), new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            LongLineInspection.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    private static boolean ignoreFor(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        for (LongLineInspectionPolicy policy : (LongLineInspectionPolicy[])LongLineInspectionPolicy.EP_NAME.getExtensions()) {
            if (!policy.ignoreLongLineFor(element)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/longLine/LongLineInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/longLine/LongLineInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

