/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\rJ\u0006\u0010\u0014\u001a\u00020\rJ\b\u0010\u0015\u001a\u00020\rH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\r0\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/dvcs/MultiRootMessage;", "", "project", "Lcom/intellij/openapi/project/Project;", "allRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "html", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Z)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "lineSeparator", "", "messages", "Ljava/util/LinkedHashMap;", "kotlin.jvm.PlatformType", "append", "root", "message", "asString", "toString", "dvcs-impl"})
public final class MultiRootMessage {
    private final Logger LOG;
    private final LinkedHashMap<VirtualFile, String> messages;
    private final String lineSeparator;
    private final Project project;
    private final Collection<VirtualFile> allRoots;

    @NotNull
    public final MultiRootMessage append(@NotNull VirtualFile root, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (!this.allRoots.contains(root)) {
            this.LOG.error("The root " + root.getPath() + " is unexpected: " + this.allRoots);
            return this;
        }
        if (this.messages.containsKey(root)) {
            this.LOG.error("Duplicate root " + root.getPath() + " reporting message [" + message + ']');
        }
        this.messages.put(root, message);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String asString() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        if (this.messages.isEmpty()) {
            return "";
        }
        if (this.allRoots.size() == 1) {
            Object object = CollectionsKt.first((Iterable)this.messages.values());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"messages.values.first()");
            return (String)object;
        }
        if (this.messages.size() == 1) {
            void root;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)CollectionsKt.first((Iterable)this.messages.entrySet());
            VirtualFile virtualFile = (VirtualFile)entry2.getKey();
            entry2 = entry;
            String message = (String)entry2.getValue();
            return "" + message + " in " + VcsImplUtil.getShortVcsRootName(this.project, (VirtualFile)root);
        }
        Iterable iterable = $receiver$iv = (Iterable)this.messages.keySet();
        Map destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            String string;
            VirtualFile it = (VirtualFile)element$iv$iv;
            if (this.messages.get(it) == null) {
                Intrinsics.throwNpe();
            }
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            Map $receiver$iv$iv$iv = destination$iv$iv;
            String key$iv$iv = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map grouped = destination$iv$iv;
        if (grouped.size() == 1 && this.allRoots.size() == this.messages.size()) {
            Object object = CollectionsKt.first((Iterable)this.messages.values());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"messages.values.first()");
            return (String)object;
        }
        return CollectionsKt.joinToString$default((Iterable)grouped.keySet(), (CharSequence)this.lineSeparator, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this, grouped){
            final /* synthetic */ MultiRootMessage this$0;
            final /* synthetic */ Map $grouped;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke(@NotNull String it) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                V v = this.$grouped.get(it);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                Iterable iterable = $receiver$iv = (Iterable)v;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it2;
                    VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    String string = VcsImplUtil.getShortVcsRootName(MultiRootMessage.access$getProject$p(this.this$0), (VirtualFile)it2);
                    collection.add(string);
                }
                List shortRootNames = (List)destination$iv$iv;
                return "" + it + " in " + DvcsUtil.joinWithAnd(shortRootNames, 5);
            }
            {
                this.this$0 = multiRootMessage;
                this.$grouped = map2;
                super(1);
            }
        }), (int)30, null);
    }

    @NotNull
    public String toString() {
        String string = this.messages.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"messages.toString()");
        return string;
    }

    public MultiRootMessage(@NotNull Project project, @NotNull Collection<? extends VirtualFile> allRoots, boolean html) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(allRoots, (String)"allRoots");
        this.project = project;
        this.allRoots = allRoots;
        this.LOG = Logger.getInstance(MultiRootMessage.class);
        this.messages = ContainerUtil.newLinkedHashMap();
        this.lineSeparator = html ? "<br/>\n" : "\n";
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(MultiRootMessage $this) {
        return $this.project;
    }
}

