/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private static final Comparator<RunLineMarkerContributor.Info> COMPARATOR = (a, b) -> {
        if (b.shouldReplace((RunLineMarkerContributor.Info)a)) {
            return 1;
        }
        if (a.shouldReplace((RunLineMarkerContributor.Info)b)) {
            return -1;
        }
        return 0;
    };

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        RunLineMarkerContributor.Info info2;
        if (element == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(0);
        }
        List contributors = RunLineMarkerContributor.EXTENSION.allForLanguage(element.getLanguage());
        Icon icon = null;
        List infos = null;
        for (RunLineMarkerContributor contributor : contributors) {
            info2 = contributor.getInfo(element);
            if (info2 == null) continue;
            if (icon == null) {
                icon = info2.icon;
            }
            if (infos == null) {
                infos = new SmartList();
            }
            infos.add(info2);
        }
        if (icon == null) {
            return null;
        }
        if (infos.size() > 1) {
            Collections.sort(infos, COMPARATOR);
            RunLineMarkerContributor.Info first = (RunLineMarkerContributor.Info)infos.get(0);
            Iterator it = infos.iterator();
            while (it.hasNext()) {
                info2 = (RunLineMarkerContributor.Info)it.next();
                if (info2 == first || !first.shouldReplace(info2)) continue;
                it.remove();
            }
        }
        final DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (RunLineMarkerContributor.Info info2 : infos) {
            for (AnAction action : info2.actions) {
                actionGroup.add((AnAction)new LineMarkerActionWrapper(element, action));
            }
            if (info2 == infos.get(infos.size() - 1)) continue;
            actionGroup.add((AnAction)new Separator());
        }
        List finalInfos = infos;
        Function tooltipProvider = element1 -> {
            StringBuilder tooltip = new StringBuilder();
            for (RunLineMarkerContributor.Info info : finalInfos) {
                String string;
                if (info.tooltipProvider == null || (string = info.tooltipProvider.apply((PsiElement)element1)) == null) continue;
                if (tooltip.length() != 0) {
                    tooltip.append("\n");
                }
                tooltip.append(string);
            }
            return tooltip.length() == 0 ? null : tooltip.toString();
        };
        return new LineMarkerInfo<PsiElement>(element, element.getTextRange(), icon, 11, tooltipProvider, null, GutterIconRenderer.Alignment.CENTER){

            public GutterIconRenderer createGutterRenderer() {
                return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                    public AnAction getClickAction() {
                        return null;
                    }

                    public boolean isNavigateAction() {
                        return true;
                    }

                    public ActionGroup getPopupMenuActions() {
                        return actionGroup;
                    }
                };
            }
        };
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(2);
        }
    }

    @NotNull
    public String getName() {
        if ("Run line marker" == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return "Run line marker";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.RunConfigurations.TestState.Run;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/lineMarker/RunLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/lineMarker/RunLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

