/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.impl.DiffWindowBase;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestTreeViewAction;
import com.intellij.execution.testframework.actions.TestDiffRequestProcessor;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewAssertEqualsDiffAction
extends AnAction
implements TestTreeViewAction {
    @NonNls
    public static final String ACTION_ID = "openAssertEqualsDiff";

    public void actionPerformed(AnActionEvent e) {
        if (!e.getPresentation().isVisible()) {
            return;
        }
        if (!ViewAssertEqualsDiffAction.openDiff(e.getDataContext(), null)) {
            Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            Messages.showInfoMessage((Component)component, (String)"Comparison error was not found", (String)"No Comparison Data Found");
        }
    }

    public static boolean openDiff(DataContext context, @Nullable DiffHyperlink currentHyperlink) {
        DiffHyperlink diffViewerProvider;
        AbstractTestProxy testProxy = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (testProxy != null && (diffViewerProvider = testProxy.getDiffViewerProvider()) != null) {
            int index;
            List<DiffHyperlink> providers = ViewAssertEqualsDiffAction.collectAvailableProviders((TestFrameworkRunningModel)TestTreeView.MODEL_DATA_KEY.getData(context));
            int n = index = currentHyperlink != null ? providers.indexOf(currentHyperlink) : -1;
            if (index == -1) {
                index = providers.indexOf(diffViewerProvider);
            }
            new MyDiffWindow(project, providers, Math.max(0, index)).show();
            return true;
        }
        if (currentHyperlink != null) {
            new MyDiffWindow(project, currentHyperlink).show();
            return true;
        }
        return false;
    }

    private static List<DiffHyperlink> collectAvailableProviders(TestFrameworkRunningModel model) {
        ArrayList<DiffHyperlink> providers = new ArrayList<DiffHyperlink>();
        if (model != null) {
            AbstractTestProxy root = model.getRoot();
            List<? extends AbstractTestProxy> allTests = root.getAllTests();
            for (AbstractTestProxy abstractTestProxy : allTests) {
                if (!abstractTestProxy.isLeaf()) continue;
                providers.addAll(abstractTestProxy.getDiffViewerProviders());
            }
        }
        return providers;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (e.getProject() == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        AbstractTestProxy test = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(e.getDataContext());
        boolean visible = test != null && test.getDiffViewerProvider() != null;
        presentation.setEnabled(test != null);
        presentation.setVisible(visible);
    }

    private static class MyDiffWindow
    extends DiffWindowBase {
        @NotNull
        private final List<DiffHyperlink> myRequests;
        private final int myIndex;

        public MyDiffWindow(@Nullable Project project, @NotNull DiffHyperlink request) {
            if (request == null) {
                MyDiffWindow.$$$reportNull$$$0(0);
            }
            this(project, Collections.singletonList(request), 0);
        }

        public MyDiffWindow(@Nullable Project project, @NotNull List<DiffHyperlink> requests, int index) {
            if (requests == null) {
                MyDiffWindow.$$$reportNull$$$0(1);
            }
            super(project, DiffDialogHints.DEFAULT);
            this.myRequests = requests;
            this.myIndex = index;
        }

        @Override
        @NotNull
        protected DiffRequestProcessor createProcessor() {
            MyTestDiffRequestProcessor myTestDiffRequestProcessor = new MyTestDiffRequestProcessor(this.myProject, this.myRequests, this.myIndex);
            if (myTestDiffRequestProcessor == null) {
                MyDiffWindow.$$$reportNull$$$0(2);
            }
            return myTestDiffRequestProcessor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/actions/ViewAssertEqualsDiffAction$MyDiffWindow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/actions/ViewAssertEqualsDiffAction$MyDiffWindow";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyTestDiffRequestProcessor
        extends TestDiffRequestProcessor {
            public MyTestDiffRequestProcessor(@NotNull Project project, List<DiffHyperlink> requests, int index) {
                if (requests == null) {
                    MyTestDiffRequestProcessor.$$$reportNull$$$0(0);
                }
                super(project, requests, index);
                this.putContextUserData(DiffUserDataKeys.DIALOG_GROUP_KEY, "#com.intellij.execution.junit2.states.ComparisonFailureState$DiffDialog");
            }

            @Override
            protected void setWindowTitle(@NotNull String title) {
                if (title == null) {
                    MyTestDiffRequestProcessor.$$$reportNull$$$0(1);
                }
                MyDiffWindow.this.getWrapper().setTitle(title);
            }

            @Override
            protected void onAfterNavigate() {
                DiffUtil.closeWindow(MyDiffWindow.this.getWrapper().getWindow(), true, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "requests";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "title";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/testframework/actions/ViewAssertEqualsDiffAction$MyDiffWindow$MyTestDiffRequestProcessor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setWindowTitle";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

