/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.UIUtil;

public class SMRunnerUtil {
    private static final Logger LOG = Logger.getInstance((String)SMRunnerUtil.class.getName());

    private SMRunnerUtil() {
    }

    public static void addToInvokeLater(Runnable runnable2) {
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment() && !application.isUnitTestMode()) {
            runnable2.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
        }
    }

    public static void runInEventDispatchThread(Runnable runnable2, ModalityState state2) {
        try {
            ApplicationManager.getApplication().invokeAndWait(runnable2, state2);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }
}

