/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.Alarm;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import sun.swing.SwingUtilities2;

public class HelpTooltip {
    private static Color BACKGROUND_COLOR = new JBColor((Color)Gray.xF7, new Color(4672076));
    private static Color FONT_COLOR = new JBColor(() -> UIUtil.isUnderDarcula() ? Gray.xBF : (SystemInfo.isMac ? Gray.x33 : Gray.x1A));
    private static Color SHORTCUT_COLOR = new JBColor((Color)Gray.x78, (Color)Gray.x87);
    private static Color BORDER_COLOR = new JBColor((Color)Gray.xAD, new Color(6514025));
    private static Border DEFAULT_BORDER;
    private static Border SMALL_BORDER;
    private static final int VGAP;
    private static final int HGAP;
    private static final int MAX_WIDTH;
    private static final String DOTS = "...";
    private static final String PARAGRAPH_SPLITTER = "<p/?>";
    private static final String TOOLTIP_PROPERTY = "JComponent.helpTooltip";
    private String title;
    private String shortcut;
    private String description;
    private LinkLabel link;
    private boolean neverHide;
    private Alignment alignment = Alignment.BOTTOM;
    private JComponent owner;
    private Object masterPopup;
    private ComponentPopupBuilder myPopupBuilder;
    private JBPopup myPopup;
    private Alarm popupAlarm = new Alarm();
    private boolean isOverPopup;
    private boolean isMultiline;
    private int myDismissDelay;
    private MouseAdapter myMouseListener;
    private PropertyChangeListener myPropertyChangeListener;

    public HelpTooltip setTitle(String title) {
        this.title = title;
        return this;
    }

    public HelpTooltip setShortcut(String shortcut) {
        this.shortcut = shortcut;
        return this;
    }

    public HelpTooltip setDescription(String description) {
        this.description = description;
        return this;
    }

    public HelpTooltip setLink(String linkText, Runnable linkAction) {
        this.link = LinkLabel.create((String)linkText, () -> {
            this.hidePopup(true);
            linkAction.run();
        });
        return this;
    }

    public HelpTooltip setNeverHideOnTimeout(boolean neverHide) {
        this.neverHide = neverHide;
        return this;
    }

    public HelpTooltip setLocation(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public void installOn(JComponent component) {
        JPanel tipPanel = new JPanel();
        tipPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                HelpTooltip.this.isOverPopup = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (HelpTooltip.this.link == null || !HelpTooltip.this.link.getBounds().contains(e.getPoint())) {
                    HelpTooltip.this.isOverPopup = false;
                    HelpTooltip.this.hidePopup(false);
                }
            }
        });
        tipPanel.setLayout((LayoutManager)new VerticalLayout(VGAP));
        tipPanel.setBackground(BACKGROUND_COLOR);
        if (StringUtil.isNotEmpty((String)this.title)) {
            tipPanel.add((Component)new Header(), "TOP");
        }
        if (StringUtil.isNotEmpty((String)this.description)) {
            String[] pa;
            for (String p : pa = this.description.split(PARAGRAPH_SPLITTER)) {
                if (p.isEmpty()) continue;
                tipPanel.add((Component)new Paragraph(p), "TOP");
            }
        }
        if (this.link != null) {
            tipPanel.add((Component)this.link, "TOP");
        }
        this.isMultiline = this.isMultiline || StringUtil.isNotEmpty((String)this.description) && (StringUtil.isNotEmpty((String)this.title) || this.link != null);
        tipPanel.setBorder(this.isMultiline ? DEFAULT_BORDER : SMALL_BORDER);
        this.myDismissDelay = Registry.intValue((String)(this.isMultiline ? "ide.helptooltip.full.dismissDelay" : "ide.helptooltip.regular.dismissDelay"));
        this.neverHide = this.neverHide || DarculaButtonUI.isHelpButton(component);
        this.owner = component;
        this.owner.putClientProperty(TOOLTIP_PROPERTY, this);
        this.myPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)tipPanel, null).setBorderColor(BORDER_COLOR).setShowShadow(false);
        this.myMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (HelpTooltip.this.myPopup != null && !HelpTooltip.this.myPopup.isDisposed()) {
                    HelpTooltip.this.myPopup.cancel();
                }
                HelpTooltip.this.scheduleShow(Registry.intValue((String)"ide.tooltip.initialReshowDelay"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HelpTooltip.this.scheduleHide(HelpTooltip.this.link == null, Registry.intValue((String)"ide.tooltip.initialDelay.highlighter"));
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (HelpTooltip.this.myPopup == null || HelpTooltip.this.myPopup.isDisposed()) {
                    HelpTooltip.this.scheduleShow(Registry.intValue((String)"ide.tooltip.reshowDelay"));
                }
            }
        };
        this.myPropertyChangeListener = evt -> {
            if (evt.getNewValue() == null) {
                this.hidePopup(true);
                if (this.owner != null) {
                    this.owner.removeMouseListener(this.myMouseListener);
                    this.owner.removeMouseMotionListener(this.myMouseListener);
                    this.owner.removePropertyChangeListener(this.myPropertyChangeListener);
                    this.owner.putClientProperty(TOOLTIP_PROPERTY, null);
                    this.owner = null;
                    this.masterPopup = null;
                }
            }
        };
        this.owner.addMouseListener(this.myMouseListener);
        this.owner.addMouseMotionListener(this.myMouseListener);
        this.owner.addPropertyChangeListener("ancestor", this.myPropertyChangeListener);
    }

    public static void onShowMasterPopup(@NotNull JComponent owner, @NotNull Object master) {
        HelpTooltip instance;
        if (owner == null) {
            HelpTooltip.$$$reportNull$$$0(0);
        }
        if (master == null) {
            HelpTooltip.$$$reportNull$$$0(1);
        }
        if ((instance = (HelpTooltip)owner.getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance.hidePopup(true);
            instance.masterPopup = master;
        }
    }

    private void scheduleShow(int delay) {
        this.popupAlarm.cancelAllRequests();
        this.popupAlarm.addRequest(() -> {
            if (this.canShow()) {
                this.myPopup = this.myPopupBuilder.createPopup();
                this.myPopup.show(new RelativePoint((Component)this.owner, this.alignment.getPointFor(this.owner)));
                if (!this.neverHide) {
                    this.scheduleHide(true, this.myDismissDelay);
                }
            }
        }, delay);
    }

    private boolean canShow() {
        if (this.masterPopup instanceof JPopupMenu) {
            return !((JPopupMenu)this.masterPopup).isVisible();
        }
        if (this.masterPopup instanceof JBPopup) {
            return !((JBPopup)this.masterPopup).isVisible();
        }
        return true;
    }

    private void scheduleHide(boolean force, int delay) {
        this.popupAlarm.cancelAllRequests();
        this.popupAlarm.addRequest(() -> this.hidePopup(force), delay);
    }

    private void hidePopup(boolean force) {
        this.popupAlarm.cancelAllRequests();
        if (this.myPopup != null && this.myPopup.isVisible() && (!this.isOverPopup || force)) {
            this.myPopup.cancel();
            this.myPopup = null;
        }
    }

    static {
        Object object = SystemInfo.isMac ? JBUI.Borders.empty((int)9, (int)10, (int)11, (int)16) : (DEFAULT_BORDER = SystemInfo.isWindows ? JBUI.Borders.empty((int)7, (int)10, (int)10, (int)16) : JBUI.Borders.empty((int)10, (int)10, (int)10, (int)16));
        SMALL_BORDER = SystemInfo.isMac ? JBUI.Borders.empty((int)4, (int)8, (int)5, (int)8) : (SystemInfo.isWindows ? JBUI.Borders.empty((int)4, (int)8, (int)6, (int)8) : JBUI.Borders.empty((int)5, (int)8, (int)4, (int)8));
        VGAP = JBUI.scale((int)4);
        HGAP = JBUI.scale((int)10);
        MAX_WIDTH = JBUI.scale((int)250);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "owner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "master";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/HelpTooltip";
        objectArray[2] = "onShowMasterPopup";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class Paragraph
    extends JLabel {
        private Paragraph(String text) {
            this.init(text);
        }

        private void init(String text) {
            this.setForeground(FONT_COLOR);
            View v = BasicHTML.createHTMLView(this, String.format("<html>%s</html>", text));
            float width = v.getPreferredSpan(0);
            HelpTooltip.this.isMultiline = HelpTooltip.this.isMultiline || width > (float)MAX_WIDTH;
            this.setText(width > (float)MAX_WIDTH ? String.format("<html><div width=%d>%s</div></html>", MAX_WIDTH, text) : String.format("<html>%s</html>", text));
            if (width > (float)MAX_WIDTH && (v = (View)this.getClientProperty("html")) != null) {
                width = 0.0f;
                for (View row : this.getRows(v)) {
                    float rWidth = row.getPreferredSpan(0);
                    if (!(width < rWidth)) continue;
                    width = rWidth;
                }
                v.setSize(width, v.getPreferredSpan(1));
            }
        }

        private Collection<View> getRows(@NotNull View root) {
            if (root == null) {
                Paragraph.$$$reportNull$$$0(0);
            }
            ArrayList<View> rows = new ArrayList<View>();
            this.visit(root, rows);
            return rows;
        }

        private void visit(@NotNull View v, Collection<View> result2) {
            String cname;
            if (v == null) {
                Paragraph.$$$reportNull$$$0(1);
            }
            if ((cname = v.getClass().getCanonicalName()) != null && cname.contains("ParagraphView.Row")) {
                result2.add(v);
            }
            for (int i = 0; i < v.getViewCount(); ++i) {
                this.visit(v.getView(i), result2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/HelpTooltip$Paragraph";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRows";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class Header
    extends JPanel {
        private final AttributedString titleString;
        private final AttributedString dotString;
        private final AttributedString shortcutString;
        private LineBreakMeasurer lineMeasurer;
        private TextLayout dotLayout;
        private TextLayout shortcutLayout;
        private final int paragraphStart;
        private final int paragraphEnd;

        private Header() {
            this.setOpaque(false);
            Font font = this.getFont();
            Font titleFont = StringUtil.isNotEmpty((String)HelpTooltip.this.description) ? font.deriveFont(1) : font;
            Map<TextAttribute, ?> tfa = titleFont.getAttributes();
            this.titleString = new AttributedString(HelpTooltip.this.title, tfa);
            this.dotString = new AttributedString(HelpTooltip.DOTS, tfa);
            this.shortcutString = StringUtil.isNotEmpty((String)HelpTooltip.this.shortcut) ? new AttributedString(HelpTooltip.this.shortcut, font.getAttributes()) : null;
            AttributedCharacterIterator paragraph = this.titleString.getIterator();
            this.paragraphStart = paragraph.getBeginIndex();
            this.paragraphEnd = paragraph.getEndIndex();
            FontMetrics tfm = this.getFontMetrics(titleFont);
            int titleWidth = SwingUtilities2.stringWidth(this, tfm, HelpTooltip.this.title);
            FontMetrics fm = this.getFontMetrics(font);
            boolean limitWidth = StringUtil.isNotEmpty((String)HelpTooltip.this.description) || HelpTooltip.this.link != null;
            HelpTooltip.this.isMultiline = limitWidth && (titleWidth += StringUtil.isNotEmpty((String)HelpTooltip.this.shortcut) ? HGAP + SwingUtilities2.stringWidth(this, fm, HelpTooltip.this.shortcut) : 0) > MAX_WIDTH;
            this.setPreferredSize(HelpTooltip.this.isMultiline ? new Dimension(MAX_WIDTH, tfm.getHeight() * 2) : new Dimension(titleWidth, fm.getHeight()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setColor(FONT_COLOR);
                GraphicsUtil.setupAntialiasing((Graphics)g2);
                if (this.lineMeasurer == null) {
                    FontRenderContext frc = g2.getFontRenderContext();
                    this.lineMeasurer = new LineBreakMeasurer(this.titleString.getIterator(), frc);
                    LineBreakMeasurer dotMeasurer = new LineBreakMeasurer(this.dotString.getIterator(), frc);
                    this.dotLayout = dotMeasurer.nextLayout(Float.POSITIVE_INFINITY);
                    if (this.shortcutString != null) {
                        LineBreakMeasurer shortcutMeasurer = new LineBreakMeasurer(this.shortcutString.getIterator(), frc);
                        this.shortcutLayout = shortcutMeasurer.nextLayout(Float.POSITIVE_INFINITY);
                    }
                }
                this.lineMeasurer.setPosition(this.paragraphStart);
                float breakWidth = this.getWidth();
                float drawPosY = 0.0f;
                TextLayout layout = null;
                for (int line = 0; this.lineMeasurer.getPosition() < this.paragraphEnd && line < 1; ++line) {
                    layout = this.lineMeasurer.nextLayout(breakWidth);
                    layout.draw(g2, 0.0f, drawPosY += layout.getAscent());
                    drawPosY += layout.getDescent() + layout.getLeading();
                }
                if (this.lineMeasurer.getPosition() < this.paragraphEnd) {
                    if (this.shortcutString != null) {
                        breakWidth -= this.dotLayout.getAdvance() + (float)HGAP + this.shortcutLayout.getAdvance();
                    }
                    layout = this.lineMeasurer.nextLayout(breakWidth);
                    layout.draw(g2, 0.0f, drawPosY += layout.getAscent());
                    if (this.shortcutString != null) {
                        this.dotLayout.draw(g2, layout.getAdvance(), drawPosY);
                        g2.setColor(SHORTCUT_COLOR);
                        this.shortcutLayout.draw(g2, layout.getAdvance() + this.dotLayout.getAdvance() + (float)HGAP, drawPosY);
                    }
                } else if (layout != null && this.shortcutString != null) {
                    g2.setColor(SHORTCUT_COLOR);
                    if (Float.compare((float)this.getWidth() - layout.getAdvance(), this.shortcutLayout.getAdvance() + (float)HGAP) >= 0) {
                        drawPosY = this.shortcutLayout.getAscent();
                        this.shortcutLayout.draw(g2, layout.getAdvance() + (float)HGAP, drawPosY);
                    } else {
                        this.shortcutLayout.draw(g2, 0.0f, drawPosY += this.shortcutLayout.getAscent());
                    }
                }
            }
            finally {
                g2.dispose();
            }
        }
    }

    public static enum Alignment {
        RIGHT{

            @Override
            public Point getPointFor(JComponent owner) {
                Dimension size = owner.getSize();
                return new Point(size.width + JBUI.scale((int)1) - this.xOffset + VGAP, JBUI.scale((int)1) + this.yOffset);
            }
        }
        ,
        BOTTOM{

            @Override
            public Point getPointFor(JComponent owner) {
                Dimension size = owner.getSize();
                return new Point(JBUI.scale((int)1) + this.xOffset, JBUI.scale((int)1) + size.height - this.yOffset + VGAP);
            }
        }
        ,
        HELP_BUTTON{

            @Override
            public Point getPointFor(JComponent owner) {
                Dimension size = owner.getSize();
                return new Point(this.xOffset - JBUI.scale((int)5), JBUI.scale((int)1) + size.height - this.yOffset + VGAP);
            }
        };

        protected final int xOffset = JBUI.scale((int)UIManager.getInt("HelpTooltip.xOffset"));
        protected final int yOffset = JBUI.scale((int)UIManager.getInt("HelpTooltip.yOffset"));

        public abstract Point getPointFor(JComponent var1);
    }
}

