/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class DarculaTextAreaUI
extends BasicTextAreaUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaTextAreaUI();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (SystemInfo.isMac) {
            InputMap inputMap = this.getComponent().getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(38, 0), "caret-up");
            inputMap.put(KeyStroke.getKeyStroke(40, 0), "caret-down");
            inputMap.put(KeyStroke.getKeyStroke(33, 0), "page-up");
            inputMap.put(KeyStroke.getKeyStroke(34, 0), "page-down");
        }
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int position = DarculaUIUtil.getPatchedNextVisualPositionFrom(t, pos, direction);
        return position != -1 ? position : super.getNextVisualPositionFrom(t, pos, b, direction, biasRet);
    }

    @Override
    protected Caret createCaret() {
        return Registry.is((String)"ide.text.mouse.selection.new") ? new TextFieldWithPopupHandlerUI.MyCaret(this.getComponent()) : super.createCaret();
    }
}

