/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.performance.profiler.dtrace;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.icons.AllIcons;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.internal.performance.profiler.dtrace.SudoAuthDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DTraceAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.performance.profiler.dtrace");
    private static final String DTRACE_SUDO_KEY = "DTRACE_SUDO_KEY";

    private static CredentialAttributes getSudoCredAttr() {
        return new CredentialAttributes(DTRACE_SUDO_KEY, SystemProperties.getUserName());
    }

    @Nullable
    private static char[] getCredentials() {
        Credentials cred = PasswordSafe.getInstance().get(DTraceAction.getSudoCredAttr());
        if (cred == null) {
            return null;
        }
        OneTimeString password = cred.getPassword();
        return password != null ? password.toCharArray() : null;
    }

    private static void saveCredentials(char[] password) {
        PasswordSafe.getInstance().set(DTraceAction.getSudoCredAttr(), new Credentials(SystemProperties.getUserName(), password), false);
    }

    public void actionPerformed(AnActionEvent e) {
        if (SystemInfo.isMac) {
            new DTraceWindow().setVisible(true);
        }
    }

    public static class DTraceWindow
    extends JDialog {
        private JTextArea outputArea;
        private JTextField pidField;
        private volatile boolean isRunning = false;
        private OSProcessHandler myProcessHandler;
        private OutputStream mySink;
        File tmpDir;
        String lwawtScr;
        Process p;
        volatile boolean outputData;
        char[] myPasswd;
        boolean rememberPasswd = false;
        final SpeedSearchFilter<ProcessInfo> filter = new SpeedSearchFilter<ProcessInfo>(){

            public boolean canBeHidden(ProcessInfo value) {
                return true;
            }

            public String getIndexedString(ProcessInfo value) {
                return value.getPid() + " " + (value.getExecutableCannonicalPath().isPresent() ? value.getExecutableCannonicalPath().get() : value.getExecutableDisplayName());
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DTraceWindow() {
            super((Frame)null);
            this.setDefaultCloseOperation(2);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 0.1;
            c.gridx = 0;
            c.gridy = 0;
            this.pidField = new JTextField(4);
            this.pidField.setText(ApplicationManager.getApplicationPid());
            this.add((Component)this.pidField, c);
            JPanel buttonPane = new JPanel(new GridLayout(1, 2));
            JButton select = new JButton(AllIcons.Actions.FindPlain);
            select.addActionListener(e -> this.selectProcess());
            buttonPane.add(select);
            c.anchor = 17;
            c.gridx = 1;
            c.gridy = 0;
            c.fill = 3;
            JButton button = new JButton(AllIcons.General.Run);
            button.addActionListener(e -> {
                if (this.isRunning) {
                    button.setIcon(AllIcons.General.Run);
                    this.isRunning = false;
                    this.stopTrace();
                } else {
                    button.setIcon(AllIcons.Actions.Suspend);
                    this.isRunning = true;
                    this.startTrace();
                }
            });
            buttonPane.add(button);
            this.add((Component)buttonPane, c);
            c.weightx = 1.0;
            c.gridx = 2;
            c.gridy = 0;
            c.anchor = 13;
            JButton config = new JButton(AllIcons.General.Gear);
            config.addActionListener(e -> this.authorize(true));
            this.add((Component)config, c);
            c.anchor = 10;
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 4;
            c.fill = 1;
            c.weighty = 1.0;
            this.outputArea = new JTextArea(30, 120);
            this.add((Component)new JBScrollPane((Component)this.outputArea), c);
            try {
                this.tmpDir = FileUtil.createTempDirectory((String)"jtr", (String)"scr", (boolean)true);
                File f = new File(this.tmpDir, "lwawt.d");
                if (!f.createNewFile()) {
                    this.outputArea.setText(f.getAbsolutePath() + " not created");
                } else {
                    InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("com/intellij/internal/performance/profiler/dtrace/lwawt.d");
                    FileOutputStream outputStream = new FileOutputStream(f);
                    try {
                        FileUtil.copy((InputStream)resourceAsStream, (OutputStream)outputStream);
                    }
                    finally {
                        StreamUtil.closeStream((Closeable)resourceAsStream);
                        StreamUtil.closeStream((Closeable)outputStream);
                    }
                }
                this.lwawtScr = f.getAbsolutePath();
            }
            catch (IOException e2) {
                LOG.info((Throwable)e2);
            }
            this.pack();
        }

        @Nullable
        private static SudoAuthDialog showAuthDialog() {
            Ref dialog2 = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                char[] cred = DTraceAction.getCredentials();
                dialog2.set((Object)new SudoAuthDialog());
                ((SudoAuthDialog)dialog2.get()).setup(cred != null ? cred : new char[]{});
                ((SudoAuthDialog)dialog2.get()).showAndGet();
            }, ModalityState.any());
            return (SudoAuthDialog)dialog2.get();
        }

        private void startTrace() {
            try {
                this.outputData = false;
                if (!this.authorize(false)) {
                    return;
                }
                PtyCommandLine dtraceCmd = new PtyCommandLine();
                dtraceCmd.setExePath("sudo");
                dtraceCmd.addParameter("--reset-timestamp");
                dtraceCmd.addParameter("dtrace");
                dtraceCmd.addParameter("-q");
                dtraceCmd.addParameter("-p");
                dtraceCmd.addParameter(this.pidField.getText());
                dtraceCmd.addParameter("-s");
                dtraceCmd.addParameter(this.lwawtScr);
                this.p = dtraceCmd.startProcessWithPty(CommandLineUtil.toCommandLine((String)dtraceCmd.getExePath(), (List)dtraceCmd.getParametersList().getList()), false);
                this.myProcessHandler = new OSProcessHandler(this.p, dtraceCmd.toString());
                this.myProcessHandler.setHasPty(true);
                this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            if (event.getText().contains("Sorry, try again.")) {
                                this.authorize(true);
                                try {
                                    mySink.write((String.copyValueOf(myPasswd) + "\n").getBytes(Charset.forName("UTF-8")));
                                    mySink.flush();
                                }
                                catch (IOException e) {
                                    LOG.info((Throwable)e);
                                }
                            } else if (event.getText().contains("</data>")) {
                                outputData = false;
                            } else if (!event.getText().contains("<data>")) {
                                if (rememberPasswd) {
                                    DTraceAction.saveCredentials(myPasswd);
                                }
                                if (outputData) {
                                    outputArea.setText(outputArea.getText() + event.getText());
                                }
                            } else {
                                outputData = true;
                                outputArea.setText("");
                            }
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            LOG.info("STDERR: " + event.getText());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/internal/performance/profiler/dtrace/DTraceAction$DTraceWindow$1";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                this.mySink = this.myProcessHandler.getProcessInput();
                this.mySink.write((String.copyValueOf(this.myPasswd) + "\n").getBytes(Charset.forName("UTF-8")));
                this.mySink.flush();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            this.myProcessHandler.startNotify();
        }

        private boolean authorize(boolean reset) {
            char[] cred = DTraceAction.getCredentials();
            if (cred == null || reset) {
                SudoAuthDialog dialog2 = DTraceWindow.showAuthDialog();
                if (dialog2 == null || !dialog2.isOK()) {
                    return false;
                }
                this.myPasswd = dialog2.getPassword();
                this.rememberPasswd = dialog2.isRememberPassword();
                if (this.rememberPasswd) {
                    DTraceAction.saveCredentials(this.myPasswd);
                }
            } else {
                this.myPasswd = cred;
            }
            return true;
        }

        private void selectProcess() {
            final ProcessInfo[] processList = OSProcessUtil.getProcessList();
            ListPopupStep<ProcessInfo> step = new ListPopupStep<ProcessInfo>(){

                @NotNull
                public List<ProcessInfo> getValues() {
                    List<ProcessInfo> list2 = Arrays.asList(processList);
                    if (list2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return list2;
                }

                public boolean isSelectable(ProcessInfo value) {
                    return true;
                }

                @Nullable
                public Icon getIconFor(ProcessInfo aValue) {
                    return null;
                }

                @NotNull
                public String getTextFor(ProcessInfo value) {
                    String string = value.getPid() + " " + (value.getExecutableCannonicalPath().isPresent() ? value.getExecutableCannonicalPath().get() : value.getExecutableDisplayName());
                    if (string == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @Nullable
                public ListSeparator getSeparatorAbove(ProcessInfo value) {
                    return null;
                }

                public int getDefaultOptionIndex() {
                    return 0;
                }

                @Nullable
                public String getTitle() {
                    return null;
                }

                @Nullable
                public PopupStep onChosen(ProcessInfo selectedValue, boolean finalChoice) {
                    return null;
                }

                public boolean hasSubstep(ProcessInfo selectedValue) {
                    return false;
                }

                public void canceled() {
                }

                public boolean isMnemonicsNavigationEnabled() {
                    return false;
                }

                @Nullable
                public MnemonicNavigationFilter<ProcessInfo> getMnemonicNavigationFilter() {
                    return null;
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @Nullable
                public SpeedSearchFilter<ProcessInfo> getSpeedSearchFilter() {
                    return filter;
                }

                public boolean isAutoSelectionEnabled() {
                    return false;
                }

                @Nullable
                public Runnable getFinalRunnable() {
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/internal/performance/profiler/dtrace/DTraceAction$DTraceWindow$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getValues";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getTextFor";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
            JList mainList = ((ListPopupImpl)popup2).getList();
            ListSelectionListener listener2 = event -> {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                Object item = ((JList)event.getSource()).getSelectedValue();
                this.pidField.setText(Integer.toString(((ProcessInfo)item).getPid()));
            };
            popup2.addListSelectionListener(listener2);
            listener2.valueChanged(new ListSelectionEvent(mainList, mainList.getMinSelectionIndex(), mainList.getMaxSelectionIndex(), false));
            popup2.showInFocusCenter();
        }

        private void stopTrace() {
            try {
                this.mySink.write(3);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }

        public void setPassword(char[] password) {
            this.myPasswd = password;
        }
    }
}

