/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.Map;

public class StartMarkAction
extends BasicUndoableAction {
    private static final Map<Project, StartMarkAction> ourCurrentMarks = new HashMap<Project, StartMarkAction>();
    private String myCommandName;
    private boolean myGlobal;
    private Document myDocument;

    private StartMarkAction(Editor editor, String commandName) {
        super(new DocumentReference[]{DocumentReferenceManager.getInstance().create(editor.getDocument())});
        this.myCommandName = commandName;
        this.myDocument = editor.getDocument();
    }

    public void undo() {
    }

    public void redo() {
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public void setCommandName(String commandName) {
        this.myCommandName = commandName;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public static void checkCleared() {
        try {
            assert (ourCurrentMarks.isEmpty()) : ourCurrentMarks.values();
        }
        finally {
            ourCurrentMarks.clear();
        }
    }

    public static StartMarkAction start(Editor editor, Project project, String commandName) throws AlreadyStartedException {
        StartMarkAction existingMark = ourCurrentMarks.get(project);
        if (existingMark != null) {
            throw new AlreadyStartedException(existingMark.myCommandName, existingMark.myDocument, existingMark.getAffectedDocuments());
        }
        StartMarkAction markAction = new StartMarkAction(editor, commandName);
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)markAction);
        ourCurrentMarks.put(project, markAction);
        return markAction;
    }

    public static StartMarkAction canStart(Project project) {
        return ourCurrentMarks.get(project);
    }

    static void markFinished(Project project) {
        StartMarkAction existingMark = ourCurrentMarks.remove(project);
        if (existingMark != null) {
            existingMark.myDocument = null;
        }
    }

    public static class AlreadyStartedException
    extends Exception {
        private final DocumentReference[] myAffectedDocuments;
        private Document myDocument;

        public AlreadyStartedException(String commandName, Document document, DocumentReference[] documentRefs) {
            super("Unable to start inplace refactoring:\n" + commandName + " is not finished yet.");
            this.myAffectedDocuments = documentRefs;
            this.myDocument = document;
        }

        public DocumentReference[] getAffectedDocuments() {
            return this.myAffectedDocuments;
        }

        public Document getDocument() {
            return this.myDocument;
        }
    }
}

