/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.EditorSource;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;

public class CurrentLineMarker
implements CaretListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.CurrentLineMarker");
    private Editor myEditor;
    private RangeHighlighter myHighlighter = null;
    public static final int LAYER = 2001;

    public void attach(EditorSource editorSource) {
        if (this.myEditor != null) {
            this.hide();
        }
        this.myEditor = editorSource.getEditor();
        if (this.myEditor == null) {
            return;
        }
        final CaretModel caretModel = this.myEditor.getCaretModel();
        caretModel.addCaretListener((CaretListener)this);
        editorSource.addDisposable(new Disposable(){

            public void dispose() {
                caretModel.removeCaretListener((CaretListener)CurrentLineMarker.this);
            }
        });
    }

    public void set() {
        if (this.myEditor == null) {
            return;
        }
        this.hide();
        int line = this.myEditor.getCaretModel().getLogicalPosition().line;
        this.myHighlighter = line < this.myEditor.getDocument().getLineCount() ? this.myEditor.getMarkupModel().addLineHighlighter(line, 2001, null) : null;
    }

    private boolean isHiden() {
        return this.myHighlighter == null;
    }

    void hide() {
        if (this.myHighlighter != null) {
            LOG.assertTrue(this.myEditor != null);
            this.myHighlighter.dispose();
            this.myHighlighter = null;
        }
    }

    public void caretPositionChanged(CaretEvent e) {
        if (this.isHiden()) {
            return;
        }
        this.set();
    }
}

