/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.external.BinaryDiffTool;
import com.intellij.openapi.diff.impl.external.CompositeDiffTool;
import com.intellij.openapi.diff.impl.external.ExtCompareFiles;
import com.intellij.openapi.diff.impl.external.ExtCompareFolders;
import com.intellij.openapi.diff.impl.external.ExtMergeFiles;
import com.intellij.openapi.diff.impl.external.FrameDiffTool;
import com.intellij.openapi.diff.impl.external.MultiLevelDiffTool;
import com.intellij.openapi.diff.impl.mergeTool.MergeTool;
import com.intellij.openapi.diff.impl.processing.HighlightMode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SmartList;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.ExternalizablePropertyContainer;
import com.intellij.util.config.Externalizer;
import com.intellij.util.config.StringProperty;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DiffManager", storages={@Storage(value="diff.xml"), @Storage(value="other.xml", deprecated=true)})
@Deprecated
public class DiffManagerImpl
extends DiffManager
implements PersistentStateComponent<Element> {
    public static final int FULL_DIFF_DIVIDER_POLYGONS_OFFSET = 3;
    private static final Logger LOG = Logger.getInstance(DiffManagerImpl.class);
    private static final Externalizer<String> TOOL_PATH_UPDATE = new Externalizer<String>(){
        @NonNls
        private static final String NEW_VALUE = "newValue";

        public String readValue(Element dataElement) {
            String path = dataElement.getAttributeValue(NEW_VALUE);
            if (path != null) {
                return path;
            }
            String prevValue = dataElement.getAttributeValue("value");
            return prevValue != null ? prevValue.trim() : null;
        }

        public void writeValue(Element dataElement, String path) {
            dataElement.setAttribute("value", path);
            dataElement.setAttribute(NEW_VALUE, path);
        }
    };
    public static final StringProperty FOLDERS_TOOL = new StringProperty("foldersTool", "");
    public static final StringProperty FILES_TOOL = new StringProperty("filesTool", "");
    public static final StringProperty MERGE_TOOL = new StringProperty("mergeTool", "");
    public static final StringProperty MERGE_TOOL_PARAMETERS = new StringProperty("mergeToolParameters", "");
    public static final BooleanProperty ENABLE_FOLDERS = new BooleanProperty("enableFolders", false);
    public static final BooleanProperty ENABLE_FILES = new BooleanProperty("enableFiles", false);
    public static final BooleanProperty ENABLE_MERGE = new BooleanProperty("enableMerge", false);
    private final ExternalizablePropertyContainer myProperties;
    private final List<DiffTool> myAdditionTools = new SmartList();
    public static final DiffTool INTERNAL_DIFF = new FrameDiffTool();
    private static final MarkupEditorFilter DIFF_EDITOR_FILTER = new MarkupEditorFilter(){

        public boolean avaliableIn(Editor editor) {
            return DiffUtil.isDiffEditor(editor);
        }
    };
    private ComparisonPolicy myComparisonPolicy = ComparisonPolicy.DEFAULT;
    private HighlightMode myHighlightMode = HighlightMode.BY_WORD;
    @NonNls
    public static final String COMPARISON_POLICY_ATTR_NAME = "COMPARISON_POLICY";
    @NonNls
    public static final String HIGHLIGHT_MODE_ATTR_NAME = "HIGHLIGHT_MODE";

    public DiffManagerImpl() {
        this.myProperties = new ExternalizablePropertyContainer();
        this.myProperties.registerProperty(ENABLE_FOLDERS);
        this.myProperties.registerProperty((AbstractProperty)FOLDERS_TOOL, TOOL_PATH_UPDATE);
        this.myProperties.registerProperty(ENABLE_FILES);
        this.myProperties.registerProperty((AbstractProperty)FILES_TOOL, TOOL_PATH_UPDATE);
        this.myProperties.registerProperty(ENABLE_MERGE);
        this.myProperties.registerProperty((AbstractProperty)MERGE_TOOL, TOOL_PATH_UPDATE);
        this.myProperties.registerProperty(MERGE_TOOL_PARAMETERS);
    }

    public DiffTool getIdeaDiffTool() {
        return INTERNAL_DIFF;
    }

    public DiffTool getDiffTool() {
        Object[] standardTools;
        if (!(ENABLE_FILES.value((AbstractProperty.AbstractPropertyContainer)this.myProperties) && ENABLE_FOLDERS.value((AbstractProperty.AbstractPropertyContainer)this.myProperties) && ENABLE_MERGE.value((AbstractProperty.AbstractPropertyContainer)this.myProperties))) {
            DiffTool[] embeddableTools = new DiffTool[]{INTERNAL_DIFF, MergeTool.INSTANCE, BinaryDiffTool.INSTANCE};
            standardTools = new DiffTool[]{ExtCompareFolders.INSTANCE, ExtCompareFiles.INSTANCE, ExtMergeFiles.INSTANCE, new MultiLevelDiffTool(Arrays.asList(embeddableTools)), INTERNAL_DIFF, MergeTool.INSTANCE, BinaryDiffTool.INSTANCE};
        } else {
            standardTools = new DiffTool[]{ExtCompareFolders.INSTANCE, ExtCompareFiles.INSTANCE, ExtMergeFiles.INSTANCE, INTERNAL_DIFF, MergeTool.INSTANCE, BinaryDiffTool.INSTANCE};
        }
        if (this.myAdditionTools.isEmpty()) {
            return new CompositeDiffTool((DiffTool[])standardTools);
        }
        ArrayList<DiffTool> allTools = new ArrayList<DiffTool>(this.myAdditionTools);
        ContainerUtil.addAll(allTools, (Object[])standardTools);
        return new CompositeDiffTool(allTools);
    }

    public boolean registerDiffTool(@NotNull DiffTool tool) throws NullPointerException {
        if (tool == null) {
            DiffManagerImpl.$$$reportNull$$$0(0);
        }
        if (this.myAdditionTools.contains(tool)) {
            return false;
        }
        this.myAdditionTools.add(tool);
        return true;
    }

    public void unregisterDiffTool(DiffTool tool) {
        this.myAdditionTools.remove(tool);
        LOG.assertTrue(!this.myAdditionTools.contains(tool));
    }

    public List<DiffTool> getAdditionTools() {
        return this.myAdditionTools;
    }

    public MarkupEditorFilter getDiffEditorFilter() {
        return DIFF_EDITOR_FILTER;
    }

    public DiffPanel createDiffPanel(Window window, @NotNull Project project, DiffTool parentTool) {
        if (project == null) {
            DiffManagerImpl.$$$reportNull$$$0(1);
        }
        return new DiffPanelImpl(window, project, true, true, 3, parentTool);
    }

    public DiffPanel createDiffPanel(Window window, @NotNull Project project, @NotNull Disposable parentDisposable, DiffTool parentTool) {
        if (project == null) {
            DiffManagerImpl.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            DiffManagerImpl.$$$reportNull$$$0(3);
        }
        DiffPanel diffPanel = this.createDiffPanel(window, project, parentTool);
        Disposer.register((Disposable)parentDisposable, (Disposable)diffPanel);
        return diffPanel;
    }

    public static DiffManagerImpl getInstanceEx() {
        return (DiffManagerImpl)DiffManager.getInstance();
    }

    @Nullable
    public Element getState() {
        Element state2 = new Element("state");
        this.myProperties.writeExternal(state2);
        if (this.myComparisonPolicy != ComparisonPolicy.DEFAULT) {
            state2.setAttribute(COMPARISON_POLICY_ATTR_NAME, this.myComparisonPolicy.getName());
        }
        if (this.myHighlightMode != HighlightMode.BY_WORD) {
            state2.setAttribute(HIGHLIGHT_MODE_ATTR_NAME, this.myHighlightMode.name());
        }
        return state2;
    }

    public void loadState(Element state2) {
        String modeName;
        this.myProperties.readExternal(state2);
        String policyName = state2.getAttributeValue(COMPARISON_POLICY_ATTR_NAME);
        if (policyName != null) {
            for (ComparisonPolicy policy : ComparisonPolicy.getAllInstances()) {
                if (!policy.getName().equals(policyName)) continue;
                this.myComparisonPolicy = policy;
                break;
            }
        }
        if ((modeName = state2.getAttributeValue(HIGHLIGHT_MODE_ATTR_NAME)) != null) {
            try {
                this.myHighlightMode = HighlightMode.valueOf((String)modeName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public AbstractProperty.AbstractPropertyContainer getProperties() {
        return this.myProperties;
    }

    static DiffPanel createDiffPanel(DiffRequest data, Window window, @NotNull Disposable parentDisposable, FrameDiffTool tool) {
        if (parentDisposable == null) {
            DiffManagerImpl.$$$reportNull$$$0(4);
        }
        DiffPanel diffPanel = null;
        try {
            diffPanel = DiffManager.getInstance().createDiffPanel(window, data.getProject(), parentDisposable, (DiffTool)tool);
            int contentCount = data.getContents().length;
            LOG.assertTrue(contentCount == 2, (Object)String.valueOf(contentCount));
            LOG.assertTrue(data.getContentTitles().length == contentCount);
            diffPanel.setDiffRequest(data);
            return diffPanel;
        }
        catch (RuntimeException e) {
            if (diffPanel != null) {
                Disposer.dispose(diffPanel);
            }
            throw e;
        }
    }

    @NotNull
    public ComparisonPolicy getComparisonPolicy() {
        ComparisonPolicy comparisonPolicy = this.myComparisonPolicy;
        if (comparisonPolicy == null) {
            DiffManagerImpl.$$$reportNull$$$0(5);
        }
        return comparisonPolicy;
    }

    public void setComparisonPolicy(@NotNull ComparisonPolicy value) {
        if (value == null) {
            DiffManagerImpl.$$$reportNull$$$0(6);
        }
        this.myComparisonPolicy = value;
    }

    @NotNull
    public HighlightMode getHighlightMode() {
        HighlightMode highlightMode = this.myHighlightMode;
        if (highlightMode == null) {
            DiffManagerImpl.$$$reportNull$$$0(7);
        }
        return highlightMode;
    }

    public void setHighlightMode(@NotNull HighlightMode highlightMode) {
        if (highlightMode == null) {
            DiffManagerImpl.$$$reportNull$$$0(8);
        }
        this.myHighlightMode = highlightMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/external/DiffManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/external/DiffManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparisonPolicy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerDiffTool";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDiffPanel";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setComparisonPolicy";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

