/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretStateTransferableData;
import com.intellij.openapi.editor.ClipboardTextPerCaretSplitter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorCopyPasteHelperImpl
extends EditorCopyPasteHelper {
    public void copySelectionToClipboard(@NotNull Editor editor) {
        String s;
        if (editor == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<TextBlockTransferableData> extraData = new ArrayList<TextBlockTransferableData>();
        String string = s = editor.getCaretModel().supportsMultipleCarets() ? EditorCopyPasteHelperImpl.getSelectedTextForClipboard(editor, extraData) : editor.getSelectionModel().getSelectedText();
        if (s == null) {
            return;
        }
        s = TextBlockTransferable.convertLineSeparators(s, "\n", extraData);
        Transferable contents = editor.getCaretModel().supportsMultipleCarets() ? new TextBlockTransferable(s, extraData, null) : new StringSelection(s);
        CopyPasteManager.getInstance().setContents(contents);
    }

    public static String getSelectedTextForClipboard(@NotNull Editor editor, @NotNull Collection<TextBlockTransferableData> extraDataCollector) {
        if (editor == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(1);
        }
        if (extraDataCollector == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(2);
        }
        StringBuilder buf = new StringBuilder();
        String separator = "";
        List carets = editor.getCaretModel().getAllCarets();
        int[] startOffsets = new int[carets.size()];
        int[] endOffsets = new int[carets.size()];
        for (int i = 0; i < carets.size(); ++i) {
            buf.append(separator);
            String caretSelectedText = ((Caret)carets.get(i)).getSelectedText();
            startOffsets[i] = buf.length();
            if (caretSelectedText != null) {
                buf.append(caretSelectedText);
            }
            endOffsets[i] = buf.length();
            separator = "\n";
        }
        extraDataCollector.add(new CaretStateTransferableData(startOffsets, endOffsets));
        return buf.toString();
    }

    @Nullable
    public TextRange[] pasteFromClipboard(@NotNull Editor editor) {
        Transferable transferable;
        if (editor == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(3);
        }
        return (transferable = EditorModificationUtil.getContentsToPasteToEditor(null)) == null ? null : this.pasteTransferable(editor, transferable);
    }

    @Nullable
    public TextRange[] pasteTransferable(final @NotNull Editor editor, @NotNull Transferable content) {
        String text;
        if (editor == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(4);
        }
        if (content == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(5);
        }
        if ((text = EditorModificationUtil.getStringContent((Transferable)content)) == null) {
            return null;
        }
        if (editor.getCaretModel().supportsMultipleCarets()) {
            CaretStateTransferableData caretData = null;
            int caretCount = editor.getCaretModel().getCaretCount();
            if (caretCount == 1 && editor.isColumnMode()) {
                int pastedLineCount = LineTokenizer.calcLineCount((CharSequence)text, (boolean)true);
                EditorModificationUtil.deleteSelectedText((Editor)editor);
                Caret caret = editor.getCaretModel().getPrimaryCaret();
                for (int i = 0; i < pastedLineCount - 1 && (caret = caret.clone(false)) != null; ++i) {
                }
                caretCount = editor.getCaretModel().getCaretCount();
            } else {
                caretData = CaretStateTransferableData.getFrom(content);
            }
            final TextRange[] ranges = new TextRange[caretCount];
            final Iterator<String> segments = new ClipboardTextPerCaretSplitter().split(text, caretData, caretCount).iterator();
            final int[] index = new int[]{0};
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    String normalizedText = TextBlockTransferable.convertLineSeparators(editor, (String)segments.next());
                    normalizedText = EditorCopyPasteHelperImpl.trimTextIfNeed(editor, normalizedText);
                    int caretOffset = caret.getOffset();
                    int n = index[0];
                    index[0] = n + 1;
                    ranges[n] = new TextRange(caretOffset, caretOffset + normalizedText.length());
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)normalizedText, (boolean)false, (boolean)true);
                }
            });
            return ranges;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        String normalizedText = TextBlockTransferable.convertLineSeparators(editor, text);
        normalizedText = EditorCopyPasteHelperImpl.trimTextIfNeed(editor, normalizedText);
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)normalizedText, (boolean)false, (boolean)true);
        return new TextRange[]{new TextRange(caretOffset, caretOffset + text.length())};
    }

    private static String trimTextIfNeed(Editor editor, String text) {
        Document document;
        JComponent contentComponent = editor.getContentComponent();
        if (contentComponent instanceof JTextComponent && (document = ((JTextComponent)contentComponent).getDocument()) != null && document.getProperty("trimTextOnPaste") == Boolean.TRUE) {
            return text.trim();
        }
        return text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraDataCollector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/EditorCopyPasteHelperImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "copySelectionToClipboard";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedTextForClipboard";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "pasteFromClipboard";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "pasteTransferable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

