/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.util.DocumentUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class InlayImpl
extends RangeMarkerImpl
implements Inlay,
Getter<InlayImpl> {
    private static final Key<Integer> ORDER_KEY = Key.create((String)"inlay.order.key");
    @NotNull
    private final EditorImpl myEditor;
    private final boolean myRelatedToPrecedingText;
    final int myOriginalOffset;
    int myOffsetBeforeDisposal;
    private int myWidthInPixels;
    @NotNull
    private final EditorCustomElementRenderer myRenderer;

    InlayImpl(@NotNull EditorImpl editor, int offset, boolean relatesToPreceedingText, @NotNull EditorCustomElementRenderer renderer) {
        if (editor == null) {
            InlayImpl.$$$reportNull$$$0(0);
        }
        if (renderer == null) {
            InlayImpl.$$$reportNull$$$0(1);
        }
        super(editor.getDocument(), offset, offset, false);
        this.myOffsetBeforeDisposal = -1;
        this.myEditor = editor;
        this.myRelatedToPrecedingText = relatesToPreceedingText;
        this.myOriginalOffset = offset;
        this.myRenderer = renderer;
        this.doUpdateSize();
        this.myEditor.getInlayModel().myInlayTree.addInterval(this, offset, offset, false, false, relatesToPreceedingText, 0);
    }

    public void updateSize() {
        this.doUpdateSize();
        this.myEditor.getInlayModel().notifyChanged(this);
    }

    public void repaint() {
        if (this.isValid() && !this.myEditor.isDisposed()) {
            int offset = this.getOffset();
            this.myEditor.repaint(offset, offset, false);
        }
    }

    private void doUpdateSize() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Editor)this.myEditor);
        if (this.myWidthInPixels <= 0) {
            throw new IllegalArgumentException("Positive width should be defined for an inline element");
        }
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            InlayImpl.$$$reportNull$$$0(2);
        }
        super.changedUpdateImpl(e);
        if (this.isValid() && DocumentUtil.isInsideSurrogatePair(this.getDocument(), this.intervalStart())) {
            this.invalidate(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onReTarget(int startOffset, int endOffset, int destOffset) {
        if (DocumentUtil.isInsideSurrogatePair(this.getDocument(), this.getOffset())) {
            this.myEditor.getInlayModel().myMoveInProgress = true;
            try {
                this.invalidate("moved inside surrogate pair on retarget");
            }
            finally {
                this.myEditor.getInlayModel().myMoveInProgress = false;
            }
        }
    }

    @Override
    public void dispose() {
        if (this.isValid()) {
            this.myOffsetBeforeDisposal = this.getOffset();
            InlayModelImpl inlayModel = this.myEditor.getInlayModel();
            List<Inlay> inlays = inlayModel.getInlineElementsInRange(this.myOffsetBeforeDisposal, this.myOffsetBeforeDisposal);
            this.putUserData(ORDER_KEY, inlays.indexOf(this));
            inlayModel.myInlayTree.removeInterval(this);
            inlayModel.notifyRemoved(this);
        }
    }

    public int getOffset() {
        return this.myOffsetBeforeDisposal == -1 ? this.getStartOffset() : this.myOffsetBeforeDisposal;
    }

    public boolean isRelatedToPrecedingText() {
        return this.myRelatedToPrecedingText;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        int offset = this.getOffset();
        VisualPosition pos = this.myEditor.offsetToVisualPosition(offset);
        List<Inlay> inlays = this.myEditor.getInlayModel().getInlineElementsInRange(offset, offset);
        int order = inlays.indexOf(this);
        VisualPosition visualPosition = new VisualPosition(pos.line, pos.column + order, true);
        if (visualPosition == null) {
            InlayImpl.$$$reportNull$$$0(3);
        }
        return visualPosition;
    }

    @NotNull
    public EditorCustomElementRenderer getRenderer() {
        EditorCustomElementRenderer editorCustomElementRenderer = this.myRenderer;
        if (editorCustomElementRenderer == null) {
            InlayImpl.$$$reportNull$$$0(4);
        }
        return editorCustomElementRenderer;
    }

    public int getWidthInPixels() {
        return this.myWidthInPixels;
    }

    public InlayImpl get() {
        return this;
    }

    int getOrder() {
        Integer value = (Integer)this.getUserData(ORDER_KEY);
        return value == null ? -1 : value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/InlayImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/InlayImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

