/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileSaverDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.MacFileSaverDialog;
import com.intellij.ui.mac.MacPathChooserDialog;
import com.intellij.ui.win.WinPathChooserDialog;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserFactoryImpl
extends FileChooserFactory {
    @NotNull
    public FileChooserDialog createFileChooser(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @Nullable Component parent) {
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(0);
        }
        if (FileChooserFactoryImpl.useNativeMacChooser(descriptor2)) {
            MacPathChooserDialog macPathChooserDialog = new MacPathChooserDialog(descriptor2, parent, project);
            if (macPathChooserDialog == null) {
                FileChooserFactoryImpl.$$$reportNull$$$0(1);
            }
            return macPathChooserDialog;
        }
        if (parent != null) {
            FileChooserDialogImpl fileChooserDialogImpl = new FileChooserDialogImpl(descriptor2, parent, project);
            if (fileChooserDialogImpl == null) {
                FileChooserFactoryImpl.$$$reportNull$$$0(2);
            }
            return fileChooserDialogImpl;
        }
        FileChooserDialogImpl fileChooserDialogImpl = new FileChooserDialogImpl(descriptor2, project);
        if (fileChooserDialogImpl == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(3);
        }
        return fileChooserDialogImpl;
    }

    @NotNull
    public PathChooserDialog createPathChooser(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @Nullable Component parent) {
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(4);
        }
        if (FileChooserFactoryImpl.useNativeMacChooser(descriptor2)) {
            MacPathChooserDialog macPathChooserDialog = new MacPathChooserDialog(descriptor2, parent, project);
            if (macPathChooserDialog == null) {
                FileChooserFactoryImpl.$$$reportNull$$$0(5);
            }
            return macPathChooserDialog;
        }
        if (FileChooserFactoryImpl.useNativeWinChooser()) {
            WinPathChooserDialog winPathChooserDialog = new WinPathChooserDialog(descriptor2, parent, project);
            if (winPathChooserDialog == null) {
                FileChooserFactoryImpl.$$$reportNull$$$0(6);
            }
            return winPathChooserDialog;
        }
        if (parent != null) {
            FileChooserDialogImpl fileChooserDialogImpl = new FileChooserDialogImpl(descriptor2, parent, project);
            if (fileChooserDialogImpl == null) {
                FileChooserFactoryImpl.$$$reportNull$$$0(7);
            }
            return fileChooserDialogImpl;
        }
        FileChooserDialogImpl fileChooserDialogImpl = new FileChooserDialogImpl(descriptor2, project);
        if (fileChooserDialogImpl == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(8);
        }
        return fileChooserDialogImpl;
    }

    private static boolean useNativeWinChooser() {
        return SystemInfo.isWindows && Registry.is((String)"ide.win.file.chooser.native");
    }

    private static boolean useNativeMacChooser(FileChooserDescriptor descriptor2) {
        return SystemInfo.isMac && !descriptor2.isForcedToUseIdeaFileChooser() && SystemProperties.getBooleanProperty((String)"native.mac.file.chooser.enabled", (boolean)true) && Registry.is((String)"ide.mac.file.chooser.native") && SystemInfo.isJetBrainsJvm;
    }

    @NotNull
    public FileTextField createFileTextField(@NotNull FileChooserDescriptor descriptor2, boolean showHidden, @Nullable Disposable parent) {
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(9);
        }
        FileTextFieldImpl.Vfs vfs = new FileTextFieldImpl.Vfs(new JTextField(), FileChooserFactoryImpl.getMacroMap(), parent, new LocalFsFinder.FileChooserFilter(descriptor2, showHidden));
        if (vfs == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(10);
        }
        return vfs;
    }

    public void installFileCompletion(@NotNull JTextField field, @NotNull FileChooserDescriptor descriptor2, boolean showHidden, @Nullable Disposable parent) {
        if (field == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(11);
        }
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(12);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            new FileTextFieldImpl.Vfs(field, FileChooserFactoryImpl.getMacroMap(), parent, new LocalFsFinder.FileChooserFilter(descriptor2, showHidden));
        }
    }

    public static Map<String, String> getMacroMap() {
        PathMacros macros = PathMacros.getInstance();
        Set allNames = macros.getAllMacroNames();
        THashMap map2 = new THashMap(allNames.size());
        for (String eachMacroName : allNames) {
            map2.put("$" + eachMacroName + "$", macros.getValue(eachMacroName));
        }
        return map2;
    }

    @NotNull
    public FileSaverDialog createSaveFileDialog(@NotNull FileSaverDescriptor descriptor2, @Nullable Project project) {
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(13);
        }
        Object object = SystemInfo.isMac && Registry.is((String)"ide.mac.native.save.dialog") ? new MacFileSaverDialog(descriptor2, project) : new FileSaverDialogImpl(descriptor2, project);
        if (object == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(14);
        }
        return object;
    }

    @NotNull
    public FileSaverDialog createSaveFileDialog(@NotNull FileSaverDescriptor descriptor2, @NotNull Component parent) {
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(15);
        }
        if (parent == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(16);
        }
        Object object = SystemInfo.isMac && Registry.is((String)"ide.mac.native.save.dialog") ? new MacFileSaverDialog(descriptor2, parent) : new FileSaverDialogImpl(descriptor2, parent);
        if (object == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(17);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileChooser";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathChooser";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileTextField";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createSaveFileDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFileChooser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPathChooser";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFileTextField";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "installFileCompletion";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createSaveFileDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

